/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions;

import com.google.common.collect.ImmutableList;
import gregtech.api.unification.Element;
import gregtech.api.unification.material.IMaterialHandler;
import gregtech.api.unification.material.MaterialIconSet;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.FluidMaterial;
import gregtech.api.unification.material.type.GemMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.material.type.SolidMaterial;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;

@IMaterialHandler.RegisterMaterialHandler
public class GAMaterials
implements IMaterialHandler {
    static long EXT2_METAL = DustMaterial.MatFlags.GENERATE_PLATE | SolidMaterial.MatFlags.GENERATE_ROD | IngotMaterial.MatFlags.GENERATE_BOLT_SCREW | SolidMaterial.MatFlags.GENERATE_GEAR | IngotMaterial.MatFlags.GENERATE_FOIL | IngotMaterial.MatFlags.GENERATE_FINE_WIRE;
    public static final FluidMaterial FISH_OIL = new FluidMaterial(975, "fish_oil", 14467421, MaterialIconSet.FLUID, ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final FluidMaterial RAW_GROWTH_MEDIUM = new FluidMaterial(940, "raw_growth_medium", 10777425, MaterialIconSet.FLUID, ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final FluidMaterial STERILE_GROWTH_MEDIUM = new FluidMaterial(939, "sterilized_growth_medium", 11306862, MaterialIconSet.FLUID, ImmutableList.of(), FluidMaterial.MatFlags.GENERATE_FLUID_BLOCK | Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final DustMaterial MEAT = new DustMaterial(938, "meat", 0xC14C4C, MaterialIconSet.SAND, 1, ImmutableList.of(), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final FluidMaterial NEUTRAL_MATTER = new FluidMaterial(883, "neutral_matter", 3956968, MaterialIconSet.FLUID, ImmutableList.of(), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final FluidMaterial POSITIVE_MATTER = new FluidMaterial(882, "positive_matter", 11279131, MaterialIconSet.FLUID, ImmutableList.of(), Material.MatFlags.DISABLE_DECOMPOSITION);
    public static final IngotMaterial NEUTRONIUM = new IngotMaterial(972, "neutronium", 0xC3C3C3, MaterialIconSet.METALLIC, 6, ImmutableList.of(), EXT2_METAL | IngotMaterial.MatFlags.GENERATE_RING | IngotMaterial.MatFlags.GENERATE_ROTOR | IngotMaterial.MatFlags.GENERATE_SMALL_GEAR | SolidMaterial.MatFlags.GENERATE_LONG_ROD | SolidMaterial.MatFlags.GENERATE_FRAME, Element.valueOf((String)"Nt"), 24.0f, 12.0f, 655360);
    public static final GemMaterial LIGNITE_COKE = new GemMaterial(879, "lignite_coke", 9135204, MaterialIconSet.LIGNITE, 1, ImmutableList.of((Object)new MaterialStack((Material)Materials.Carbon, 1L)), Material.MatFlags.DECOMPOSITION_BY_ELECTROLYZING | SolidMaterial.MatFlags.MORTAR_GRINDABLE | Material.MatFlags.FLAMMABLE | DustMaterial.MatFlags.NO_SMELTING | DustMaterial.MatFlags.NO_SMASHING);

    public void onMaterialsInit() {
        LIGNITE_COKE.setBurnTime(2400);
        Materials.Naquadah.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_FOIL});
        Materials.NaquadahEnriched.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_FOIL});
        Materials.Duranium.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_FOIL});
        Materials.Graphene.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_FOIL});
        Materials.GreenSapphire.addFlag(new long[]{DustMaterial.MatFlags.GENERATE_PLATE});
        Materials.Tritanium.addFlag(new long[]{SolidMaterial.MatFlags.GENERATE_FRAME});
        Materials.Apatite.addFlag(new long[]{SolidMaterial.MatFlags.GENERATE_ROD});
        Materials.Rubber.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_BOLT_SCREW});
        Materials.Apatite.addFlag(new long[]{IngotMaterial.MatFlags.GENERATE_BOLT_SCREW});
        Materials.Salt.addOreByProducts(new FluidMaterial[]{Materials.Borax});
        Materials.RockSalt.addOreByProducts(new FluidMaterial[]{Materials.Borax});
        Materials.Lepidolite.addOreByProducts(new FluidMaterial[]{Materials.Boron});
        OrePrefix.gemChipped.setIgnored((Material)LIGNITE_COKE);
        OrePrefix.gemFlawed.setIgnored((Material)LIGNITE_COKE);
        OrePrefix.gemFlawless.setIgnored((Material)LIGNITE_COKE);
        OrePrefix.gemExquisite.setIgnored((Material)LIGNITE_COKE);
    }
}

