/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.bees;

import forestry.api.recipes.ICentrifugeRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.items.ItemFluidContainerForestry;
import gregicadditions.GAConfig;
import gregicadditions.GregicAdditions;
import gregicadditions.bees.ForestryMachineRecipes;
import gregicadditions.bees.GTCombs;
import gregicadditions.bees.GTMachineRecipes;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gtadditions")
public class CommonProxy {
    public void preInit() {
    }

    public void postInit() {
        SimpleRecipeBuilder builder;
        if (GAConfig.GTBees.GenerateCentrifugeRecipes) {
            for (ICentrifugeRecipe recipe : RecipeManagers.centrifugeManager.recipes()) {
                builder = (SimpleRecipeBuilder)RecipeMaps.CENTRIFUGE_RECIPES.recipeBuilder();
                builder.inputs(new ItemStack[]{recipe.getInput().func_77946_l()});
                for (ItemStack stack : recipe.getAllProducts().keySet()) {
                    builder.chancedOutput(stack.func_77946_l(), (int)(((Float)recipe.getAllProducts().get(stack)).floatValue() * (float)Recipe.getMaxChancedValue()), 1000);
                }
                builder.EUt(5);
                builder.duration(128);
                builder.buildAndRegister();
            }
        }
        if (GAConfig.GTBees.GenerateExtractorRecipes) {
            for (ICentrifugeRecipe recipe : RecipeManagers.squeezerManager.recipes()) {
                if (recipe.getResources().size() != 1 || ((ItemStack)recipe.getResources().get(0)).func_77973_b() instanceof ItemFluidContainerForestry || RecipeMaps.FLUID_EXTRACTION_RECIPES.findRecipe(Integer.MAX_VALUE, (List)recipe.getResources(), Collections.emptyList(), Integer.MAX_VALUE) != null) continue;
                builder = (SimpleRecipeBuilder)RecipeMaps.FLUID_EXTRACTION_RECIPES.recipeBuilder();
                builder.inputs(new ItemStack[]{((ItemStack)recipe.getResources().get(0)).func_77946_l()});
                if (!recipe.getRemnants().func_190926_b()) {
                    builder.chancedOutput(recipe.getRemnants().func_77946_l(), (int)(recipe.getRemnantsChance() * (float)Recipe.getMaxChancedValue()), 1000);
                }
                if (recipe.getFluidOutput() != null) {
                    builder.fluidOutputs(new FluidStack[]{recipe.getFluidOutput()});
                }
                builder.EUt(5);
                builder.duration(128);
                builder.buildAndRegister();
            }
        }
        GTMachineRecipes.postInit();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        if (GregicAdditions.isForestryBeesDisabled()) {
            return;
        }
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)GTCombs.combItem);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (GregicAdditions.isForestryBeesDisabled()) {
            return;
        }
        ForestryMachineRecipes.init();
    }
}

