/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationBuilder;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.apiculture.items.EnumHoneyComb;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.mutations.MutationConditionRequiresResource;
import gregicadditions.bees.GTBranches;
import gregicadditions.bees.GTCombItem;
import gregicadditions.bees.GTCombs;
import gregtech.common.items.MetaItems;
import java.awt.Color;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.text.WordUtils;

public enum GTBees implements IBeeDefinition
{
    CLAY(GTBranches.FUELIS, "clay", true, new Color(1691884), new Color(14729491)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(ModuleApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(new ItemStack(Items.field_151119_aD), Float.valueOf(0.45f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, BeeDefinition.DILIGENT, 20);
        }
    }
    ,
    SLIME(GTBranches.FUELIS, "slime", true, new Color(5152341), new Color(57362)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.RUBBERY, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(ModuleApiculture.getItems().beeComb.get(EnumHoneyComb.MOSSY, 1), Float.valueOf(0.3f)).setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MARSHY, CLAY, 15);
        }
    }
    ,
    LIGNITE(GTBranches.FUELIS, "lignite", true, new Color(9462327), new Color(5385482)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(ModuleApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.15f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.LIGNITE, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.RURAL, CLAY, 20);
        }
    }
    ,
    RUBBER(GTBranches.FUELIS, "rubbery", true, new Color(3051355), new Color(14467721)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(MetaItems.RUBBER_DROP.getStackForm(), Float.valueOf(0.15f));
            beeSpecies.addProduct(ModuleApiculture.getItems().beeComb.get(EnumHoneyComb.HONEY, 1), Float.valueOf(0.3f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(SLIME, LIGNITE, 25);
        }
    }
    ,
    COAL(GTBranches.FUELIS, "coal", true, new Color(0x666666), new Color(0x484848)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.LIGNITE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.COAL, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, LIGNITE, 18);
        }
    }
    ,
    OIL(GTBranches.FUELIS, "oil", true, new Color(0x4C4C4C), new Color(0x2D2D2D)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.RUBBERY, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.OIL, 1), Float.valueOf(0.15f)).setNocturnal().setHumidity(EnumHumidity.DAMP);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COAL, RUBBER, 8);
        }
    }
    ,
    REDSTONE(GTBranches.ORNAMENTIS, "redstone", true, new Color(8195855), new Color(12064278)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.REDSTONE, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.INDUSTRIOUS, BeeDefinition.DEMONIC, 20);
        }
    }
    ,
    LAPIS(GTBranches.ORNAMENTIS, "lapis", true, new Color(103549), new Color(4087743)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.LAPIS, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.DEMONIC, BeeDefinition.IMPERIAL, 20);
        }
    }
    ,
    CERTUS(GTBranches.ORNAMENTIS, "certus", true, new Color(5754875), new Color(0xAEDDED)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.CERTUS, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.HERMITIC, LAPIS, 20);
        }
    }
    ,
    RUBY(GTBranches.ORNAMENTIS, "ruby", true, new Color(15073372), new Color(12451916)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.RUBY, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(REDSTONE, DIAMOND, 10);
        }
    }
    ,
    SAPPHIRE(GTBranches.ORNAMENTIS, "sapphire", true, new Color(13260), new Color(8581)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SAPPHIRE, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CERTUS, LAPIS, 10);
        }
    }
    ,
    DIAMOND(GTBranches.ORNAMENTIS, "diamond", true, new Color(0xCCFFFF), new Color(0xA3CCCC)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.DIAMOND, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CERTUS, COAL, 6);
        }
    }
    ,
    OLIVINE(GTBranches.ORNAMENTIS, "olivine", true, new Color(2395940), new Color(0xBEEDBE)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.OLIVINE, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CERTUS, BeeDefinition.ENDED, 10);
        }
    }
    ,
    EMERALD(GTBranches.ORNAMENTIS, "emerald", true, new Color(2395940), new Color(0x2BAB2B)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STONE, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.EMERALD, 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(OLIVINE, DIAMOND, 8);
        }
    }
    ,
    COPPER(GTBranches.METALIFERIS, "copper", true, new Color(0xFF6600), new Color(13259008)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.COPPON, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.MAJESTIC, CLAY, 25);
        }
    }
    ,
    TIN(GTBranches.METALIFERIS, "tin", true, new Color(0xD4D4D4), new Color(0xCDCDCD)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.TINE, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(CLAY, BeeDefinition.DILIGENT, 25);
        }
    }
    ,
    LEAD(GTBranches.METALIFERIS, "lead", true, new Color(0x666699), new Color(9671608)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.PLUMBIA, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(COAL, COPPER, 25);
        }
    }
    ,
    IRON(GTBranches.METALIFERIS, "iron", true, new Color(14324039), new Color(14589017)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.FERRU, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(TIN, COPPER, 25);
        }
    }
    ,
    STEEL(GTBranches.METALIFERIS, "steel", true, new Color(0x808080), new Color(0x8A8A8A)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STEELDUST, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(IRON, COAL, 20);
        }
    }
    ,
    NICKEL(GTBranches.METALIFERIS, "nickel", true, new Color(8750509), new Color(8158369)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.NICKELDUST, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(IRON, COPPER, 25);
        }
    }
    ,
    ZINC(GTBranches.METALIFERIS, "zinc", true, new Color(15785712), new Color(0xE1D1E1)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.GALVANIA, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(IRON, TIN, 20);
        }
    }
    ,
    SILVER(GTBranches.METALIFERIS, "zinc", true, new Color(12763862), new Color(12566478)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.ARGENTIA, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(LEAD, TIN, 20);
        }
    }
    ,
    GOLD(GTBranches.METALIFERIS, "gold", true, new Color(15451699), new Color(14071872)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.AURELIA, 1), Float.valueOf(0.15f));
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(LEAD, COPPER, 20);
        }
    }
    ,
    ALUMINIUM(GTBranches.MINERALLIS, "aluminium", true, new Color(0xB8B8FF), new Color(12698086)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.BAUXIA, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(NICKEL, ZINC, 18);
        }
    }
    ,
    TITANIUM(GTBranches.MINERALLIS, "titanium", true, new Color(0xCC99FF), new Color(13413357)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.TITANIUM, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(REDSTONE, ALUMINIUM, 5);
        }
    }
    ,
    CHROME(GTBranches.MINERALLIS, "chrome", true, new Color(15442411), new Color(14792161)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.CHROMIUM, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(TITANIUM, RUBY, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockChrome"));
        }
    }
    ,
    MANGANESE(GTBranches.MINERALLIS, "manganese", true, new Color(0xD5D5D5), new Color(0x999999)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.PYROLUSIUM, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(TITANIUM, ALUMINIUM, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockManganese"));
        }
    }
    ,
    TUNGSTEN(GTBranches.MINERALLIS, "tungsten", true, new Color(6053002), new Color(0x717191)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SCHEELINIUM, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.HEROIC, MANGANESE, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockTungsten"));
        }
    }
    ,
    PLATINUM(GTBranches.MINERALLIS, "platinum", true, new Color(0xE6E6E6), new Color(0xEDEDBE)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.PLATINA, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(DIAMOND, CHROME, 5);
        }
    }
    ,
    IRIDIUM(GTBranches.MINERALLIS, "iridium", true, new Color(0xDADADA), new Color(0xBCBCCA)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.QUANTARIA, 1), Float.valueOf(0.15f)).setHumidity(EnumHumidity.ARID).setTemperature(EnumTemperature.HELLISH);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(TUNGSTEN, PLATINUM, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockIridium"));
        }
    }
    ,
    URANIUM(GTBranches.CRITICALIS, "uranium", true, new Color(1683225), new Color(1348372)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.URANIA, 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(BeeDefinition.AVENGING, PLATINUM, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockUranium"));
        }
    }
    ,
    PLUTONIUM(GTBranches.CRITICALIS, "platinum", true, new Color(0x335C33), new Color(6522112)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.PLUTONIUM, 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.ICY);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(URANIUM, EMERALD, 5).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockPlutonium"));
        }
    }
    ,
    NAQUADAH(GTBranches.CRITICALIS, "naquadah", true, new Color(13056), new Color(8192)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesBuilder beeSpecies) {
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.SLAG, 1), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTCombItem.getComb(GTCombs.STARGATIUM, 1), Float.valueOf(0.15f)).setTemperature(EnumTemperature.ICY).setHumidity(EnumHumidity.ARID);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
        }

        @Override
        protected void registerMutations() {
            this.registerMutation(PLUTONIUM, IRIDIUM, 3).addMutationCondition((IMutationCondition)new MutationConditionRequiresResource("blockNaquadah"));
        }
    };

    private final GTBranches branch;
    private final IAlleleBeeSpecies species;
    @Nullable
    private IAllele[] template;
    @Nullable
    private IBeeGenome genome;

    private GTBees(GTBranches branch, String binomial, boolean dominant, Color primary, Color secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String modId = "jei";
        String uid = modId + '.' + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        IAlleleBeeSpeciesBuilder speciesBuilder = BeeManager.beeFactory.createSpecies(modId, uid, dominant, "Sengir", name, description, branch.getBranch(), binomial, primary.getRGB(), secondary.getRGB());
        if (this.isSecret()) {
            speciesBuilder.setIsSecret();
        }
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesBuilder var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    protected boolean isSecret() {
        return false;
    }

    public static void initBees() {
        for (GTBees bee : GTBees.values()) {
            bee.init();
        }
        for (GTBees bee : GTBees.values()) {
            bee.registerMutations();
        }
    }

    public static void preInit() {
        MinecraftForge.EVENT_BUS.post((Event)new AlleleSpeciesRegisterEvent((ISpeciesRoot)BeeManager.beeRoot, IAlleleBeeSpecies.class));
    }

    private void init() {
        this.template = this.branch.getTemplate();
        AlleleHelper.getInstance().set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationBuilder registerMutation(GTBees parent1, GTBees parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.species, parent2.species, this.getTemplate(), chance);
    }

    protected final IBeeMutationBuilder registerMutation(BeeDefinition parent1, BeeDefinition parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.getGenome().getPrimary(), parent2.getGenome().getPrimary(), this.getTemplate(), chance);
    }

    protected final IBeeMutationBuilder registerMutation(BeeDefinition parent1, GTBees parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.getGenome().getPrimary(), parent2.species, this.getTemplate(), chance);
    }

    protected final IBeeMutationBuilder registerMutation(GTBees parent1, BeeDefinition parent2, int chance) {
        return BeeManager.beeMutationFactory.createMutation(parent1.species, parent2.getGenome().getPrimary(), this.getTemplate(), chance);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)beeType);
    }
}

