/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.bees;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IClassification;
import forestry.apiculture.genetics.alleles.AlleleEffects;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import forestry.core.genetics.alleles.EnumAllele;
import forestry.core.genetics.alleles.IAlleleValue;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.Nullable;

public enum GTBranches implements IBranchDefinition
{
    FUELIS("Fuelis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOW);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.MUSHROOMS);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.UP_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        }
    }
    ,
    ORNAMENTIS("Ornamentis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        }
    }
    ,
    METALIFERIS("Metaliferis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.JUNGLE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_2);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        }
    }
    ,
    MINERALLIS("Mineralis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.FAST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.CACTI);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.DOWN_1);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        }
    }
    ,
    CRITICALIS("Criticalis"){

        @Override
        protected void setBranchProperties(IAllele[] alleles) {
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.END);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(alleles, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
        }
    };

    private final IClassification branch;
    @Nullable
    private static IAllele[] defaultTemplate;

    private GTBranches(String scientific) {
        this.branch = BeeManager.beeFactory.createBranch(this.name().toLowerCase(Locale.ENGLISH), scientific);
    }

    protected void setBranchProperties(IAllele[] template) {
    }

    public final IAllele[] getTemplate() {
        IAllele[] template = GTBranches.getDefaultTemplate();
        this.setBranchProperties(template);
        return template;
    }

    public final IClassification getBranch() {
        return this.branch;
    }

    private static IAllele[] getDefaultTemplate() {
        if (defaultTemplate == null) {
            defaultTemplate = new IAllele[EnumBeeChromosome.values().length];
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.SPEED, (IAlleleValue)EnumAllele.Speed.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.LIFESPAN, (IAlleleValue)EnumAllele.Lifespan.SHORTER);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FERTILITY, (IAlleleValue)EnumAllele.Fertility.NORMAL);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TEMPERATURE_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.NEVER_SLEEPS, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.HUMIDITY_TOLERANCE, (IAlleleValue)EnumAllele.Tolerance.NONE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TOLERATES_RAIN, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.CAVE_DWELLING, false);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWER_PROVIDER, (IAlleleValue)EnumAllele.Flowers.VANILLA);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.FLOWERING, (IAlleleValue)EnumAllele.Flowering.SLOWEST);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.TERRITORY, (IAlleleValue)EnumAllele.Territory.AVERAGE);
            AlleleHelper.getInstance().set(defaultTemplate, (Enum)EnumBeeChromosome.EFFECT, (IAllele)AlleleEffects.effectNone);
        }
        return Arrays.copyOf(defaultTemplate, defaultTemplate.length);
    }
}

