/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.item;

import gregicadditions.GAConfig;
import gregicadditions.GregicAdditions;
import gregicadditions.item.GAMetaItem;
import gregicadditions.item.GAMetaTool;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.common.items.MetaItems;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.OreDictionary;

public class GAMetaItems {
    private static List<MetaItem<?>> ITEMS = MetaItem.getMetaItems();
    public static MetaItem.MetaValueItem GLASS_FIBER;
    public static MetaItem.MetaValueItem PETRI_DISH;
    public static MetaItem.MetaValueItem COMPRESSED_COKE_CLAY;
    public static MetaItem.MetaValueItem ENERGY_MODULE;
    public static MetaItem.MetaValueItem ENERGY_CLUSTER;
    public static MetaItem.MetaValueItem MAX_BATTERY;
    public static MetaItem.MetaValueItem ELECTRODE_APATITE;
    public static MetaItem.MetaValueItem ELECTRODE_BLAZE;
    public static MetaItem.MetaValueItem ELECTRODE_BRONZE;
    public static MetaItem.MetaValueItem ELECTRODE_COPPER;
    public static MetaItem.MetaValueItem ELECTRODE_DIAMOND;
    public static MetaItem.MetaValueItem ELECTRODE_EMERALD;
    public static MetaItem.MetaValueItem ELECTRODE_ENDER;
    public static MetaItem.MetaValueItem ELECTRODE_GOLD;
    public static MetaItem.MetaValueItem ELECTRODE_IRON;
    public static MetaItem.MetaValueItem ELECTRODE_LAPIS;
    public static MetaItem.MetaValueItem ELECTRODE_OBSIDIAN;
    public static MetaItem.MetaValueItem ELECTRODE_ORCHID;
    public static MetaItem.MetaValueItem ELECTRODE_RUBBER;
    public static MetaItem.MetaValueItem ELECTRODE_TIN;
    public static MetaItem.MetaValueItem BENDING_CYLINDER;
    public static MetaItem.MetaValueItem SMALL_BENDING_CYLINDER;
    public static MetaItem.MetaValueItem SCHEMATIC;
    public static MetaItem.MetaValueItem SCHEMATIC_2X2;
    public static MetaItem.MetaValueItem SCHEMATIC_3X3;
    public static MetaItem.MetaValueItem SCHEMATIC_DUST;
    public static MetaItem.MetaValueItem NEURO_PROCESSOR;
    public static MetaItem.MetaValueItem STEM_CELLS;

    public static void init() {
        GAMetaItem item = new GAMetaItem(GAMetaItems.gatherRegisteredPrefixes());
        item.setRegistryName("ga_meta_item");
        GAMetaTool tool = new GAMetaTool();
        tool.setRegistryName("ga_meta_tool");
    }

    public static OrePrefix[] gatherRegisteredPrefixes() {
        OrePrefix[] temp = new OrePrefix[32];
        if (GAConfig.GT6.addCurvedPlates) {
            temp[0] = OrePrefix.valueOf((String)"plateCurved");
        }
        if (GAConfig.GT6.addDoubleIngots) {
            temp[1] = OrePrefix.valueOf((String)"ingotDouble");
        }
        temp[2] = OrePrefix.valueOf((String)"round");
        return temp;
    }

    public static void registerOreDict() {
        for (MetaItem<?> item : ITEMS) {
            if (!(item instanceof GAMetaItem)) continue;
            ((GAMetaItem)item).registerOreDict();
        }
    }

    public static void registerRecipes() {
        for (MetaItem<?> item : ITEMS) {
            if (!(item instanceof GAMetaTool)) continue;
            ((GAMetaTool)item).registerRecipes();
        }
    }

    public static ItemStack getFilledCell(Fluid fluid, int count) {
        ItemStack fluidCell = MetaItems.FLUID_CELL.getStackForm().func_77946_l();
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidCell.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        try {
            fluidHandlerItem.fill(new FluidStack(fluid, 1000), true);
        }
        catch (Exception e) {
            GregicAdditions.LOGGER.error("The fluid " + fluid.toString() + " failed to do something with getFilledCell");
            GregicAdditions.LOGGER.error((Object)e);
            fluidHandlerItem.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
        }
        fluidCell = fluidHandlerItem.getContainer();
        fluidCell.func_190920_e(count);
        return fluidCell;
    }

    public static ItemStack getFilledCell(Fluid fluid) {
        return GAMetaItems.getFilledCell(fluid, 1);
    }

    public static boolean hasPrefix(ItemStack stack, String prefix, String ... ignore) {
        for (int i : OreDictionary.getOreIDs((ItemStack)stack)) {
            if (!OreDictionary.getOreName((int)i).startsWith(prefix)) continue;
            boolean valid = true;
            for (String s : ignore) {
                if (!OreDictionary.getOreName((int)i).startsWith(s)) continue;
                valid = false;
            }
            if (!valid) continue;
            return true;
        }
        return false;
    }
}

