/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.machines;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregicadditions.client.ClientHandler;
import gregtech.api.GTValues;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.multiblock.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.ICubeRenderer;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.BlockMultiblockCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityFusionReactor
extends RecipeMapMultiblockController {
    private final int tier;
    private EnergyContainerList inputEnergyContainers;
    private int heat = 0;

    public TileEntityFusionReactor(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, RecipeMaps.FUSION_RECIPES);
        this.recipeMapWorkable = new FusionRecipeLogic(this);
        this.tier = tier;
        this.reinitializeStructurePattern();
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, Integer.MAX_VALUE, 0L, 0L, 0L, 0L){

            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new TileEntityFusionReactor(this.metaTileEntityId, this.tier);
    }

    protected BlockPattern createStructurePattern() {
        FactoryBlockPattern.start();
        return FactoryBlockPattern.start((BlockPattern.RelativeDirection)BlockPattern.RelativeDirection.LEFT, (BlockPattern.RelativeDirection)BlockPattern.RelativeDirection.DOWN, (BlockPattern.RelativeDirection)BlockPattern.RelativeDirection.BACK).aisle(new String[]{"###############", "######OCO######", "###############"}).aisle(new String[]{"######ICI######", "####CCcccCC####", "######ICI######"}).aisle(new String[]{"####CC###CC####", "###EccOCOccE###", "####CC###CC####"}).aisle(new String[]{"###C#######C###", "##EcEC###CEcE##", "###C#######C###"}).aisle(new String[]{"##C#########C##", "#CcE#######EcC#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#CcC#######CcC#", "##C#########C##"}).aisle(new String[]{"#I###########I#", "OcO#########OcO", "#I###########I#"}).aisle(new String[]{"#C###########C#", "CcC#########CcC", "#C###########C#"}).aisle(new String[]{"#I###########I#", "OcO#########OcO", "#I###########I#"}).aisle(new String[]{"##C#########C##", "#CcC#######CcC#", "##C#########C##"}).aisle(new String[]{"##C#########C##", "#CcE#######EcC#", "##C#########C##"}).aisle(new String[]{"###C#######C###", "##EcEC###CEcE##", "###C#######C###"}).aisle(new String[]{"####CC###CC####", "###EccOCOccE###", "####CC###CC####"}).aisle(new String[]{"######ICI######", "####CCcccCC####", "######ICI######"}).aisle(new String[]{"###############", "######OSO######", "###############"}).where('S', (Predicate)this.selfPredicate()).where('C', TileEntityFusionReactor.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()})).where('c', TileEntityFusionReactor.statePredicate((IBlockState[])new IBlockState[]{this.getCoilState()})).where('O', TileEntityFusionReactor.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()}).or(TileEntityFusionReactor.abilityPartPredicate((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.EXPORT_FLUIDS}))).where('E', TileEntityFusionReactor.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()}).or(TileEntityFusionReactor.tilePredicate((state, tile) -> {
            for (int i = this.tier; i < GTValues.V.length; ++i) {
                if (!tile.metaTileEntityId.equals((Object)MetaTileEntities.ENERGY_INPUT_HATCH[i].metaTileEntityId)) continue;
                return true;
            }
            return false;
        }))).where('I', TileEntityFusionReactor.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()}).or(TileEntityFusionReactor.abilityPartPredicate((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.IMPORT_FLUIDS}))).where('#', tile -> true).build();
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return ClientHandler.FUSION_TEXTURE;
    }

    private IBlockState getCasingState() {
        switch (this.tier) {
            case 6: {
                return MetaBlocks.MACHINE_CASING.getState((Enum)BlockMachineCasing.MachineCasingType.LuV);
            }
            case 7: {
                return MetaBlocks.MUTLIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.FUSION_CASING);
            }
        }
        return MetaBlocks.MUTLIBLOCK_CASING.getState((Enum)BlockMultiblockCasing.MultiblockCasingType.FUSION_CASING_MK2);
    }

    private IBlockState getCoilState() {
        switch (this.tier) {
            case 6: {
                return MetaBlocks.WIRE_COIL.getState((Enum)BlockWireCoil.CoilType.SUPERCONDUCTOR);
            }
        }
        return MetaBlocks.WIRE_COIL.getState((Enum)BlockWireCoil.CoilType.FUSION_COIL);
    }

    protected void formStructure(PatternMatchContext context) {
        long energyStored = this.energyContainer.getEnergyStored();
        super.formStructure(context);
        this.initializeAbilities();
        ((EnergyContainerHandler)this.energyContainer).setEnergyStored(energyStored);
    }

    private void initializeAbilities() {
        this.inputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.IMPORT_ITEMS));
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputInventory = new ItemHandlerList(this.getAbilities(MultiblockAbility.EXPORT_ITEMS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        List energyInputs = this.getAbilities(MultiblockAbility.INPUT_ENERGY);
        this.inputEnergyContainers = new EnergyContainerList(energyInputs);
        long euCapacity = (long)energyInputs.size() * 10000000L * (long)Math.pow(2.0, this.tier - 6);
        this.energyContainer = new EnergyContainerHandler((MetaTileEntity)this, euCapacity, GTValues.V[this.tier], 0L, 0L, 0L){

            public String getName() {
                return "EnergyContainerInternal";
            }
        };
    }

    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            long energyAdded;
            if (this.inputEnergyContainers.getEnergyStored() > 0L && (energyAdded = this.energyContainer.addEnergy(this.inputEnergyContainers.getEnergyStored())) > 0L) {
                this.inputEnergyContainers.removeEnergy(energyAdded);
            }
            super.updateFormedValid();
        }
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        if (!this.isStructureFormed()) {
            textList.add(new TextComponentTranslation("gregtech.multiblock.invalid_structure", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        if (this.isStructureFormed()) {
            if (!this.recipeMapWorkable.isWorkingEnabled()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
            } else if (this.recipeMapWorkable.isActive()) {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.running", new Object[0]));
                if (this.energyContainer.getEnergyCapacity() > 0L) {
                    int currentProgress = (int)(this.recipeMapWorkable.getProgressPercent() * 100.0);
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
                } else {
                    int currentProgress = -this.recipeMapWorkable.getRecipeEUt();
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.generation_eu", new Object[]{currentProgress}));
                }
            } else {
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.idling", new Object[0]));
            }
            if (this.recipeMapWorkable.isHasNotEnoughEnergy()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.not_enough_energy", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        textList.add((ITextComponent)new TextComponentString("EU: " + this.energyContainer.getEnergyStored() + " / " + this.energyContainer.getEnergyCapacity()));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.fusion_reactor.heat", new Object[]{this.heat}));
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        this.getBaseTexture(null).render(renderState, translation, pipeline);
        ClientHandler.FUSION_REACTOR_OVERLAY.render(renderState, translation, pipeline, this.getFrontFacing(), this.recipeMapWorkable.isActive());
    }

    private class FusionRecipeLogic
    extends MultiblockRecipeLogic {
        public FusionRecipeLogic(TileEntityFusionReactor tileEntity) {
            super((RecipeMapMultiblockController)tileEntity);
            this.allowOverclocking = false;
        }

        public void updateWorkable() {
            super.updateWorkable();
            if (!this.isActive && TileEntityFusionReactor.this.heat > 0) {
                TileEntityFusionReactor.this.heat = TileEntityFusionReactor.this.heat <= 10000 ? 0 : TileEntityFusionReactor.this.heat - 10000;
            }
        }

        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            Recipe recipe = super.findRecipe(maxVoltage, inputs, fluidInputs);
            return recipe != null && (long)recipe.getIntegerProperty("eu_to_start") <= TileEntityFusionReactor.this.energyContainer.getEnergyCapacity() ? recipe : null;
        }

        protected boolean setupAndConsumeRecipeInputs(Recipe recipe) {
            int heatDiff = recipe.getIntegerProperty("eu_to_start") - TileEntityFusionReactor.this.heat;
            if (heatDiff <= 0) {
                return super.setupAndConsumeRecipeInputs(recipe);
            }
            if (TileEntityFusionReactor.this.energyContainer.getEnergyStored() < (long)heatDiff || !super.setupAndConsumeRecipeInputs(recipe)) {
                return false;
            }
            TileEntityFusionReactor.this.energyContainer.removeEnergy((long)heatDiff);
            TileEntityFusionReactor.this.heat = TileEntityFusionReactor.this.heat + heatDiff;
            return true;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74768_a("Heat", TileEntityFusionReactor.this.heat);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound compound) {
            super.deserializeNBT(compound);
            TileEntityFusionReactor.this.heat = compound.func_74762_e("Heat");
        }
    }
}

