/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.machines;

import gregicadditions.GAEnums;
import gregicadditions.recipes.GARecipeMaps;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.capability.impl.MultiblockRecipeLogicWrapper;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntityHolder;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.multiblock.BlockPattern;
import gregtech.api.multiblock.FactoryBlockPattern;
import gregtech.api.recipes.CountableIngredient;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.render.ICubeRenderer;
import gregtech.api.render.Textures;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTUtility;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class TileEntityProcessingArray
extends RecipeMapMultiblockController {
    private static final MultiblockAbility<?>[] ALLOWED_ABILITIES = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.IMPORT_FLUIDS, MultiblockAbility.EXPORT_FLUIDS, MultiblockAbility.INPUT_ENERGY};

    public TileEntityProcessingArray(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GARecipeMaps.PROCESSING_ARRAY_RECIPES);
        this.recipeMapWorkable = new ProcessingArrayWorkable(this, new MultiblockRecipeLogicWrapper(this.recipeMapWorkable));
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"XXX", "XXX", "XXX"}).aisle(new String[]{"XXX", "X#X", "XXX"}).aisle(new String[]{"XXX", "XSX", "XXX"}).setAmountAtLeast('L', 12).where('L', TileEntityProcessingArray.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()})).where('S', (Predicate)this.selfPredicate()).where('X', TileEntityProcessingArray.statePredicate((IBlockState[])new IBlockState[]{this.getCasingState()}).or(TileEntityProcessingArray.abilityPartPredicate(ALLOWED_ABILITIES))).where('#', TileEntityProcessingArray.isAirPredicate()).build();
    }

    public IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart arg0) {
        return Textures.ROBUST_TUNGSTENSTEEL_CASING;
    }

    public MetaTileEntity createMetaTileEntity(MetaTileEntityHolder holder) {
        return new TileEntityProcessingArray(this.metaTileEntityId);
    }

    protected static class ProcessingArrayWorkable
    extends MultiblockRecipeLogic {
        int machineTierVoltage = 0;
        int numberOfMachines = 0;
        int numberOfOperations = 0;
        ItemStack machineItemStack = null;
        String machineName = "";
        final MultiblockRecipeLogicWrapper logicWrapper;

        public ProcessingArrayWorkable(RecipeMapMultiblockController tileEntity, MultiblockRecipeLogicWrapper logic) {
            super(tileEntity);
            this.logicWrapper = logic;
        }

        public RecipeMap<?> getRecipeMaps(String machineName) {
            switch (machineName) {
                case "macerator": {
                    return RecipeMaps.MACERATOR_RECIPES;
                }
                case "cluster_mill": {
                    return GARecipeMaps.CLUSTER_MILL_RECIPES;
                }
                case "lathe": {
                    return RecipeMaps.LATHE_RECIPES;
                }
                case "extractor": {
                    return RecipeMaps.EXTRACTOR_RECIPES;
                }
                case "fluid_extractor": {
                    return RecipeMaps.FLUID_EXTRACTION_RECIPES;
                }
                case "alloy_smelter": {
                    return RecipeMaps.ALLOY_SMELTER_RECIPES;
                }
                case "ore_washer": {
                    return RecipeMaps.ORE_WASHER_RECIPES;
                }
                case "thermal_centrifuge": {
                    return RecipeMaps.THERMAL_CENTRIFUGE_RECIPES;
                }
                case "centrifuge": {
                    return RecipeMaps.CENTRIFUGE_RECIPES;
                }
                case "electrolyzer": {
                    return RecipeMaps.ELECTROLYZER_RECIPES;
                }
                case "electric_furnace": {
                    return RecipeMaps.FURNACE_RECIPES;
                }
                case "bender": {
                    return RecipeMaps.BENDER_RECIPES;
                }
                case "arc_furnace": {
                    return RecipeMaps.ARC_FURNACE_RECIPES;
                }
                case "autoclave": {
                    return RecipeMaps.AUTOCLAVE_RECIPES;
                }
                case "assembler": {
                    return RecipeMaps.ASSEMBLER_RECIPES;
                }
                case "brewery": {
                    return RecipeMaps.BREWING_RECIPES;
                }
                case "canner": {
                    return RecipeMaps.CANNER_RECIPES;
                }
                case "chemical_bath": {
                    return RecipeMaps.CHEMICAL_BATH_RECIPES;
                }
                case "chemical_reactor": {
                    return RecipeMaps.CHEMICAL_RECIPES;
                }
                case "compressor": {
                    return RecipeMaps.COMPRESSOR_RECIPES;
                }
                case "cutter": {
                    return RecipeMaps.CUTTER_RECIPES;
                }
                case "distillery": {
                    return RecipeMaps.DISTILLATION_RECIPES;
                }
                case "electromagnetic_separator": {
                    return RecipeMaps.ELECTROMAGNETIC_SEPARATOR_RECIPES;
                }
                case "fermenter": {
                    return RecipeMaps.FERMENTING_RECIPES;
                }
                case "fluid_canner": {
                    return RecipeMaps.FLUID_CANNER_RECIPES;
                }
                case "fluid_heater": {
                    return RecipeMaps.FLUID_HEATER_RECIPES;
                }
                case "fluid_solidifier": {
                    return RecipeMaps.FLUID_SOLIDFICATION_RECIPES;
                }
                case "forge_hammer": {
                    return RecipeMaps.FORGE_HAMMER_RECIPES;
                }
                case "forming_press": {
                    return RecipeMaps.FORMING_PRESS_RECIPES;
                }
                case "microwave": {
                    return RecipeMaps.MICROWAVE_RECIPES;
                }
                case "mixer": {
                    return RecipeMaps.MIXER_RECIPES;
                }
                case "packer": {
                    return RecipeMaps.PACKER_RECIPES;
                }
                case "unpacker": {
                    return RecipeMaps.UNPACKER_RECIPES;
                }
                case "plasma_arc_furnace": {
                    return RecipeMaps.PLASMA_ARC_FURNACE_RECIPES;
                }
                case "polarizer": {
                    return RecipeMaps.POLARIZER_RECIPES;
                }
                case "laser_engraver": {
                    return RecipeMaps.LASER_ENGRAVER_RECIPES;
                }
                case "wiremill": {
                    return RecipeMaps.WIREMILL_RECIPES;
                }
                case "mass_fab": {
                    return GARecipeMaps.MASS_FAB_RECIPES;
                }
                case "replicator": {
                    return GARecipeMaps.REPLICATOR_RECIPES;
                }
                case "sifter": {
                    return RecipeMaps.SIFTER_RECIPES;
                }
                case "extruder": {
                    return RecipeMaps.EXTRUDER_RECIPES;
                }
            }
            return null;
        }

        protected Recipe findRecipe(long maxVoltage, IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
            int fluidMultiplier;
            String machineName = this.findMachine(inputs);
            RecipeMap<?> recipeMap = this.getRecipeMaps(machineName);
            if (recipeMap == null) {
                return null;
            }
            Recipe recipe = recipeMap.findRecipe((long)this.machineTierVoltage, inputs, fluidInputs, this.getMinTankCapacity(this.getOutputTank()));
            if (recipe == null) {
                return null;
            }
            int itemMultiplier = this.getMinRatioItem(ProcessingArrayWorkable.findIngredients(inputs), recipe, this.numberOfMachines);
            int minMultiplier = Math.min(itemMultiplier, fluidMultiplier = this.getMinRatioFluid(ProcessingArrayWorkable.findFluid(fluidInputs), recipe, this.numberOfMachines));
            if (minMultiplier == Integer.MAX_VALUE) {
                GTLog.logger.error("Cannot calculate ratio of items for processing array");
                return null;
            }
            ArrayList<CountableIngredient> newRecipeInputs = new ArrayList<CountableIngredient>();
            ArrayList<FluidStack> newFluidInputs = new ArrayList<FluidStack>();
            ArrayList<ItemStack> outputI = new ArrayList<ItemStack>();
            ArrayList<FluidStack> outputF = new ArrayList<FluidStack>();
            this.multiplyInputsAndOutputs(newRecipeInputs, newFluidInputs, outputI, outputF, recipe, minMultiplier);
            RecipeBuilder newRecipe = recipeMap.recipeBuilder().inputsIngredients(newRecipeInputs).fluidInputs(newFluidInputs).outputs(outputI).fluidOutputs(outputF).EUt(recipe.getEUt()).duration(recipe.getDuration());
            ProcessingArrayWorkable.copyChancedItemOutputs(newRecipe, recipe, minMultiplier);
            newRecipe.notConsumable(this.machineItemStack);
            this.numberOfOperations = minMultiplier;
            return (Recipe)newRecipe.build().getResult();
        }

        protected static void copyChancedItemOutputs(RecipeBuilder<?> newRecipe, Recipe oldRecipe, int numberOfOperations) {
            for (Recipe.ChanceEntry entry : oldRecipe.getChancedOutputs()) {
                int chance = entry.getChance();
                ItemStack itemStack = entry.getItemStack().func_77946_l();
                int boost = entry.getBoostPerTier();
                itemStack.func_190920_e(itemStack.func_190916_E() * numberOfOperations);
                newRecipe.chancedOutput(itemStack, chance, boost);
            }
        }

        protected static Set<ItemStack> findIngredients(IItemHandlerModifiable inputs) {
            HashSet<ItemStack> countIngredients = new HashSet<ItemStack>();
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                ItemStack wholeItemStack = inputs.getStackInSlot(slot);
                if (wholeItemStack.func_190926_b()) continue;
                boolean found = false;
                for (ItemStack i : countIngredients) {
                    if (!ItemStack.func_179545_c((ItemStack)i, (ItemStack)wholeItemStack)) continue;
                    i.func_190920_e(i.func_190916_E() + wholeItemStack.func_190916_E());
                    found = true;
                    break;
                }
                if (found) continue;
                countIngredients.add(wholeItemStack.func_77946_l());
            }
            return countIngredients;
        }

        protected int getMinRatioItem(Set<ItemStack> countIngredients, Recipe recipe, int numberOfMachines) {
            int minMultiplier = Integer.MAX_VALUE;
            block0: for (CountableIngredient recipeInputs : recipe.getInputs()) {
                if (recipeInputs.getCount() == 0) continue;
                for (ItemStack wholeItemStack : countIngredients) {
                    if (!recipeInputs.getIngredient().apply(wholeItemStack)) continue;
                    int ratio = Math.min(numberOfMachines, wholeItemStack.func_190916_E() / recipeInputs.getCount());
                    if (ratio >= minMultiplier) continue block0;
                    minMultiplier = ratio;
                    continue block0;
                }
            }
            return minMultiplier;
        }

        protected static Map<String, Integer> findFluid(IMultipleTankHandler fluidInputs) {
            HashMap<String, Integer> countFluid = new HashMap<String, Integer>();
            for (IFluidTank tank : fluidInputs) {
                if (tank.getFluid() == null) continue;
                String name = tank.getFluid().getUnlocalizedName();
                if (countFluid.containsKey(name)) {
                    int existingValue = (Integer)countFluid.get(name);
                    countFluid.put(name, existingValue + tank.getFluidAmount());
                    continue;
                }
                countFluid.put(name, tank.getFluidAmount());
            }
            return countFluid;
        }

        protected int getMinRatioFluid(Map<String, Integer> countFluid, Recipe recipe, int numberOfMachines) {
            int minMultiplier = Integer.MAX_VALUE;
            for (FluidStack fs : recipe.getFluidInputs()) {
                String name = fs.getFluid().getUnlocalizedName();
                int ratio = Math.min(numberOfMachines, countFluid.get(name) / fs.amount);
                if (ratio >= minMultiplier) continue;
                minMultiplier = ratio;
            }
            return minMultiplier;
        }

        protected static ItemStack copyItemStackWithCount(ItemStack itemStack, int count) {
            ItemStack itemCopy = itemStack.func_77946_l();
            itemCopy.func_190920_e(count);
            return itemCopy;
        }

        protected static FluidStack copyFluidStackWithAmount(FluidStack fluidStack, int count) {
            FluidStack fluidCopy = fluidStack.copy();
            fluidCopy.amount = count;
            return fluidCopy;
        }

        protected void multiplyInputsAndOutputs(List<CountableIngredient> newRecipeInputs, List<FluidStack> newFluidInputs, List<ItemStack> outputItems, List<FluidStack> outputFluids, Recipe recipe, int numberOfOperations) {
            recipe.getInputs().forEach(ci -> newRecipeInputs.add(new CountableIngredient(ci.getIngredient(), ci.getCount() * numberOfOperations)));
            recipe.getFluidInputs().forEach(fluidStack -> newFluidInputs.add(new FluidStack(fluidStack.getFluid(), fluidStack.amount * numberOfOperations)));
            recipe.getOutputs().forEach(itemStack -> outputItems.add(ProcessingArrayWorkable.copyItemStackWithCount(itemStack, itemStack.func_190916_E() * numberOfOperations)));
            recipe.getFluidOutputs().forEach(fluidStack -> outputFluids.add(ProcessingArrayWorkable.copyFluidStackWithAmount(fluidStack, fluidStack.amount * numberOfOperations)));
        }

        protected String findMachine(IItemHandlerModifiable inputs) {
            for (int slot = 0; slot < inputs.getSlots(); ++slot) {
                ItemStack wholeItemStack = inputs.getStackInSlot(slot);
                String unlocalizedName = wholeItemStack.func_77973_b().func_77657_g(wholeItemStack);
                if (!unlocalizedName.contains("gregtech.machine") && !unlocalizedName.contains("gtadditions.machine")) continue;
                this.numberOfMachines = Math.min(16, wholeItemStack.func_190916_E());
                String voltage = unlocalizedName.substring(unlocalizedName.lastIndexOf(".") + 1);
                String trimmedName = unlocalizedName.substring(0, unlocalizedName.lastIndexOf("."));
                if (!GAEnums.voltageMap.containsKey(voltage)) continue;
                this.machineName = trimmedName.substring(trimmedName.lastIndexOf(".") + 1);
                this.machineTierVoltage = GAEnums.voltageMap.get(voltage);
                this.machineItemStack = wholeItemStack;
                break;
            }
            return this.machineName;
        }

        protected boolean setupAndConsumeRecipeInputs(Recipe recipe) {
            boolean enoughPower;
            IItemHandlerModifiable importInventory = this.getInputInventory();
            IItemHandlerModifiable exportInventory = this.getOutputInventory();
            IMultipleTankHandler importFluids = this.getInputTank();
            IMultipleTankHandler exportFluids = this.getOutputTank();
            int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), this.machineTierVoltage, recipe.getDuration());
            int totalEUt = resultOverclock[0] * resultOverclock[1] * this.numberOfOperations;
            if (totalEUt >= 0) {
                int capacity = (long)totalEUt > this.getEnergyCapacity() / 2L ? resultOverclock[0] : totalEUt;
                enoughPower = this.getEnergyStored() >= (long)capacity;
            } else {
                int power = resultOverclock[0] * this.numberOfOperations;
                boolean bl = enoughPower = this.getEnergyStored() - (long)power <= this.getEnergyCapacity();
            }
            if (!enoughPower) {
                return false;
            }
            return MetaTileEntity.addItemsToItemHandler((IItemHandler)exportInventory, (boolean)true, (List)recipe.getAllItemOutputs(exportInventory.getSlots())) && MetaTileEntity.addFluidsToFluidHandler((IFluidHandler)exportFluids, (boolean)true, (List)recipe.getFluidOutputs()) && recipe.matches(true, importInventory, importFluids);
        }

        protected void trySearchNewRecipe() {
            IMultipleTankHandler importFluids;
            long maxVoltage = this.getMaxVoltage();
            Recipe currentRecipe = null;
            IItemHandlerModifiable importInventory = this.getInputInventory();
            boolean dirty = this.checkRecipeInputsDirty((IItemHandler)importInventory, importFluids = this.getInputTank());
            if (dirty || this.forceRecipeRecheck) {
                this.forceRecipeRecheck = false;
                currentRecipe = this.findRecipe(maxVoltage, importInventory, importFluids);
                if (currentRecipe != null) {
                    this.previousRecipe = currentRecipe;
                }
            } else if (this.previousRecipe != null && this.previousRecipe.matches(false, importInventory, importFluids)) {
                currentRecipe = this.previousRecipe;
            }
            if (currentRecipe != null && this.setupAndConsumeRecipeInputs(currentRecipe)) {
                this.setupRecipe(currentRecipe);
            }
        }

        protected void setupRecipe(Recipe recipe) {
            int[] resultOverclock = this.calculateOverclock(recipe.getEUt(), this.machineTierVoltage, recipe.getDuration());
            this.progressTime = 1;
            this.setMaxProgress(resultOverclock[1]);
            this.recipeEUt = resultOverclock[0] * this.numberOfOperations;
            this.fluidOutputs = GTUtility.copyFluidList((List)recipe.getFluidOutputs());
            int tier = this.getMachineTierForRecipe(recipe);
            this.itemOutputs = GTUtility.copyStackList((List)recipe.getResultItemOutputs(this.getOutputInventory().getSlots(), this.random, tier));
            this.logicWrapper.invertWasActiveAndNeedsUpdate();
        }
    }
}

