/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.recipes;

import gregicadditions.GAConfig;
import gregicadditions.GregicAdditions;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.ingredients.IntCircuitIngredient;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.DustMaterial;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.MaterialStack;
import gregtech.common.blocks.BlockMachineCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class GAMachineRecipeRemoval {
    private static final MaterialStack[] solderingList = new MaterialStack[]{new MaterialStack((Material)Materials.Tin, 2L), new MaterialStack((Material)Materials.SolderingAlloy, 1L), new MaterialStack((Material)Materials.Lead, 4L)};

    public static void init() {
        for (Material m : Material.MATERIAL_REGISTRY) {
            if (m instanceof IngotMaterial && m.hasFlag("GENERATE_FOIL")) {
                GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)0));
            }
            if (m instanceof IngotMaterial && !m.hasFlag(DustMaterial.MatFlags.NO_SMASHING) && GAConfig.GT6.ExpensiveWrenches) {
                ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation(String.format("gregtech:wrench_%s", m.toString())));
            }
            if (!GAConfig.GT5U.CablesGT5U || !(m instanceof IngotMaterial) || ((IngotMaterial)m).cableProperties == null || ((IngotMaterial)m).cableProperties.voltage < 4) continue;
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(144)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)2), IntCircuitIngredient.getIntegratedCircuit((int)25)}, new FluidStack[]{Materials.Rubber.getFluid(288)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)4), IntCircuitIngredient.getIntegratedCircuit((int)26)}, new FluidStack[]{Materials.Rubber.getFluid(576)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)8), IntCircuitIngredient.getIntegratedCircuit((int)27)}, new FluidStack[]{Materials.Rubber.getFluid(1152)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)m, (int)16), IntCircuitIngredient.getIntegratedCircuit((int)28)}, new FluidStack[]{Materials.Rubber.getFluid(2304)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtDouble, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(288)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtQuadruple, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(576)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtOctal, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(1152)});
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.wireGtHex, (Material)m), IntCircuitIngredient.getIntegratedCircuit((int)24)}, new FluidStack[]{Materials.Rubber.getFluid(2304)});
        }
        if (GAConfig.GT6.BendingCurvedPlates && GAConfig.GT6.addCurvedPlates) {
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Iron, (int)12), IntCircuitIngredient.getIntegratedCircuit((int)1));
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.BENDER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.WroughtIron, (int)12), IntCircuitIngredient.getIntegratedCircuit((int)1));
        }
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.MACERATOR_RECIPES, new ItemStack(Items.field_151118_aC));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, MetaItems.ENERGY_LAPOTRONIC_ORB2.getStackForm(8), OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Darmstadtium, (int)16));
        ModHandler.removeRecipeByName((ResourceLocation)new ResourceLocation("gregtech:primitive_circuit"));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CENTRIFUGE_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.DarkAsh, (int)2));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CENTRIFUGE_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Ash));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.AUTOCLAVE_RECIPES, new ItemStack[]{new ItemStack(Items.field_151156_bN)}, new FluidStack[]{Materials.Darmstadtium.getFluid(288)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.plate, (Material)Materials.Darmstadtium, (int)8), IntCircuitIngredient.getIntegratedCircuit((int)8));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ASSEMBLER_RECIPES, new ItemStack[]{MetaBlocks.MACHINE_CASING.getItemVariant((Enum)BlockMachineCasing.MachineCasingType.MAX), OreDictUnifier.get((OrePrefix)OrePrefix.wireGtSingle, (Material)MarkerMaterials.Tier.Superconductor, (int)2)}, new FluidStack[]{Materials.Polytetrafluoroethylene.getFluid(288)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.ELECTROLYZER_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Sphalerite, (int)2));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.MIXER_RECIPES, Materials.LightFuel.getFluid(5000), Materials.HeavyFuel.getFluid(1000));
        if (GAConfig.GTBees.GenerateExtractorRecipes) {
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151014_N));
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151081_bc));
            GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FLUID_EXTRACTION_RECIPES, new ItemStack(Items.field_151080_bb));
        }
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.COMPRESSOR_RECIPES, OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Redstone));
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.Water.getFluid(73)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.Water.getFluid(73)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.DistilledWater.getFluid(55)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.DistilledWater.getFluid(55)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{new ItemStack(Blocks.field_150371_ca)}, new FluidStack[]{Materials.Lubricant.getFluid(18)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.CUTTER_RECIPES, new ItemStack[]{OreDictUnifier.get((OrePrefix)OrePrefix.block, (Material)Materials.CertusQuartz)}, new FluidStack[]{Materials.Lubricant.getFluid(18)});
        GAMachineRecipeRemoval.removeRecipesByInputs(RecipeMaps.FUSION_RECIPES, Materials.Lithium.getFluid(16), Materials.Tungsten.getFluid(16));
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, ItemStack ... itemInputs) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<String> names = new ArrayList<String>();
        for (ItemStack s : itemInputs) {
            inputs.add(s);
            names.add(s.func_82833_r() + " x " + s.func_190916_E());
        }
        if (map.removeRecipe(map.findRecipe(Long.MAX_VALUE, inputs, Collections.emptyList(), Integer.MAX_VALUE))) {
            GregicAdditions.LOGGER.info("Removed Recipe for Item Input(s): " + names);
        } else {
            GregicAdditions.LOGGER.warn("Failed to Remove Recipe for Item Input(s): " + names);
        }
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, FluidStack ... fluidInputs) {
        ArrayList<FluidStack> inputs = new ArrayList<FluidStack>();
        ArrayList<String> names = new ArrayList<String>();
        for (FluidStack s : fluidInputs) {
            inputs.add(s);
            names.add(s.getFluid().getName() + " x " + s.amount);
        }
        if (map.removeRecipe(map.findRecipe(Long.MAX_VALUE, Collections.emptyList(), inputs, Integer.MAX_VALUE))) {
            GregicAdditions.LOGGER.info("Removed Recipe for Fluid Input(s): " + names);
        } else {
            GregicAdditions.LOGGER.warn("Failed to Remove Recipe for Fluid Input(s): " + names);
        }
    }

    private static <R extends RecipeBuilder<R>> void removeRecipesByInputs(RecipeMap<R> map, ItemStack[] itemInputs, FluidStack[] fluidInputs) {
        ArrayList<ItemStack> itemIn = new ArrayList<ItemStack>();
        ArrayList<String> fluidNames = new ArrayList<String>();
        ArrayList<String> itemNames = new ArrayList<String>();
        for (ItemStack s : itemInputs) {
            itemIn.add(s);
            itemNames.add(s.func_82833_r() + " x " + s.func_190916_E());
        }
        ArrayList<FluidStack> fluidIn = new ArrayList<FluidStack>();
        for (FluidStack s : fluidInputs) {
            fluidIn.add(s);
            fluidNames.add(s.getFluid().getName() + " x " + s.amount);
        }
        if (map.removeRecipe(map.findRecipe(Long.MAX_VALUE, itemIn, fluidIn, Integer.MAX_VALUE))) {
            GregicAdditions.LOGGER.info("Removed Recipe for inputs: Items: " + itemNames + " Fluids: " + fluidNames);
        } else {
            GregicAdditions.LOGGER.info("Failed to Remove Recipe for inputs: Items: " + itemNames + " Fluids: " + fluidNames);
        }
    }

    private static <R extends RecipeBuilder<R>> void removeAllRecipes(RecipeMap<R> map) {
        ArrayList recipes = new ArrayList();
        recipes.addAll(map.getRecipeList());
        for (Recipe r : recipes) {
            map.removeRecipe(r);
        }
    }
}

