/*
 * Decompiled with CFR 0.152.
 */
package gregicadditions.tconstruct;

import gregicadditions.GAConfig;
import gregicadditions.tconstruct.TinkersGtRecipes;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.material.type.IngotMaterial;
import gregtech.api.unification.material.type.Material;
import gregtech.api.unification.ore.OrePrefix;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerRegisterEvent;
import slimeknights.tconstruct.library.smeltery.AlloyRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;

@Mod.EventBusSubscriber
public class TinkersEvents {
    @Optional.Method(modid="tconstruct")
    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (GAConfig.GregsConstruct.EnableGregsConstruct && Loader.isModLoaded((String)"tconstruct")) {
            TinkersGtRecipes.init();
        }
    }

    @Optional.Method(modid="tconstruct")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void smeltingRemoval(TinkerRegisterEvent.MeltingRegisterEvent event) {
        if (GAConfig.GregsConstruct.EnableGregsConstruct) {
            for (Material mat : Material.MATERIAL_REGISTRY) {
                if (!(mat instanceof IngotMaterial) || ((IngotMaterial)mat).blastFurnaceTemperature <= 0 || !TinkersEvents.matches(event, OrePrefix.ore, mat) && !TinkersEvents.matches(event, OrePrefix.dust, mat) && !TinkersEvents.matches(event, OrePrefix.dustSmall, mat) && !TinkersEvents.matches(event, OrePrefix.dustTiny, mat)) continue;
                event.setCanceled(true);
            }
        }
    }

    @Optional.Method(modid="tconstruct")
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void alloyRemoval(TinkerRegisterEvent.AlloyRegisterEvent event) {
        if (((AlloyRecipe)event.getRecipe()).getResult() == Materials.Brass.getFluid(3) && GAConfig.GregsConstruct.TinkersMaterialAlloying) {
            event.setCanceled(true);
        }
    }

    private static boolean matches(TinkerRegisterEvent.MeltingRegisterEvent e, OrePrefix prefix, Material mat) {
        return ((MeltingRecipe)e.getRecipe()).input.matches(NonNullList.func_191197_a((int)1, (Object)OreDictUnifier.get((OrePrefix)prefix, (Material)mat))).isPresent();
    }
}

