/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.inventoryoverlay;

import baubles.common.container.ContainerPlayerExpanded;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@Mod(modid="inventoryoverlay", name="Inventory Overlay", version="@VERSION@", clientSideOnly=true, dependencies="after:baubles@[1.5.2,)", guiFactory="arcaratus.taboverlay.GuiOverlayConfig$Factory", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="inventoryoverlay")
public class InventoryOverlay {
    public static final String MOD_ID = "inventoryoverlay";
    public static final String NAME = "Inventory Overlay";
    public static final String VERSION = "@VERSION@";
    private static final boolean baublesLoaded = Loader.isModLoaded((String)"baubles");
    private static final ResourceLocation OVERLAY = new ResourceLocation("inventoryoverlay", "textures/gui/overlay.png");
    private static final ResourceLocation BAUBLES_OVERLAY = new ResourceLocation("inventoryoverlay", "textures/gui/overlay_baubles.png");
    private static final int width = 176;
    private static final int height = 166;
    public static float zLevel = 0.0f;
    public static final KeyBinding KEY_OVERLAY = new KeyBindingOverlay();

    @SubscribeEvent
    public static void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        boolean baublesOverlay;
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = event.getResolution();
        EntityPlayerSP player = mc.field_71439_g;
        boolean bl = baublesOverlay = baublesLoaded && ConfigHandler.baublesOverlay;
        if (mc.field_71462_r == null && Keyboard.isKeyDown((int)KEY_OVERLAY.func_151463_i())) {
            int i = (res.func_78326_a() - 176) / 2;
            int j = (res.func_78328_b() - 166) / 2;
            zLevel = -1000.0f;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)ConfigHandler.overlayOpacity));
            GlStateManager.func_179094_E();
            mc.func_110434_K().func_110577_a(baublesOverlay ? BAUBLES_OVERLAY : OVERLAY);
            InventoryOverlay.drawTexturedModalRect(i + ConfigHandler.xOffset, j + ConfigHandler.yOffset, 0, 0, 176, 166);
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179097_i();
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)i, (float)j, (float)0.0f);
            GlStateManager.func_179091_B();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            for (int i1 = 0; i1 < player.field_71069_bz.field_75151_b.size(); ++i1) {
                Slot slot = (Slot)player.field_71069_bz.field_75151_b.get(i1);
                if (!slot.func_111238_b()) continue;
                InventoryOverlay.drawSlot(mc, (EntityPlayer)player, slot);
            }
            if (baublesOverlay) {
                InventoryOverlay.drawBaublesSlots(mc, (EntityPlayer)player, i, j);
            }
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
            RenderHelper.func_74518_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            zLevel = 0.0f;
            mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    private static void drawSlot(Minecraft mc, EntityPlayer player, Slot slotIn) {
        TextureAtlasSprite textureatlassprite;
        int i = slotIn.field_75223_e + ConfigHandler.xOffset;
        int j = slotIn.field_75221_f + ConfigHandler.yOffset;
        ItemStack itemstack = slotIn.func_75211_c();
        RenderItem itemRender = mc.func_175599_af();
        boolean flag1 = false;
        zLevel = 100.0f;
        itemRender.field_77023_b = 100.0f;
        if (itemstack.func_190926_b() && slotIn.func_111238_b() && (textureatlassprite = slotIn.getBackgroundSprite()) != null && (!baublesLoaded || !textureatlassprite.func_94215_i().equals("minecraft:items/empty_armor_slot_shield"))) {
            GlStateManager.func_179140_f();
            mc.func_110434_K().func_110577_a(slotIn.getBackgroundLocation());
            InventoryOverlay.drawTexturedModalRect(i, j, textureatlassprite, 16, 16);
            GlStateManager.func_179145_e();
            flag1 = true;
        }
        itemRender.field_77023_b = 0.0f;
        zLevel = 0.0f;
        if (!flag1) {
            zLevel = 200.0f;
            itemRender.field_77023_b = 200.0f;
            if (baublesLoaded && ConfigHandler.baublesOverlay && slotIn.field_75222_d == 45) {
                itemRender.func_184391_a((EntityLivingBase)player, itemstack, i + 19, j);
                itemRender.func_180453_a(mc.field_71466_p, itemstack, i + 19, j, null);
            } else {
                itemRender.func_184391_a((EntityLivingBase)player, itemstack, i, j);
                itemRender.func_180453_a(mc.field_71466_p, itemstack, i, j, null);
            }
            zLevel = 0.0f;
            itemRender.field_77023_b = 0.0f;
        }
    }

    @Optional.Method(modid="baubles")
    private static void drawBaublesSlots(Minecraft mc, EntityPlayer player, int i, int j) {
        ContainerPlayerExpanded container = new ContainerPlayerExpanded(player.field_71071_by, !player.func_130014_f_().field_72995_K, player);
        for (int i1 = 0; i1 < container.field_75151_b.size(); ++i1) {
            Slot slot = (Slot)container.field_75151_b.get(i1);
            if (!slot.func_75216_d() || slot.func_75219_a() != 1) continue;
            InventoryOverlay.drawSlot(mc, player, slot);
        }
    }

    private static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)xCoord, (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)yCoord, (double)zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)xCoord, (double)yCoord, (double)zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    private static void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + height) * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(textureX + width) * f), (double)((float)textureY * f)).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f)).func_181675_d();
        tessellator.func_78381_a();
    }

    @Config(modid="inventoryoverlay", name="Inventory Overlay/inventoryoverlay")
    @Mod.EventBusSubscriber(modid="inventoryoverlay")
    public static class ConfigHandler {
        @Config.Comment(value={"Adjust the X-position of the overlay."})
        @Config.RangeInt(min=-1000, max=1000)
        public static int xOffset = 0;
        @Config.Comment(value={"Adjust the Y-position of the overlay."})
        @Config.RangeInt(min=-1000, max=1000)
        public static int yOffset = 0;
        @Config.Comment(value={"Toggle the opacity of the overlay."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public static double overlayOpacity = 0.05;
        @Config.Comment(value={"Disable the Baubles overlay."})
        public static boolean baublesOverlay = true;

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals(InventoryOverlay.MOD_ID)) {
                ConfigManager.sync((String)event.getModID(), (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class KeyBindingOverlay
    extends KeyBinding {
        public KeyBindingOverlay() {
            super(InventoryOverlay.MOD_ID + ".keybind.overlay".toLowerCase(Locale.ENGLISH), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, 41, InventoryOverlay.NAME);
            ClientRegistry.registerKeyBinding((KeyBinding)this);
        }
    }
}

