/*
 * Decompiled with CFR 0.152.
 */
package nl.makertim.nbtperipheral.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import nl.makertim.nbtperipheral.cc.NBTUtil;

public abstract class EntityPeripheral
implements IPeripheral {
    protected World world;
    protected BlockPos pos;

    public EntityPeripheral(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    protected Entity[] getEntities() {
        return (Entity[])this.world.func_72872_a(Entity.class, this.getRange().func_186670_a(this.pos)).stream().toArray(Entity[]::new);
    }

    protected abstract AxisAlignedBB getRange();

    protected abstract Vec3d getCenter();

    @Nonnull
    public abstract String getType();

    @Nonnull
    public String[] getMethodNames() {
        return (String[])Arrays.stream(Methods.values()).map(Methods::getName).toArray(String[]::new);
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException {
        try {
            Methods methods = Methods.values()[method];
            Entity[] entities = this.getEntities();
            switch (methods) {
                case READ: {
                    if (entities.length == 0) break;
                    return ((Stream)Arrays.stream(entities).parallel()).map(entity -> {
                        NBTTagCompound nbt = new NBTTagCompound();
                        entity.func_189511_e(nbt);
                        Vec3d entityPos = entity.func_174791_d();
                        NBTTagCompound relative = new NBTTagCompound();
                        Vec3d center = this.getCenter();
                        relative.func_74780_a("x", (double)this.pos.func_177958_n() + center.field_72450_a - entityPos.field_72450_a);
                        relative.func_74780_a("y", (double)this.pos.func_177956_o() + center.field_72448_b - entityPos.field_72448_b);
                        relative.func_74780_a("z", (double)this.pos.func_177952_p() + center.field_72449_c - entityPos.field_72449_c);
                        nbt.func_74780_a("_distanceSq", this.pos.func_177957_d(entityPos.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c));
                        nbt.func_74782_a("_relative", (NBTBase)relative);
                        nbt.func_74778_a("_name", entity.func_70005_c_());
                        nbt.func_74778_a("_displayName", entity.func_145748_c_().func_150260_c());
                        Optional<Team> team = Optional.ofNullable(entity.func_96124_cp());
                        team.ifPresent(t -> {
                            nbt.func_74778_a("_team", t.func_96661_b());
                            nbt.func_74778_a("_teamColor", t.func_178775_l().name());
                        });
                        nbt.func_82580_o("Attributes");
                        nbt.func_82580_o("recipeBook");
                        nbt.func_82580_o("toBeDisplayed");
                        return NBTUtil.nbtToMap(nbt);
                    }).toArray(Object[]::new);
                }
                case COUNT: {
                    return new Object[]{entities.length};
                }
                case IS_EMPTY: {
                    return new Object[]{entities.length == 0};
                }
            }
            return new Object[0];
        }
        catch (Exception ex) {
            throw new LuaException(ex.getMessage());
        }
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof EntityPeripheral && other.getClass().equals(this.getClass()) && ((EntityPeripheral)other).world.equals(this.world) && ((EntityPeripheral)other).pos.equals((Object)this.pos);
    }

    public static enum Methods {
        IS_EMPTY("is_empty"),
        COUNT("count"),
        READ("read");

        private String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

