/*
 * Decompiled with CFR 0.152.
 */
package nl.makertim.nbtperipheral.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import nl.makertim.nbtperipheral.cc.BlockStateUtil;
import nl.makertim.nbtperipheral.cc.NBTUtil;

public class ObserverPeripheral
implements IPeripheral {
    private World world;
    private BlockPos pos;

    public ObserverPeripheral(World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
    }

    @Nonnull
    protected Optional<EnumFacing> getFacing() {
        IBlockState state = this.world.func_180495_p(this.pos);
        if (state.func_177227_a().contains(BlockDirectional.field_176387_N)) {
            return Optional.of(state.func_177229_b((IProperty)BlockDirectional.field_176387_N));
        }
        return Optional.empty();
    }

    protected BlockPos relative(EnumFacing facing) {
        return this.pos.func_177971_a(facing.func_176730_m());
    }

    @Nonnull
    public String getType() {
        return "NBT_Observer";
    }

    @Nonnull
    public String[] getMethodNames() {
        return (String[])Arrays.stream(Methods.values()).map(Methods::getName).toArray(String[]::new);
    }

    @Nullable
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException {
        try {
            Methods methods = Methods.values()[method];
            Optional<EnumFacing> facingOptional = this.getFacing();
            if (!facingOptional.isPresent()) {
                throw new LuaException("Cant read direction from the observer");
            }
            BlockPos relativePos = this.relative(facingOptional.get());
            IBlockState state = this.world.func_180495_p(relativePos);
            TileEntity tile = this.world.func_175625_s(relativePos);
            switch (methods) {
                case READ_NBT: {
                    if (tile == null) {
                        throw new LuaException("No TileEntity Found");
                    }
                    NBTTagCompound compound = new NBTTagCompound();
                    tile.func_189515_b(compound);
                    return new Object[]{NBTUtil.nbtToMap(compound)};
                }
                case HAS_NBT: {
                    return new Object[]{tile != null};
                }
                case READ_STATE: {
                    if (state.func_177227_a().isEmpty()) {
                        throw new LuaException("No State Found");
                    }
                    return new Object[]{BlockStateUtil.stateToMap(state)};
                }
                case HAS_STATE: {
                    return new Object[]{state.func_177227_a().isEmpty()};
                }
            }
            return new Object[0];
        }
        catch (Exception ex) {
            throw new LuaException(ex.getMessage());
        }
    }

    public boolean equals(@Nullable IPeripheral other) {
        return other instanceof ObserverPeripheral && ((ObserverPeripheral)other).world.equals(this.world) && ((ObserverPeripheral)other).pos.equals((Object)this.pos);
    }

    public static enum Methods {
        READ_NBT("read_nbt"),
        HAS_NBT("has_nbt"),
        READ_STATE("read_state"),
        HAS_STATE("has_state");

        private String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

