/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.traits;

import com.sosnitzka.taiga.Blocks;
import com.sosnitzka.taiga.Keybindings;
import com.sosnitzka.taiga.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitTantrum
extends AbstractTrait {
    public static float max_charges = 12.0f;
    public static float max_power = 5.0f;

    public TraitTantrum() {
        super("tantrum", TextFormatting.RED);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        World w = event.getWorld();
        if (!w.field_72995_K && event.getState().func_177230_c().equals(Blocks.tiberiumOre)) {
            event.getDrops().clear();
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            if (data.amount >= max_charges) {
                return;
            }
            data.amount = (float)((double)data.amount + (0.25 + Utils.round2(random.nextDouble() / 4.0)));
            if (data.amount >= max_charges) {
                TagUtil.setEnchantEffect((ItemStack)tool, (boolean)true);
                if (event.getHarvester() instanceof EntityPlayerMP) {
                    Sounds.PlaySoundForPlayer((Entity)event.getHarvester(), (SoundEvent)Sounds.shocking_discharge, (float)1.0f, (float)(0.8f + 0.2f * random.nextFloat()));
                }
            }
            data.write(tag);
            TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
        }
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        World w = event.getWorld();
        BlockPos pos = event.getPos();
        ItemStack tool = event.getEntityPlayer().func_184614_ca();
        if (!w.field_72995_K && TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier) && Keybindings.altKey.func_151470_d()) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            if (data.amount > 1.0f) {
                double d = Math.min(Utils.round2(random.nextDouble() * (double)data.amount), (double)max_power);
                w.func_72885_a((Entity)event.getEntityPlayer(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)Math.pow(1.2f, d), false, true);
                data.amount = (float)((double)data.amount - d);
                data.write(tag);
                TagUtil.setExtraTag((ItemStack)tool, (NBTTagCompound)tag);
                TagUtil.setEnchantEffect((ItemStack)tool, (boolean)false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack tool = e.getItemStack();
        if (TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.identifier)) {
            NBTTagCompound tag = TagUtil.getExtraTag((ItemStack)tool);
            Data data = Data.read(tag);
            e.getToolTip().add(TextFormatting.RED + "Charge: " + data.amount);
        }
    }

    public static class Data {
        float amount;

        public static Data read(NBTTagCompound tag) {
            Data data = new Data();
            data.amount = tag.func_74760_g("amount");
            return data;
        }

        public void write(NBTTagCompound tag) {
            tag.func_74776_a("amount", this.amount);
        }
    }
}

