/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.util;

import com.sosnitzka.taiga.Items;
import com.sosnitzka.taiga.TAIGA;
import java.lang.reflect.Field;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.StringUtils;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;

public class Utils {
    public static String PREFIX_INGOT = "ingot";
    public static String PREFIX_NUGGET = "nugget";
    public static String PREFIX_ORE = "ore";
    public static String PREFIX_BLOCK = "block";
    public static String PREFIX_DUST = "dust";
    public static String PREFIX_CRYSTAL = "crystal";

    public static void registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
    }

    public static void registerTinkerAlloy(FluidStack output, FluidStack ... inputs) {
        if (inputs.length >= 2 && output != null) {
            TinkerRegistry.registerAlloy((FluidStack)output, (FluidStack[])inputs);
        }
    }

    public static boolean isNight(int time) {
        return time > 12500;
    }

    public static double round2(double d) {
        return (double)Math.round(d * 100.0) / 100.0;
    }

    public static void integrateMaterial(String oreSuffix, @Nullable Material material, Fluid fluid, int headDura, float headSpeed, float headAttack, float handleMod, int handleDura, int extra, int headLevel, float draw, float range, int bdamage) {
        Utils.integrateMaterial(oreSuffix, material, fluid, headDura, headSpeed, headAttack, handleMod, handleDura, extra, headLevel, new BowMaterialStats(draw, range, (float)bdamage), false, true);
    }

    public static void integrateMaterial(String oreSuffix, @Nullable Material material, Fluid fluid, int headDura, float headSpeed, float headAttack, float handleMod, int handleDura, int extra, int headLevel, BowMaterialStats bowstats) {
        Utils.integrateMaterial(oreSuffix, material, fluid, headDura, headSpeed, headAttack, handleMod, handleDura, extra, headLevel, bowstats, false, true);
    }

    public static void integrateMaterial(String oreSuffix, @Nullable Material material, Fluid fluid, int headDura, float headSpeed, float headAttack, float handleMod, int handleDura, int extra, int headLevel, BowMaterialStats bowstats, boolean craft, boolean cast) {
        if (material != null) {
            Field[] items;
            if (TinkerRegistry.getMaterial((String)material.identifier) != Material.UNKNOWN) {
                return;
            }
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HeadMaterialStats(headDura, headSpeed, headAttack, headLevel));
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new HandleMaterialStats(handleMod, handleDura));
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)new ExtraMaterialStats(extra));
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)bowstats);
            Item item = null;
            for (Field i : items = Items.class.getDeclaredFields()) {
                if (!i.getName().equals(StringUtils.uncapitalize((String)oreSuffix) + "Ingot")) continue;
                Item r = null;
                try {
                    r = (Item)i.get(i.getType());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                item = r;
            }
            material.setFluid(fluid).setCraftable(craft).setCastable(cast).addItem(item, 1, 144);
            material.setRepresentativeItem(item);
            TAIGA.proxy.setRenderInfo(material);
        }
        MaterialIntegration integration = new MaterialIntegration(material, fluid, oreSuffix);
        integration.preInit();
        TAIGA.integrateList.add(integration);
    }

    public static void integrateOre(String oreSuffix, Fluid fluid) {
        Utils.integrateMaterial(oreSuffix, null, fluid, -1, -1.0f, -1.0f, -1.0f, -1, -1, -1, new BowMaterialStats(0.1f, 0.1f, -1.0f), true, true);
    }

    public static int nextInt(Random random, int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static class GeneralNBTData {
        public int killcount;
        public float health;
        public int brokenblocks;
        public float bonus;
        public int curse;
        public String name;
        public float radius;
        public float dfloat;
        public int dint;
        public boolean active;

        public static GeneralNBTData read(NBTTagCompound tag) {
            GeneralNBTData data = new GeneralNBTData();
            data.killcount = tag.func_74762_e("killcount");
            data.brokenblocks = tag.func_74762_e("brokenblocks");
            data.health = tag.func_74760_g("health");
            data.bonus = tag.func_74760_g("bonus");
            data.curse = tag.func_74762_e("curse");
            data.name = tag.func_74779_i("name");
            data.radius = tag.func_74760_g("radius");
            data.dfloat = tag.func_74760_g("dfloat");
            data.dint = tag.func_74762_e("dint");
            data.active = tag.func_74767_n("active");
            return data;
        }

        public void write(NBTTagCompound tag) {
            tag.func_74768_a("killcount", this.killcount);
            tag.func_74768_a("brokenblocks", this.brokenblocks);
            tag.func_74776_a("health", this.health);
            tag.func_74776_a("bonus", this.bonus);
            tag.func_74768_a("curse", this.curse);
            tag.func_74778_a("name", this.name);
            tag.func_74776_a("radius", this.radius);
            tag.func_74768_a("dint", this.dint);
            tag.func_74776_a("dfloat", this.dfloat);
            tag.func_74757_a("active", this.active);
        }
    }
}

