/*
 * Decompiled with CFR 0.152.
 */
package com.sosnitzka.taiga.world;

import com.google.common.collect.Lists;
import com.sosnitzka.taiga.Blocks;
import com.sosnitzka.taiga.TAIGA;
import com.sosnitzka.taiga.TAIGAConfiguration;
import com.sosnitzka.taiga.util.Generator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockStone;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGen
implements IWorldGenerator {
    private static WorldGen INSTANCE;
    private final List<Integer> blackList = new ArrayList<Integer>();
    private final Map<Integer, Integer> meteorGenStats = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> meteorChunkStats = new HashMap<Integer, Integer>();

    public static WorldGen getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WorldGen();
        }
        return INSTANCE;
    }

    private void nether(Random random, int x, int z, World world) {
        Generator.generateOre(Blocks.tiberiumOre.func_176223_P(), net.minecraft.init.Blocks.field_150424_aL.func_176223_P(), random, x, z, world, TAIGAConfiguration.TIBERIUM_VAL, 32, 128, 10, 35);
        Generator.generateOre(Blocks.prometheumOre.func_176223_P(), net.minecraft.init.Blocks.field_150424_aL.func_176223_P(), random, x, z, world, TAIGAConfiguration.PROMETHEUM_VAL, 0, 32, 2, 4);
        Generator.generateOre(Blocks.valyriumOre.func_176223_P(), net.minecraft.init.Blocks.field_150424_aL.func_176223_P(), random, x, z, world, TAIGAConfiguration.VALYRIUM_VAL, 0, 128, 2, 4);
        Generator.generateOre(Lists.newArrayList((Object[])new IBlockState[]{net.minecraft.init.Blocks.field_150353_l.func_176223_P(), net.minecraft.init.Blocks.field_150356_k.func_176223_P()}), Blocks.osramOre.func_176223_P(), random, x, z, world, TAIGAConfiguration.OSRAM_VAL, 0, 64, 15);
    }

    private void other(Random random, int x, int z, World world) {
        int dim = world.field_73011_w.getDimension();
        if (!this.meteorGenStats.containsKey(dim)) {
            this.meteorGenStats.put(dim, 0);
        }
        if (!this.meteorChunkStats.containsKey(dim)) {
            this.meteorChunkStats.put(dim, 0);
        }
        this.meteorChunkStats.put(dim, this.meteorChunkStats.get(dim) + 1);
        this.meteorGenStats.put(this.meteorGenStats.get(dim), this.meteorGenStats.get(dim) + Generator.generateMeteor(Blocks.duraniteOre.func_176223_P(), Blocks.blockMeteorite.func_176223_P(), random, x, z, world, TAIGAConfiguration.DURANITE_VAL, 6, 16, 112));
        Generator.generateOreDescending(Lists.newArrayList((Object[])new IBlockState[]{net.minecraft.init.Blocks.field_150353_l.func_176223_P(), net.minecraft.init.Blocks.field_150356_k.func_176223_P()}), Blocks.basaltBlock.func_176223_P(), random, x, z, world, TAIGAConfiguration.BASALT_VAL, 0, 64);
        Generator.generateOreDescending(Lists.newArrayList((Object[])new IBlockState[]{net.minecraft.init.Blocks.field_150357_h.func_176223_P()}), Blocks.eezoOre.func_176223_P(), random, x, z, world, TAIGAConfiguration.EEZO_VAL, 0, 10);
        Generator.generateOreStoneVariant(Blocks.karmesineOre.func_176223_P(), BlockStone.EnumType.ANDESITE, random, x, z, world, TAIGAConfiguration.KARMESINE_VAL);
        Generator.generateOreStoneVariant(Blocks.oviumOre.func_176223_P(), BlockStone.EnumType.DIORITE, random, x, z, world, TAIGAConfiguration.OVIUM_VAL);
        Generator.generateOreStoneVariant(Blocks.jauxumOre.func_176223_P(), BlockStone.EnumType.GRANITE, random, x, z, world, TAIGAConfiguration.JAUXUM_VAL);
        Generator.generateOre(Blocks.vibraniumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.VIBRANIUM_VAL, 100, 0, 64, 2, 6, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_150580_W, Biomes.field_76769_d}));
        Generator.generateOre(Blocks.dilithiumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.DILITHIUM_VAL, 100, 0, 64, 2, 8, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R, Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_76776_l, Biomes.field_76787_r}));
        Generator.generateOre(Blocks.vibraniumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, 1, 15, 0, 128, 1, 5, null);
        if (TAIGAConfiguration.ironGen) {
            Generator.generateOre(net.minecraft.init.Blocks.field_150366_p.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.IRON_VAL, 0, 32, 2, 8);
        }
        if (this.meteorChunkStats.get(dim) > 100 && this.meteorGenStats.get(dim) == 0) {
            this.blackList.add(dim);
            TAIGA.logger.info(String.format("Detected void dimension, adding to blacklist: %d", dim));
        }
    }

    private void world(Random random, int x, int z, World world) {
        Generator.generateMeteor(Blocks.duraniteOre.func_176223_P(), Blocks.blockMeteorite.func_176223_P(), random, x, z, world, TAIGAConfiguration.DURANITE_VAL, 6, 16, 112);
        Generator.generateOreDescending(Lists.newArrayList((Object[])new IBlockState[]{net.minecraft.init.Blocks.field_150353_l.func_176223_P(), net.minecraft.init.Blocks.field_150356_k.func_176223_P()}), Blocks.basaltBlock.func_176223_P(), random, x, z, world, TAIGAConfiguration.BASALT_VAL, 0, 64);
        Generator.generateOreDescending(Lists.newArrayList((Object[])new IBlockState[]{net.minecraft.init.Blocks.field_150357_h.func_176223_P()}), Blocks.eezoOre.func_176223_P(), random, x, z, world, TAIGAConfiguration.EEZO_VAL, 0, 10);
        Generator.generateOreStoneVariant(Blocks.karmesineOre.func_176223_P(), BlockStone.EnumType.ANDESITE, random, x, z, world, TAIGAConfiguration.KARMESINE_VAL);
        Generator.generateOreStoneVariant(Blocks.oviumOre.func_176223_P(), BlockStone.EnumType.DIORITE, random, x, z, world, TAIGAConfiguration.OVIUM_VAL);
        Generator.generateOreStoneVariant(Blocks.jauxumOre.func_176223_P(), BlockStone.EnumType.GRANITE, random, x, z, world, TAIGAConfiguration.JAUXUM_VAL);
        Generator.generateOre(Blocks.vibraniumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.VIBRANIUM_VAL, 100, 0, 64, 2, 6, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76786_s, Biomes.field_76770_e, Biomes.field_76783_v, Biomes.field_150580_W, Biomes.field_76769_d}));
        Generator.generateOre(Blocks.dilithiumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.DILITHIUM_VAL, 100, 0, 64, 2, 8, Lists.newArrayList((Object[])new Biome[]{Biomes.field_76769_d, Biomes.field_76786_s, Biomes.field_185442_R, Biomes.field_76771_b, Biomes.field_150575_M, Biomes.field_76776_l, Biomes.field_76787_r}));
        Generator.generateOre(Blocks.vibraniumOre.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, 1, 15, 0, 128, 1, 5, null);
        if (TAIGAConfiguration.ironGen) {
            Generator.generateOre(net.minecraft.init.Blocks.field_150366_p.func_176223_P(), net.minecraft.init.Blocks.field_150348_b.func_176223_P(), random, x, z, world, TAIGAConfiguration.IRON_VAL, 0, 32, 2, 8);
        }
    }

    private void end(Random random, int x, int z, World world) {
        Generator.generateCube(true, Blocks.uruOre.func_176223_P(), Blocks.blockObsidiorite.func_176223_P(), random, x, z, world, TAIGAConfiguration.URU_VAL, 2, 0, 96, 3);
        if (TAIGAConfiguration.endGen) {
            Generator.generateOre(net.minecraft.init.Blocks.field_150350_a.func_176223_P(), net.minecraft.init.Blocks.field_150377_bs.func_176223_P(), null, null, random, x, z, world, 1, 100, 3, 64, 3, 8, null);
        }
        Generator.generateOre(Blocks.auroriumOre.func_176223_P(), net.minecraft.init.Blocks.field_150377_bs.func_176223_P(), random, x, z, world, TAIGAConfiguration.AURORIUM_VAL, 32, 48, 2, 4);
        Generator.generateOre(Blocks.palladiumOre.func_176223_P(), net.minecraft.init.Blocks.field_150377_bs.func_176223_P(), random, x, z, world, TAIGAConfiguration.PALLADIUM_VAL, 48, 64, 2, 4);
        Generator.generateOreBottom(net.minecraft.init.Blocks.field_150377_bs.func_176223_P(), Blocks.abyssumOre.func_176223_P(), random, x, z, world, TAIGAConfiguration.ABYSSUM_VAL, 4, 64);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int x = chunkX * 16;
        int z = chunkZ * 16;
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.nether(random, x, z, world);
                break;
            }
            case 0: {
                this.world(random, x, z, world);
                break;
            }
            case 1: {
                this.end(random, x, z, world);
                break;
            }
            default: {
                if (this.blackList.contains(world.field_73011_w.getDimension())) break;
                this.other(random, x, z, world);
            }
        }
    }
}

