/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.DistributorItem;
import astavie.thermallogistics.attachment.IAttachmentCrafter;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.Recipe;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.compat.ICrafterWrapper;
import astavie.thermallogistics.container.ContainerCrafter;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.EmptyList;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.ItemType;
import astavie.thermallogistics.util.type.Type;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.api.tileentity.IRedstoneControl;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.filter.IFilterItems;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.render.RenderDuct;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class CrafterItem
extends ServoItem
implements IAttachmentCrafter<ItemStack> {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "crafter_item");
    public static final int[] SIZE = new int[]{1, 2, 3, 4, 6};
    public static final int[][] SPLITS = new int[][]{{1}, {2, 1}, {3, 1}, {4, 2, 1}, {6, 3, 2, 1}};
    private final List<Recipe<ItemStack>> recipes = NonNullList.func_191196_a();
    private boolean processParallel = false;
    private int currentRecipe = -1;
    private final IFilterItems filter2 = new IFilterItems(){

        public boolean matchesFilter(ItemStack item) {
            CrafterItem.this.checkCache();
            return true;
        }

        public boolean shouldIncRouteItems() {
            return true;
        }

        public int getMaxStock() {
            return Integer.MAX_VALUE;
        }
    };

    public CrafterItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        Recipe<ItemStack> recipe = this.newRecipe(0);
        recipe.inputs.addAll(Collections.nCopies(SIZE[type] * 2, ItemStack.field_190927_a));
        recipe.outputs.addAll(Collections.nCopies(SIZE[type], ItemStack.field_190927_a));
        this.recipes.add(recipe);
        this.rsMode = IRedstoneControl.ControlMode.DISABLED;
    }

    public CrafterItem(TileGrid tile, byte side) {
        super(tile, side);
        this.rsMode = IRedstoneControl.ControlMode.DISABLED;
    }

    public FilterLogic createFilterLogic() {
        FilterLogic filter = super.createFilterLogic();
        if (this.baseTile != null && this.baseTile.world() != null && !this.baseTile.world().field_72995_K) {
            filter.setLevel(3, 64);
        }
        return filter;
    }

    @Override
    public boolean processParallel() {
        return this.processParallel;
    }

    @Override
    public void processParallel(boolean parallel) {
        this.processParallel = parallel;
    }

    @Override
    public int currentRecipe() {
        return this.currentRecipe;
    }

    public boolean canAlterRS() {
        return false;
    }

    private Recipe<ItemStack> newRecipe(int index) {
        return new Recipe.Item(this, index);
    }

    public IFilterItems getItemFilter() {
        return this.filter2;
    }

    public boolean canSend() {
        return false;
    }

    public boolean allowDuctConnection() {
        return true;
    }

    public String getInfo() {
        return "tab.thermallogistics.crafterItem";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.crafter, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.CRAFTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    public void tick(int pass) {
        if (pass == 0) {
            this.checkCache();
        }
        super.tick(pass);
    }

    private void checkCache() {
        if (((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] != null && !(((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] instanceof CacheWrapper)) {
            ((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side] = new CacheWrapper(((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side].tile, this);
        }
    }

    public ItemStack insertItem(ItemStack item, boolean simulate) {
        ItemType type = new ItemType(item);
        for (Recipe<ItemStack> recipe : this.recipes) {
            for (StackList list : recipe.requestOutput.values()) {
                if (list.amount(type) <= 0L) continue;
                return item;
            }
        }
        ItemStack remain = super.insertItem(item, simulate);
        if (!simulate) {
            long sent = item.func_190916_E() - remain.func_190916_E();
            for (Recipe<ItemStack> recipe : this.recipes) {
                if ((sent = recipe.leftovers.remove(type, sent)) != 0L) continue;
                break;
            }
        }
        return remain;
    }

    public TravelingItem getRouteForItem(ItemStack item) {
        if (!this.verifyCache()) {
            return null;
        }
        return DistributorItem.findRouteForItem((ItemStack)item, (Iterator)this.routesWithInsertSideList.iterator(), (DuctUnitItem)this.itemDuct, (int)this.side, (int)this.getMaxRange(), (byte)this.getSpeed());
    }

    public void handleItemSending() {
        for (Recipe<ItemStack> recipe : this.recipes) {
            recipe.check();
        }
        boolean onlyCheck = false;
        for (int i = 0; i < this.recipes.size(); ++i) {
            boolean actuallyDoIt;
            Recipe<ItemStack> recipe = this.recipes.get(i);
            if (!recipe.isEnabled()) continue;
            boolean bl = actuallyDoIt = !onlyCheck && (this.processParallel || this.currentRecipe == i);
            if (actuallyDoIt) {
                onlyCheck = recipe.updateMissing();
            }
            if (!recipe.process.update(!actuallyDoIt)) continue;
            onlyCheck = true;
        }
        if (!this.processParallel) {
            int lastRecipe = this.currentRecipe;
            if (this.currentRecipe == -1) {
                this.currentRecipe = 0;
            }
            while (this.currentRecipe < this.recipes.size() && this.recipes.get(this.currentRecipe).isDone()) {
                ++this.currentRecipe;
            }
            if (this.currentRecipe >= this.recipes.size()) {
                this.currentRecipe = 0;
            }
            while (this.currentRecipe < lastRecipe && this.recipes.get(this.currentRecipe).isDone()) {
                ++this.currentRecipe;
            }
            if (this.recipes.get(this.currentRecipe).isDone()) {
                this.currentRecipe = -1;
            }
            if (lastRecipe != this.currentRecipe) {
                PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
            }
        } else {
            this.currentRecipe = -1;
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        NBTTagList recipes = new NBTTagList();
        for (Recipe<ItemStack> recipe : this.recipes) {
            Object stack22;
            NBTTagList inputs = new NBTTagList();
            for (Object stack22 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)stack22.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList outputs = new NBTTagList();
            stack22 = recipe.outputs.iterator();
            while (stack22.hasNext()) {
                ItemStack stack3 = (ItemStack)stack22.next();
                outputs.func_74742_a((NBTBase)stack3.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList linked = new NBTTagList();
            for (RequesterReference requesterReference : recipe.linked) {
                linked.func_74742_a((NBTBase)RequesterReference.writeNBT(requesterReference));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            nbt.func_74782_a("linked", (NBTBase)linked);
            nbt.func_74782_a("requestInput", (NBTBase)StackHandler.writeRequestMap(recipe.requestInput));
            nbt.func_74782_a("requestOutput", (NBTBase)StackHandler.writeRequestMap(recipe.requestOutput));
            nbt.func_74782_a("leftovers", (NBTBase)recipe.leftovers.writeNbt());
            nbt.func_74782_a("missing", (NBTBase)recipe.missing.writeNbt());
            nbt.func_74757_a("disabled", !recipe.enabled);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74757_a("parallel", this.processParallel);
        tag.func_74768_a("recipe", this.currentRecipe);
        tag.func_74782_a("recipes", (NBTBase)recipes);
    }

    public void readFromNBT(NBTTagCompound tag) {
        boolean enabled;
        super.readFromNBT(tag);
        this.recipes.clear();
        boolean bl = enabled = tag.func_74764_b("rsMode") && tag.func_74771_c("rsMode") == 0;
        if (tag.func_74764_b("Inputs") || tag.func_74764_b("Outputs") || tag.func_74764_b("Linked")) {
            Recipe<ItemStack> recipe = this.newRecipe(0);
            recipe.enabled = true;
            recipe.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, ItemStack.field_190927_a));
            recipe.outputs.addAll(Collections.nCopies(SIZE[this.type], ItemStack.field_190927_a));
            NBTTagList inputs = tag.func_150295_c("Inputs", 10);
            for (int i = 0; i < inputs.func_74745_c(); ++i) {
                NBTTagCompound compound = inputs.func_150305_b(i);
                recipe.inputs.set(compound.func_74762_e("Slot"), new ItemStack(compound));
            }
            NBTTagList outputs = tag.func_150295_c("Outputs", 10);
            for (int i = 0; i < outputs.func_74745_c(); ++i) {
                NBTTagCompound compound = outputs.func_150305_b(i);
                recipe.outputs.set(compound.func_74762_e("Slot"), new ItemStack(compound));
            }
            this.recipes.add(recipe);
            NBTTagList linked = tag.func_150295_c("Linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                recipe.linked.add(RequesterReference.readNBT(compound));
            }
        } else if (tag.func_74764_b("sent") || tag.func_74764_b("process") || tag.func_74764_b("linked")) {
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<ItemStack> recipe = this.newRecipe(i);
                recipe.enabled = enabled;
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(new ItemStack(inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(new ItemStack(outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            NBTTagList linked = tag.func_150295_c("linked", 10);
            for (int i = 0; i < linked.func_74745_c(); ++i) {
                NBTTagCompound compound = linked.func_150305_b(i);
                for (int j = 0; j < this.recipes.size(); ++j) {
                    compound.func_74768_a("index", j);
                    this.recipes.get((int)j).linked.add(RequesterReference.readNBT(compound));
                }
            }
        } else {
            this.processParallel = tag.func_74767_n("parallel");
            this.currentRecipe = tag.func_74762_e("recipe");
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<ItemStack> recipe = this.newRecipe(i);
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(new ItemStack(inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(new ItemStack(outputs.func_150305_b(j)));
                }
                NBTTagList linked = nbt.func_150295_c("linked", 10);
                for (int j = 0; j < linked.func_74745_c(); ++j) {
                    recipe.linked.add(RequesterReference.readNBT(linked.func_150305_b(j)));
                }
                recipe.requestInput = StackHandler.readRequestMap(nbt.func_150295_c("requestInput", 10), ItemList::new);
                recipe.requestOutput = StackHandler.readRequestMap(nbt.func_150295_c("requestOutput", 10), ItemList::new);
                recipe.leftovers.readNbt(nbt.func_150295_c("leftovers", 10));
                recipe.missing.readNbt(nbt.func_150295_c("missing", 10));
                recipe.enabled = enabled || nbt.func_74764_b("disabled") && !nbt.func_74767_n("disabled");
                this.recipes.add(recipe);
            }
        }
    }

    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        super.writePortableData(player, tag);
        NBTTagList recipes = new NBTTagList();
        for (Recipe<ItemStack> recipe : this.recipes) {
            Object stack2;
            NBTTagList inputs = new NBTTagList();
            for (Object stack2 : recipe.inputs) {
                inputs.func_74742_a((NBTBase)stack2.func_77955_b(new NBTTagCompound()));
            }
            NBTTagList outputs = new NBTTagList();
            stack2 = recipe.outputs.iterator();
            while (stack2.hasNext()) {
                ItemStack stack3 = (ItemStack)stack2.next();
                outputs.func_74742_a((NBTBase)stack3.func_77955_b(new NBTTagCompound()));
            }
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inputs", (NBTBase)inputs);
            nbt.func_74782_a("outputs", (NBTBase)outputs);
            recipes.func_74742_a((NBTBase)nbt);
        }
        tag.func_74778_a("DisplayType", new ItemStack((Item)ThermalLogistics.Items.crafter).func_77977_a() + ".name");
        tag.func_74768_a("recipesType", this.type);
        tag.func_74778_a("recipesClass", "ItemStack");
        tag.func_74782_a("recipes", (NBTBase)recipes);
        tag.func_74757_a("parallel", this.processParallel);
    }

    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        super.readPortableData(player, tag);
        if (tag.func_74762_e("recipesType") == this.type && tag.func_74779_i("recipesClass").equals("ItemStack")) {
            this.processParallel = tag.func_74767_n("parallel");
            this.recipes.clear();
            NBTTagList recipes = tag.func_150295_c("recipes", 10);
            for (int i = 0; i < recipes.func_74745_c(); ++i) {
                NBTTagCompound nbt = recipes.func_150305_b(i);
                Recipe<ItemStack> recipe = this.newRecipe(i);
                NBTTagList inputs = nbt.func_150295_c("inputs", 10);
                for (int j = 0; j < inputs.func_74745_c(); ++j) {
                    recipe.inputs.add(new ItemStack(inputs.func_150305_b(j)));
                }
                NBTTagList outputs = nbt.func_150295_c("outputs", 10);
                for (int j = 0; j < outputs.func_74745_c(); ++j) {
                    recipe.outputs.add(new ItemStack(outputs.func_150305_b(j)));
                }
                this.recipes.add(recipe);
            }
            this.markDirty();
        }
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCrafter(inventory, this);
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCrafter(inventory, this);
    }

    public void handleInfoPacketType(byte a, PacketBase payload, boolean isServer, EntityPlayer player) {
        if (a == 0) {
            if (isServer) {
                byte message = payload.getByte();
                if (message == 0) {
                    int recipe = payload.getInt();
                    boolean input = payload.getBool();
                    int index = payload.getInt();
                    ItemStack stack = payload.getItemStack();
                    if (recipe < this.recipes.size()) {
                        Recipe<ItemStack> r = this.recipes.get(recipe);
                        if (input) {
                            if (index < r.inputs.size()) {
                                r.inputs.set(index, stack);
                                this.markDirty();
                            }
                        } else if (index < r.outputs.size()) {
                            r.outputs.set(index, stack);
                            this.markDirty();
                        }
                    }
                } else if (message == 1) {
                    int split = payload.getInt();
                    if (Ints.contains((int[])SPLITS[this.type], (int)split)) {
                        this.split(split);
                        this.markDirty();
                    }
                } else if (message == 2) {
                    int index1 = payload.getInt();
                    int index2 = payload.getInt();
                    if (index1 < this.recipes.size()) {
                        Recipe<ItemStack> recipe = this.recipes.get(index1);
                        if (index2 < recipe.linked.size()) {
                            recipe.unlink((ICrafter)recipe.linked.get(index2).get());
                        }
                    }
                } else if (message == 3) {
                    ICrafterWrapper<?> wrapper;
                    TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this.baseTile, (int)this.side);
                    if (tile != null && (wrapper = ThermalLogistics.INSTANCE.getWrapper(tile.getClass())) != null) {
                        List<RequesterReference<?>> linked = this.recipes.get((int)0).linked;
                        this.recipes.clear();
                        Recipe<ItemStack> recipe = this.newRecipe(0);
                        recipe.inputs.addAll(Collections.nCopies(SIZE[this.type] * 2, ItemStack.field_190927_a));
                        recipe.outputs.addAll(Collections.nCopies(SIZE[this.type], ItemStack.field_190927_a));
                        wrapper.populateCast(tile, (byte)(this.side ^ 1), recipe, ItemStack.class);
                        recipe.linked.addAll(linked);
                        this.recipes.add(recipe);
                        this.markDirty();
                    }
                } else if (message == 4) {
                    int recipe = payload.getInt();
                    if (recipe < this.recipes.size()) {
                        int i;
                        Recipe<ItemStack> r = this.recipes.get(recipe);
                        for (i = 0; i < r.inputs.size(); ++i) {
                            r.inputs.set(i, payload.getItemStack());
                        }
                        for (i = 0; i < r.outputs.size(); ++i) {
                            r.outputs.set(i, payload.getItemStack());
                        }
                        this.markDirty();
                    }
                } else if (message == 5) {
                    ItemStack stack;
                    int index = payload.getInt();
                    if (index >= 0 && index < this.recipes.size() && (stack = player.field_71071_by.func_70445_o()).func_77973_b() == ThermalLogistics.Items.manager) {
                        ThermalLogistics.Items.manager.link(player, stack, (ICrafter)this.recipes.get(index));
                        ((EntityPlayerMP)player).func_71113_k();
                        this.markDirty();
                    }
                } else if (message == 6) {
                    int index = payload.getInt();
                    if (index >= 0 && index < this.recipes.size()) {
                        Recipe<ItemStack> recipe = this.recipes.get(index);
                        recipe.toggleEnabled();
                        this.markDirty();
                    }
                } else if (message == 7) {
                    this.processParallel = !this.processParallel;
                    this.markDirty();
                }
                PacketHandler.sendToAllAround((PacketBase)this.getGuiPacket(), (TileEntity)this.baseTile);
            } else {
                int j;
                Recipe<ItemStack> recipe;
                int i;
                int size;
                byte message = payload.getByte();
                if (message == 0) {
                    this.recipes.clear();
                    size = payload.getInt();
                    for (i = 0; i < size; ++i) {
                        recipe = this.newRecipe(i);
                        int inputs = payload.getInt();
                        for (j = 0; j < inputs; ++j) {
                            recipe.inputs.add(payload.getItemStack());
                        }
                        int outputs = payload.getInt();
                        for (int j2 = 0; j2 < outputs; ++j2) {
                            recipe.outputs.add(payload.getItemStack());
                        }
                        recipe.enabled = payload.getBool();
                        this.recipes.add(recipe);
                    }
                    this.processParallel = payload.getBool();
                    this.currentRecipe = payload.getInt();
                }
                if (message == 0 || message == 1) {
                    size = payload.getInt();
                    for (i = 0; i < size && i < this.recipes.size(); ++i) {
                        recipe = this.recipes.get(i);
                        int linked = payload.getInt();
                        recipe.linked.clear();
                        for (j = 0; j < linked; ++j) {
                            recipe.linked.add(RequesterReference.readPacket(payload));
                        }
                        recipe.requestInput = StackHandler.readRequestMap(payload, ItemList::new);
                        recipe.missing.readPacket(payload);
                        recipe.requestOutput = StackHandler.readRequestMap(payload, ItemList::new);
                        recipe.leftovers.readPacket(payload);
                    }
                }
            }
        } else {
            super.handleInfoPacketType(a, payload, isServer, player);
        }
    }

    public boolean openGui(EntityPlayer player) {
        if (ServerHelper.isServerWorld((World)this.baseTile.world())) {
            PacketHandler.sendTo((PacketBase)this.getGuiPacket(), (EntityPlayer)player);
            player.openGui((Object)ThermalDynamics.instance, 10 + this.side, this.baseTile.func_145831_w(), this.baseTile.x(), this.baseTile.y(), this.baseTile.z());
        }
        return true;
    }

    private PacketTileInfo getGuiPacket() {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(0);
        packet.addInt(this.recipes.size());
        for (Recipe<ItemStack> recipe : this.recipes) {
            packet.addInt(recipe.inputs.size());
            for (ItemStack input : recipe.inputs) {
                packet.addItemStack(input);
            }
            packet.addInt(recipe.outputs.size());
            for (ItemStack output : recipe.outputs) {
                packet.addItemStack(output);
            }
            packet.addBool(recipe.enabled);
        }
        packet.addBool(this.processParallel);
        packet.addInt(this.currentRecipe);
        this.writeSyncPacket(packet);
        return packet;
    }

    private void writeSyncPacket(PacketTileInfo packet) {
        this.checkLinked();
        packet.addInt(this.recipes.size());
        for (Recipe<ItemStack> recipe : this.recipes) {
            packet.addInt(recipe.linked.size());
            for (RequesterReference<?> reference : recipe.linked) {
                RequesterReference.writePacket((PacketBase)packet, reference);
            }
            StackHandler.writeRequestMap(recipe.requestInput, (PacketBase)packet);
            recipe.missing.writePacket((PacketBase)packet);
            StackHandler.writeRequestMap(recipe.requestOutput, (PacketBase)packet);
            recipe.leftovers.writePacket((PacketBase)packet);
        }
    }

    private void checkLinked() {
        for (Recipe<ItemStack> recipe : this.recipes) {
            recipe.checkLinked();
        }
    }

    @Override
    public Class<ItemStack> getItemClass() {
        return ItemStack.class;
    }

    @Override
    public void split(int split) {
        ItemStack[] inputs = new ItemStack[SIZE[this.type] * 2];
        ItemStack[] outputs = new ItemStack[SIZE[this.type]];
        int recipeSize = SIZE[this.type] / this.recipes.size();
        for (int i = 0; i < this.recipes.size(); ++i) {
            Recipe<ItemStack> recipe = this.recipes.get(i);
            for (int j = 0; j < recipeSize; ++j) {
                inputs[(i * recipeSize + j) * 2] = (ItemStack)recipe.inputs.get(j * 2);
                inputs[(i * recipeSize + j) * 2 + 1] = (ItemStack)recipe.inputs.get(j * 2 + 1);
                outputs[i * recipeSize + j] = (ItemStack)recipe.outputs.get(j);
            }
        }
        List lists = this.recipes.stream().map(r -> r.linked).collect(Collectors.toList());
        this.recipes.clear();
        int recipes = SIZE[this.type] / split;
        for (int i = 0; i < recipes; ++i) {
            Recipe<ItemStack> recipe = this.newRecipe(i);
            for (int j = 0; j < split; ++j) {
                recipe.inputs.add(inputs[(i * split + j) * 2]);
                recipe.inputs.add(inputs[(i * split + j) * 2 + 1]);
                recipe.outputs.add(outputs[i * split + j]);
            }
            if (i < lists.size()) {
                recipe.linked.addAll((Collection)lists.get(i));
            }
            this.recipes.add(recipe);
        }
    }

    @Override
    public void sync(EntityPlayer player) {
        PacketTileInfo packet = this.getNewPacket((byte)0);
        packet.addByte(1);
        this.writeSyncPacket(packet);
        PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
    }

    @Override
    public void markDirty() {
        this.baseTile.markChunkDirty();
    }

    @Override
    public List<? extends ICrafter<ItemStack>> getCrafters() {
        return this.recipes;
    }

    @Override
    public List<Recipe<ItemStack>> getRecipes() {
        return this.recipes;
    }

    @Override
    public Supplier<StackList<ItemStack>> getSupplier() {
        return ItemList::new;
    }

    private void handleInsertedStack(Type<ItemStack> type, long amount) {
        for (Recipe<ItemStack> recipe : this.recipes) {
            amount = ((StackList)recipe.requestInput.getOrDefault(null, EmptyList.getInstance())).remove(type, amount);
            if (amount != 0L) continue;
            return;
        }
    }

    private static class Inventory
    implements IItemHandler {
        private final CrafterItem crafter;
        private final IItemHandler inv;

        private Inventory(CrafterItem crafter, IItemHandler inv) {
            this.crafter = crafter;
            this.inv = inv;
        }

        public int getSlots() {
            return this.inv.getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.inv.getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remain;
            if (simulate) {
                if (StackHandler.SIM) {
                    return this.inv.insertItem(slot, stack, simulate);
                }
                return stack;
            }
            long required = 0L;
            ItemType type = new ItemType(stack);
            for (Recipe recipe : this.crafter.recipes) {
                required += ((StackList)recipe.requestInput.getOrDefault(null, EmptyList.getInstance())).amount(type);
            }
            if (required == 0L) {
                return stack;
            }
            long insert = Math.min((long)stack.func_190916_E(), required);
            long inserted = insert - (long)(remain = this.inv.insertItem(slot, (ItemStack)type.withAmount((int)insert), false)).func_190916_E();
            if (inserted > 0L) {
                this.crafter.handleInsertedStack(type, inserted);
            }
            return (ItemStack)type.withAmount(stack.func_190916_E() - (int)inserted);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inv.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.inv.getSlotLimit(slot);
        }
    }

    private static class CacheWrapper
    extends DuctUnitItem.Cache {
        private final CrafterItem crafter;

        private CacheWrapper(@Nonnull TileEntity tile, @Nonnull CrafterItem attachment) {
            super(tile, (Attachment)attachment);
            this.crafter = attachment;
        }

        public IItemHandler getItemHandler(int face) {
            return new Inventory(this.crafter, super.getItemHandler(EnumFacing.func_82600_a((int)face)));
        }

        public IItemHandler getItemHandler(EnumFacing face) {
            return new Inventory(this.crafter, super.getItemHandler(face));
        }
    }
}

