/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.attachment;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.process.IProcessRequesterItem;
import astavie.thermallogistics.process.ProcessItem;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.EmptyListWrapper;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.ListWrapperWrapper;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import cofh.thermaldynamics.duct.attachments.retriever.RetrieverItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.render.RenderDuct;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class RequesterItem
extends RetrieverItem
implements IProcessRequesterItem {
    public static final ResourceLocation ID = new ResourceLocation("thermallogistics", "requester_item");
    private final ProcessItem process = new ProcessItem(this);
    private Map<RequesterReference<ItemStack>, StackList<ItemStack>> requests = new HashMap<RequesterReference<ItemStack>, StackList<ItemStack>>();

    public RequesterItem(TileGrid tile, byte side) {
        super(tile, side);
    }

    public RequesterItem(TileGrid tile, byte side, int type) {
        super(tile, side, type);
        this.filter.handleFlagByte(24);
    }

    public String getInfo() {
        return "tab.thermallogistics.requesterItem";
    }

    public ResourceLocation getId() {
        return ID;
    }

    public ItemStack getPickBlock() {
        return new ItemStack((Item)ThermalLogistics.Items.requester, 1, this.type);
    }

    public String getName() {
        return this.getPickBlock().func_77977_a() + ".name";
    }

    public boolean render(IBlockAccess world, BlockRenderLayer layer, CCRenderState ccRenderState) {
        if (layer != BlockRenderLayer.SOLID) {
            return false;
        }
        Translation trans = Vector3.fromTileCenter((TileEntity)this.baseTile).translation();
        RenderDuct.modelConnection[this.isPowered ? 1 : 2][this.side].render(ccRenderState, new IVertexOperation[]{trans, new IconTransformation(TLTextures.REQUESTER[this.stuffed ? 1 : 0][this.type])});
        return true;
    }

    public void handleItemSending() {
        this.process.update(false);
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74782_a("requests", (NBTBase)StackHandler.writeRequestMap(this.requests));
    }

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.requests = StackHandler.readRequestMap(tag.func_150295_c("requests", 10), ItemList::new);
    }

    @Override
    public boolean referencedBy(RequesterReference<?> reference) {
        return reference.dim == this.baseTile.world().field_73011_w.getDimension() && reference.pos.equals((Object)this.baseTile.func_174877_v()) && reference.side == this.side;
    }

    @Override
    public RequesterReference<ItemStack> createReference() {
        return new RequesterReference<ItemStack>(this.baseTile.world().field_73011_w.getDimension(), this.baseTile.func_174877_v(), this.side);
    }

    @Override
    public void onFail(RequesterReference<ItemStack> crafter, Type<ItemStack> type, long amount) {
        StackList<ItemStack> list;
        if (this.requests.containsKey(crafter) && (list = this.requests.get(crafter)) != null) {
            list.remove(type, amount);
            if (list.isEmpty()) {
                this.requests.remove(crafter);
                this.markDirty();
            }
        }
    }

    @Override
    public ItemStack getIcon() {
        return this.getPickBlock();
    }

    @Override
    public ItemStack getTileIcon() {
        return this.myTile == null ? ItemStack.field_190927_a : this.myTile.func_145838_q().func_185473_a(this.myTile.func_145831_w(), this.myTile.func_174877_v(), this.myTile.func_145831_w().func_180495_p(this.myTile.func_174877_v()));
    }

    @Override
    public StackList<ItemStack> getRequestedStacks() {
        return new ItemList();
    }

    @Override
    public StackList<ItemStack> getRequestedStacks(ICrafter<ItemStack> crafter) {
        return this.requests.getOrDefault(crafter.createReference(), new ItemList());
    }

    @Override
    public void onFail(Type<ItemStack> type, long amount) {
    }

    @Override
    public void onCrafterSend(ICrafter<ItemStack> crafter, Type<ItemStack> type, long amount) {
        this.onFail(crafter.createReference(), type, amount);
    }

    @Override
    public BlockPos getDestination() {
        return this.baseTile.func_174877_v().func_177972_a(EnumFacing.func_82600_a((int)this.side));
    }

    @Override
    @Nullable
    public DuctUnit<?, ?, ?> getDuct() {
        return this.itemDuct;
    }

    @Override
    public byte getSide() {
        return (byte)(this.side ^ 1);
    }

    @Override
    public int maxSize() {
        return this.getMaxSend();
    }

    @Override
    public boolean multiStack() {
        return multiStack[this.type];
    }

    @Override
    public byte speedBoost() {
        return this.getSpeed();
    }

    @Override
    public Map<RequesterReference<ItemStack>, StackList<ItemStack>> getRequests() {
        HashMap<RequesterReference<ItemStack>, StackList<ItemStack>> copy = new HashMap<RequesterReference<ItemStack>, StackList<ItemStack>>();
        for (Map.Entry<RequesterReference<ItemStack>, StackList<ItemStack>> entry : this.requests.entrySet()) {
            copy.put(entry.getKey(), entry.getValue().copy());
        }
        return copy;
    }

    @Override
    public ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources() {
        if (!this.verifyCache()) {
            return new EmptyListWrapper();
        }
        return new ListWrapperWrapper<Route, Pair>(this.routesWithInsertSideList, r -> Pair.of((Object)((DuctUnit)r.endPoint), (Object)r.getLastSide()));
    }

    @Override
    public boolean hasWants() {
        return true;
    }

    @Override
    public long amountRequired(Type<ItemStack> type) {
        return this.filter.matchesFilter(type.getAsStack()) ? Math.max(0L, Math.min((long)this.filter.getMaxStock() - this.amountInside(type), (long)this.maxFill(type))) : 0L;
    }

    @Override
    public long amountEmpty(Type<ItemStack> type) {
        return Integer.MAX_VALUE;
    }

    private long amountInside(Type<ItemStack> type) {
        DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])this.itemDuct.tileCache)[this.side];
        if (cache == null) {
            return 0L;
        }
        IItemHandler inv = cache.getItemHandler(this.side ^ 1);
        if (inv == null) {
            return 0L;
        }
        int travelling = 0;
        StackMap map = ((GridItem)this.itemDuct.getGrid()).travelingItems.getOrDefault(this.getDestination(), new StackMap());
        for (ItemStack item : map.getItems()) {
            if (!type.references(item)) continue;
            travelling += item.func_190916_E();
        }
        for (StackList<ItemStack> list : this.requests.values()) {
            travelling = (int)((long)travelling + list.amount((ItemStack)type));
        }
        return DuctUnitItem.getNumItems((IItemHandler)inv, (int)(this.side ^ 1), (ItemStack)type.getAsStack(), (int)Integer.MAX_VALUE) + travelling;
    }

    private int maxFill(Type<ItemStack> type) {
        int remaining = StackHandler.canRouteItem(this.itemDuct, type.withAmount(Integer.MAX_VALUE), this.side, this);
        return Integer.MAX_VALUE - remaining;
    }

    @Override
    public void addRequest(Request<ItemStack> request) {
        if (!request.isError()) {
            this.requests.computeIfAbsent(request.source.crafter, c -> new ItemList());
            this.requests.get(request.source.crafter).add(request.type, request.amount);
            this.markDirty();
        }
    }

    public void markDirty() {
        this.baseTile.markChunkDirty();
    }
}

