/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public abstract class GuiOverlay
extends GuiContainerCore {
    public Overlay overlay;

    public GuiOverlay(Container container, ResourceLocation texture) {
        super(container, texture);
    }

    public void setOverlay(Overlay overlay) {
        if (this.overlay != null) {
            this.elements.remove((Object)this.overlay);
        }
        this.overlay = overlay;
        if (this.overlay != null) {
            this.elements.add(this.overlay);
        }
    }

    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (this.overlay != null && !this.withinOverlay(mX - this.field_147003_i, mY - this.field_147009_r)) {
            this.setOverlay(null);
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    protected boolean withinOverlay(int x, int y) {
        return this.overlay != null && this.getElementAtPosition(x, y) == this.overlay;
    }

    protected abstract int getOverlaySheetX();

    protected abstract int getOverlaySheetY();

    protected ResourceLocation getOverlayTexture() {
        return this.texture;
    }

    private void overlay(int x, int y, int width, int height) {
        this.nineInchSprite(x, y, width - 8, height - 8, 1, 4, this.getOverlaySheetX(), this.getOverlaySheetY());
    }

    private void nineInchSprite(int x, int y, int width, int height, int middle, int edge, int sheetX, int sheetY) {
        this.func_73729_b(x, y, sheetX, sheetY, edge, edge);
        this.func_73729_b(x + edge + width * middle, y, sheetX + middle + edge, sheetY, edge, edge);
        this.func_73729_b(x, y + edge + height * middle, sheetX, sheetY + middle + edge, edge, edge);
        this.func_73729_b(x + edge + width * middle, y + edge + height * middle, sheetX + middle + edge, sheetY + middle + edge, edge, edge);
        for (int i = 0; i < width; ++i) {
            this.func_73729_b(x + edge + i * middle, y, sheetX + edge, sheetY, middle, edge);
            for (int j = 0; j < height; ++j) {
                if (i == 0) {
                    this.func_73729_b(x, y + edge + j * middle, sheetX, sheetY + edge, edge, middle);
                }
                this.func_73729_b(x + edge + i * middle, y + edge + j * middle, sheetX + edge, sheetY + edge, middle, middle);
                if (i != width - 1) continue;
                this.func_73729_b(x + edge + width * middle, y + edge + j * middle, sheetX + middle + edge, sheetY + edge, edge, middle);
            }
            this.func_73729_b(x + edge + i * middle, y + edge + height * middle, sheetX + edge, sheetY + middle + edge, middle, edge);
        }
    }

    public void addTooltips(List<String> tooltip) {
        if (this.withinOverlay(this.mouseX, this.mouseY)) {
            this.overlay.addTooltip(tooltip);
        } else {
            super.addTooltips(tooltip);
        }
    }

    public static class Overlay
    extends ElementBase {
        public List<ElementBase> elements = new LinkedList<ElementBase>();
        private float ticks;
        private GuiOverlay gui;

        public Overlay(GuiOverlay gui, int posX, int posY, int width, int height) {
            super((GuiContainerCore)gui, posX - 4, posY - 4, width + 8, height + 8);
            this.gui = gui;
        }

        public void setPos(int posX, int posY) {
            this.posX = posX - 4;
            this.posY = posY - 4;
        }

        public void setDimensions(int width, int height) {
            this.sizeX = width + 8;
            this.sizeY = height + 8;
        }

        public void drawBackground(int mouseX, int mouseY, float gameTicks) {
            this.ticks = gameTicks;
        }

        public void drawForeground(int mouseX, int mouseY) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)400.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.gui.bindTexture(this.gui.getOverlayTexture());
            this.gui.overlay(this.posX, this.posY, this.sizeX, this.sizeY);
            GlStateManager.func_179109_b((float)(this.posX + 4), (float)(this.posY + 4), (float)0.0f);
            int mx = mouseX - this.posX - 4;
            int my = mouseY - this.posY - 4;
            GlStateManager.func_179140_f();
            for (ElementBase element : this.elements) {
                element.drawBackground(mx, my, this.ticks);
            }
            for (ElementBase element : this.elements) {
                element.drawForeground(mx, my);
            }
            GlStateManager.func_179121_F();
        }

        public void addTooltip(List<String> list) {
            int mx = this.gui.getMouseX() - this.posX - 4;
            int my = this.gui.getMouseY() - this.posY - 4;
            for (ElementBase element : this.elements) {
                if (!element.intersectsWith(mx, my)) continue;
                element.addTooltip(list);
            }
        }

        public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) throws IOException {
            int mx = mouseX - this.posX - 4;
            int my = mouseY - this.posY - 4;
            for (ElementBase element : this.elements) {
                if (!element.intersectsWith(mx, my)) continue;
                element.onMousePressed(mx, my, mouseButton);
            }
            return true;
        }

        public void onMouseReleased(int mouseX, int mouseY) {
            int mx = mouseX - this.posX - 4;
            int my = mouseY - this.posY - 4;
            for (ElementBase element : this.elements) {
                element.onMouseReleased(mx, my);
            }
        }

        public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
            int mx = mouseX - this.posX - 4;
            int my = mouseY - this.posY - 4;
            for (ElementBase element : this.elements) {
                if (!element.intersectsWith(mx, my)) continue;
                element.onMouseWheel(mx, my, movement);
            }
            return true;
        }

        public boolean onKeyTyped(char characterTyped, int keyPressed) {
            return this.elements.stream().anyMatch(e -> e.onKeyTyped(characterTyped, keyPressed));
        }
    }
}

