/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui;

import astavie.thermallogistics.client.gui.GuiTerminal;
import astavie.thermallogistics.client.gui.element.ElementSlotItem;
import astavie.thermallogistics.client.gui.tab.TabCrafting;
import astavie.thermallogistics.container.ContainerTerminalItem;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.tile.TileTerminalItem;
import astavie.thermallogistics.util.Shared;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.type.Type;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementTextField;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.StringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class GuiTerminalItem
extends GuiTerminal<ItemStack> {
    public final TileTerminalItem tile;
    public TabCrafting tabCrafting;
    private Pair<ItemList, List<String>> cache = Pair.of(null, null);
    private ElementButton dump2;

    public GuiTerminalItem(TileTerminalItem tile, InventoryPlayer inventory) {
        super(tile, (Container)new ContainerTerminalItem(tile, inventory), new ResourceLocation("thermallogistics", "textures/gui/terminal.png"));
        ((ContainerTerminalItem)this.field_147002_h).gui = this;
        this.tile = tile;
        this.field_146999_f = 194;
        this.field_147000_g = 238;
        this.size = 238;
    }

    @Override
    public Object getStackAt(int mouseX, int mouseY) {
        Object o = super.getStackAt(mouseX, mouseY);
        if (o == null && this.tabCrafting.isFullyOpened()) {
            return this.tabCrafting.getStackAt(mouseX, mouseY);
        }
        return o;
    }

    @Override
    public void addTooltips(List<String> tooltip) {
        List list;
        super.addTooltips(tooltip);
        if (this.tabCrafting.button.intersectsWith(this.mouseX - this.tabCrafting.posX(), this.mouseY - this.tabCrafting.getPosY()) && (list = (List)this.cache.getRight()) != null) {
            tooltip.addAll(list);
        }
    }

    private Pair<ItemList, List<String>> request() {
        if (Arrays.stream(this.tile.shared).allMatch(shared -> shared.test(ItemStack.field_190927_a))) {
            return Pair.of(null, null);
        }
        ItemList copy = new ItemList();
        for (Request request : this.tile.requests) {
            if (request.isError()) continue;
            copy.add(request.type, request.amount);
        }
        for (ItemStack stack : this.tile.inventory.items) {
            if (stack.func_190926_b()) continue;
            copy.add(stack);
        }
        for (ItemStack stack : this.field_146297_k.field_71439_g.field_71071_by.field_70462_a) {
            if (stack.func_190926_b()) continue;
            copy.add(stack);
        }
        copy.add(this.field_147012_x.func_190926_b() ? this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() : this.field_147012_x);
        copy.addAll(this.tile.terminal);
        int count = 1;
        if (!this.tabCrafting.amount.getText().isEmpty()) {
            count = Integer.parseInt(this.tabCrafting.amount.getText());
        }
        ItemList request = new ItemList();
        ItemList missing = new ItemList();
        if (count > 0) {
            block3: for (Shared.Item item : this.tile.shared) {
                if (item.test(ItemStack.field_190927_a)) continue;
                int amount = count;
                for (Type<ItemStack> type : copy.types()) {
                    boolean craftable = copy.craftable(type);
                    long size = copy.amount(type);
                    if (!craftable && size == 0L || !item.test(type)) continue;
                    if (craftable) {
                        request.add(type.withAmount(count));
                        continue block3;
                    }
                    int shrink = (int)Math.min(size, (long)amount);
                    ItemStack stack = type.withAmount(shrink);
                    request.add(stack);
                    copy.remove(stack);
                    if ((amount -= shrink) != 0) continue;
                    continue block3;
                }
                missing.add(ItemHelper.cloneStack((ItemStack)item.getDisplayStack(), (int)amount));
            }
        }
        if (missing.isEmpty()) {
            for (Request r : this.tile.requests) {
                if (r.isError()) continue;
                request.remove(r.type, r.amount);
            }
            for (ItemStack stack : this.tile.inventory.items) {
                request.remove(stack);
            }
            for (ItemStack stack : Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70462_a) {
                request.remove(stack);
            }
            request.remove(this.field_147012_x.func_190926_b() ? this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() : this.field_147012_x);
            if (request.isEmpty()) {
                return Pair.of(null, Collections.singletonList(StringHelper.localize((String)"gui.logistics.terminal.enough")));
            }
            return Pair.of((Object)request, null);
        }
        LinkedList<String> tooltip = new LinkedList<String>();
        tooltip.add(StringHelper.localize((String)"gui.logistics.terminal.missing"));
        for (Type type : missing.types()) {
            tooltip.add(StringHelper.localizeFormat((String)"info.logistics.manager.e.1", (Object[])new Object[]{missing.amount(type), type.getDisplayName()}));
        }
        return Pair.of(null, tooltip);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147003_i += 9;
        ElementButton dump = new ElementButton((GuiContainerCore)this, 153, 141, "dump", 194, 0, 194, 14, 14, 14, this.texture.toString());
        dump.setToolTip("info.logistics.terminal.dump.inventory");
        this.dump2 = new ElementButton((GuiContainerCore)this, 153, 73, "dump2", 208, 0, 208, 14, 14, 14, this.texture.toString());
        this.dump2.setToolTip("info.logistics.terminal.dump.network");
        this.addElement((ElementBase)dump);
        this.addElement((ElementBase)this.dump2);
        this.tabCrafting = new TabCrafting(this, this.tile.shared, () -> {
            PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
            packet.addByte(2);
            packet.addBool(StringHelper.isShiftKeyDown());
            for (Shared.Item stacks : this.tile.shared) {
                Ingredient ingredient = stacks.asIngredient();
                packet.addInt(ingredient.func_193365_a().length);
                for (ItemStack item : ingredient.func_193365_a()) {
                    packet.addItemStack(item);
                }
            }
            PacketHandler.sendToServer((PacketBase)packet);
        }, () -> {
            if (this.cache.getLeft() != null) {
                for (Type type : ((ItemList)this.cache.getLeft()).types()) {
                    this.request(type, ((ItemList)this.cache.getLeft()).amount(type));
                }
            }
        }, () -> this.cache.getLeft() != null);
        this.addTab(this.tabCrafting);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(StringHelper.localize((String)"gui.logistics.terminal.buffer"), 8, this.field_147000_g - 96 - 68 + 3, 0x404040);
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (mouseButton == 0) {
            if (buttonName.equals("dump")) {
                GuiTerminalItem.playClickSound((float)1.0f);
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(4);
                PacketHandler.sendToServer((PacketBase)packet);
            } else if (buttonName.equals("dump2")) {
                GuiTerminalItem.playClickSound((float)1.0f);
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(5);
                PacketHandler.sendToServer((PacketBase)packet);
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.dump2.setVisible(this.requester().func_75216_d());
        this.cache = this.request();
        boolean visible = this.requester().func_75216_d();
        this.tabCrafting.setVisible(visible);
    }

    @Override
    protected int getTabOffsetX() {
        return -18;
    }

    @Override
    protected int getTabOffsetY() {
        return 56;
    }

    @Override
    protected void func_73864_a(int mX, int mY, int mouseButton) throws IOException {
        if (this.requester().func_75216_d() && !Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            int mouseX = mX - this.field_147003_i - 7;
            int mouseY = mY - this.field_147009_r - 17;
            if (mouseX >= 0 && mouseX < 162 && mouseY >= 0 && mouseY < this.rows * 18) {
                PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this.tile);
                packet.addByte(3);
                PacketHandler.sendToServer((PacketBase)packet);
                return;
            }
        }
        super.func_73864_a(mX, mY, mouseButton);
    }

    protected void func_146273_a(int mX, int mY, int lastClick, long timeSinceClick) {
        if (lastClick == 0 && this.requester().func_75216_d() && Arrays.stream(this.tabCrafting.grid).anyMatch(slot -> slot.intersectsWith(mX - this.field_147003_i - this.tabCrafting.posX(), mY - this.field_147009_r - this.tabCrafting.getPosY()))) {
            try {
                this.func_73864_a(mX, mY, lastClick);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            super.func_146273_a(mX, mY, lastClick, timeSinceClick);
        }
    }

    protected boolean func_193983_c(int x, int y, int left, int top) {
        boolean yes = super.func_193983_c(x, y, left, top);
        if (yes) {
            for (ElementSlotItem element : this.tabCrafting.grid) {
                if (!element.intersectsWith(x - left - this.tabCrafting.posX(), y - top - this.tabCrafting.getPosY())) continue;
                return false;
            }
            if (this.tabCrafting.output.intersectsWith(x - left - this.tabCrafting.posX(), y - top - this.tabCrafting.getPosY())) {
                return false;
            }
        }
        return yes;
    }

    @Override
    protected void func_73869_a(char characterTyped, int keyPressed) throws IOException {
        if (this.tabCrafting != null && this.tabCrafting.isFullyOpened() && this.tabCrafting.onKeyTyped(characterTyped, keyPressed)) {
            return;
        }
        super.func_73869_a(characterTyped, keyPressed);
    }

    @Override
    protected void updateFilter() {
        this.filter.clear();
        block0: for (Type type : this.tile.terminal.types()) {
            if (((ElementTextField)this.search.get()).getText().isEmpty() || type.getDisplayName().toLowerCase().contains(((ElementTextField)this.search.get()).getText().toLowerCase())) {
                this.filter.add(Triple.of(type, (Object)this.tile.terminal.amount(type), (Object)this.tile.terminal.craftable(type)));
                continue;
            }
            for (String string : this.func_191927_a((ItemStack)type.getAsStack())) {
                if (!string.toLowerCase().contains(((ElementTextField)this.search.get()).getText().toLowerCase())) continue;
                this.filter.add(Triple.of(type, (Object)this.tile.terminal.amount(type), (Object)this.tile.terminal.craftable(type)));
                continue block0;
            }
        }
        this.filter.sort((i1, i2) -> {
            int count = -Long.compare((Long)i1.getMiddle(), (Long)i2.getMiddle());
            if (count != 0) {
                return count;
            }
            int id = Integer.compare(Item.func_150891_b((Item)((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77973_b()), Item.func_150891_b((Item)((ItemStack)((Type)i2.getLeft()).getAsStack()).func_77973_b()));
            if (id != 0) {
                return id;
            }
            int damage = Integer.compare(((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77952_i(), ((ItemStack)((Type)i2.getLeft()).getAsStack()).func_77952_i());
            if (damage != 0) {
                return damage;
            }
            CreativeTabs tab = ((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77973_b().func_77640_w();
            if (tab == null) {
                tab = CreativeTabs.field_78027_g;
            }
            NonNullList list = NonNullList.func_191196_a();
            ((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77973_b().func_150895_a(tab, list);
            for (ItemStack stack : list) {
                if (ItemHelper.itemsIdentical((ItemStack)((ItemStack)((Type)i1.getLeft()).getAsStack()), (ItemStack)stack)) {
                    return -1;
                }
                if (!ItemHelper.itemsIdentical((ItemStack)((ItemStack)((Type)i2.getLeft()).getAsStack()), (ItemStack)stack)) continue;
                return 1;
            }
            if (((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77978_p() == null && ((ItemStack)((Type)i2.getLeft()).getAsStack()).func_77978_p() != null) {
                return -1;
            }
            if (((ItemStack)((Type)i1.getLeft()).getAsStack()).func_77978_p() != null && ((ItemStack)((Type)i2.getLeft()).getAsStack()).func_77978_p() == null) {
                return 1;
            }
            return 0;
        });
    }

    @Override
    protected int getOverlaySheetX() {
        return 194;
    }

    @Override
    protected int getOverlaySheetY() {
        return 28;
    }
}

