/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.element;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.Recipe;
import astavie.thermallogistics.client.gui.GuiCrafter;
import astavie.thermallogistics.client.gui.GuiOverlay;
import astavie.thermallogistics.client.gui.element.ElementButtonCancelLink;
import astavie.thermallogistics.client.gui.element.ElementStack;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.type.ItemType;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementButton;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.core.util.helpers.StringHelper;
import cofh.thermaldynamics.duct.attachments.ConnectionBase;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ElementButtonLinks
extends ElementButton {
    private final GuiCrafter crafter;
    private final int index;
    private final Overlay overlay;

    public ElementButtonLinks(GuiCrafter gui, int posX, int posY, int index) {
        super((GuiContainerCore)gui, posX, posY, 16, 16, 116, 0, 116, 16, 116, 32, "thermallogistics:textures/gui/icons/crafter.png");
        ItemStack stack;
        this.crafter = gui;
        this.index = index;
        ItemStack itemStack = stack = gui.field_147012_x.func_190926_b() ? Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() : gui.field_147012_x;
        if (stack.func_77973_b() == ThermalLogistics.Items.manager) {
            this.setEnabled(true);
            this.overlay = null;
        } else {
            Recipe recipe = (Recipe)this.crafter.crafter.getCrafters().get(index);
            this.setEnabled(!recipe.linked.isEmpty());
            this.overlay = this.isEnabled() ? new Overlay(gui, index) : null;
        }
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        super.drawBackground(mouseX, mouseY, gameTicks);
        if (this.isEnabled() && this.crafter.overlay == null) {
            ItemStack stack;
            ItemStack itemStack = stack = this.gui.field_147012_x.func_190926_b() ? Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() : this.gui.field_147012_x;
            if (stack.func_77973_b() == ThermalLogistics.Items.manager) {
                return;
            }
            if (this.intersectsWith(mouseX, mouseY)) {
                this.overlay.setPos(mouseX + 4, mouseY + 4);
                this.overlay.drawBackground(mouseX, mouseY, gameTicks);
            }
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        if (this.isEnabled() && this.crafter.overlay == null) {
            ItemStack stack;
            ItemStack itemStack = stack = this.gui.field_147012_x.func_190926_b() ? Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() : this.gui.field_147012_x;
            if (stack.func_77973_b() == ThermalLogistics.Items.manager) {
                return;
            }
            if (this.intersectsWith(mouseX, mouseY)) {
                this.overlay.drawForeground(mouseX, mouseY);
            }
        }
    }

    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this.playSound(mouseButton);
        switch (mouseButton) {
            case 0: {
                ItemStack stack;
                ItemStack itemStack = stack = this.gui.field_147012_x.func_190926_b() ? Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o() : this.gui.field_147012_x;
                if (stack.func_77973_b() == ThermalLogistics.Items.manager) {
                    PacketTileInfo packet = ((ConnectionBase)this.crafter.crafter).getNewPacket((byte)0);
                    packet.addByte(5);
                    packet.addInt(this.index);
                    PacketHandler.sendToServer((PacketBase)packet);
                    break;
                }
                this.overlay.setPos(mouseX + 4, mouseY + 4);
                this.crafter.setOverlay(this.overlay);
                break;
            }
            case 1: {
                this.onRightClick();
                break;
            }
            case 2: {
                this.onMiddleClick();
            }
        }
        return true;
    }

    public void addTooltip(List<String> list) {
        if (!this.isEnabled()) {
            list.add(StringHelper.localize((String)"info.logistics.unlinked.0"));
            list.add(StringHelper.localize((String)"info.logistics.unlinked.1"));
        }
    }

    public static class Overlay
    extends GuiOverlay.Overlay {
        private GuiCrafter crafter;
        private int index;

        public Overlay(GuiCrafter gui, int index) {
            super(gui, 0, 0, 0, 0);
            this.crafter = gui;
            this.index = index;
            this.update();
        }

        public void update() {
            Recipe recipe = (Recipe)this.crafter.crafter.getCrafters().get(this.index);
            if (recipe.linked.isEmpty()) {
                this.crafter.setOverlay(null);
                return;
            }
            this.setDimensions(54, recipe.linked.size() * 18);
            this.elements.clear();
            for (int i = 0; i < recipe.linked.size(); ++i) {
                RequesterReference<?> reference = recipe.linked.get(i);
                this.elements.add(new ElementButtonCancelLink(this.crafter, 0, i * 18, this.index, i));
                this.elements.add(new ElementStack(this.crafter, 18, i * 18, new ItemType(reference.getTileIcon()), true));
                this.elements.add(new ElementStack(this.crafter, 36, i * 18, new ItemType(reference.getIcon()), true));
            }
        }
    }
}

