/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.tab;

import astavie.thermallogistics.client.TLTextures;
import astavie.thermallogistics.client.gui.IFluidGui;
import astavie.thermallogistics.client.gui.element.ElementSlotFluid;
import astavie.thermallogistics.client.gui.element.ElementTextFieldAmount;
import astavie.thermallogistics.util.Shared;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButtonManaged;
import cofh.core.gui.element.ElementTextField;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;

public class TabFluid
extends TabBase {
    public final ElementSlotFluid slot;
    private final Shared<FluidStack> shared = new Shared();
    private final IFluidGui fluid;
    private final ElementTextField text;

    public TabFluid(GuiContainerCore gui, IFluidGui fluid) {
        this(gui, 1, fluid);
    }

    public TabFluid(GuiContainerCore gui, int side, IFluidGui fluid) {
        super(gui, side);
        this.fluid = fluid;
        this.backgroundColor = 3432410;
        this.maxHeight = 64;
        this.maxWidth = 72;
        this.text = new ElementTextFieldAmount(gui, this.sideOffset() + 26, 25, 33, 10, false);
        this.slot = new ElementSlotFluid(gui, this.sideOffset() + 4, 21, this.shared, this.shared, false);
        this.addElement((ElementBase)this.text);
        this.addElement(this.slot);
        this.addElement((ElementBase)new ElementButtonManaged(gui, this.sideOffset() + 4, 41, 57, 16, StringHelper.localize((String)"info.logistics.fluid.get")){

            public void onClick() {
                if (TabFluid.this.shared.get() == null) {
                    return;
                }
                FluidStack fluid = ((FluidStack)TabFluid.this.shared.get()).copy();
                fluid.amount = 1000;
                if (!TabFluid.this.text.getText().isEmpty()) {
                    fluid.amount = Integer.parseInt(TabFluid.this.text.getText());
                    if (fluid.amount == 0) {
                        return;
                    }
                }
                TabFluid.this.fluid.setFluid(fluid);
            }
        });
    }

    public int posX() {
        return super.posX();
    }

    protected void drawForeground() {
        GlStateManager.func_179140_f();
        this.drawTabIcon(TLTextures.ICON_FLUID);
        if (!this.isFullyOpened()) {
            return;
        }
        this.getFontRenderer().func_175063_a(this.getTitle(), (float)(this.sideOffset() + 18), 6.0f, this.headerColor);
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
        } else if (this.slot.intersectsWith(this.gui.getMouseX() - this.posX(), this.gui.getMouseY() - this.posY)) {
            this.slot.addTooltip(list);
        }
    }

    private String getTitle() {
        return StringHelper.localize((String)"info.logistics.tab.fluid");
    }
}

