/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.client.gui.tab;

import astavie.thermallogistics.attachment.IAttachmentCrafter;
import astavie.thermallogistics.attachment.Recipe;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

public class TabStackList<I>
extends TabBase {
    private static final int STACK_HEIGHT = 18;
    private static final int STACKS_PER_LINE = 4;
    private final IAttachmentCrafter<I> crafter;
    private final boolean input;
    private final Map<RequesterReference<I>, StackList<I>> map = new LinkedHashMap<RequesterReference<I>, StackList<I>>();
    private final StackList<I> network;
    private final int lines;
    private int currentLine = 0;
    private int totalLines;

    public TabStackList(GuiContainerCore gui, IAttachmentCrafter<I> crafter, boolean input) {
        super(gui, 0);
        this.crafter = crafter;
        this.input = input;
        this.network = crafter.getSupplier().get();
        this.maxHeight = 96;
        this.maxWidth += 2;
        this.lines = (this.maxHeight - 24) / 18;
        this.refresh();
    }

    public void update() {
        super.update();
        if (this.isFullyOpened()) {
            this.refresh();
        }
    }

    private void refresh() {
        this.network.clear();
        this.map.clear();
        for (Recipe<I> recipe : this.crafter.getRecipes()) {
            for (Map.Entry entry : (this.input ? recipe.requestInput : recipe.requestOutput).entrySet()) {
                if (entry.getKey() == null) {
                    this.network.addAll(entry.getValue());
                    continue;
                }
                if (!this.map.containsKey(entry.getKey())) {
                    this.map.put(entry.getKey(), entry.getValue().copy());
                    continue;
                }
                this.map.get(entry.getKey()).addAll(entry.getValue());
            }
            this.network.addAll(this.input ? recipe.missing : recipe.leftovers);
        }
        this.totalLines = 0;
        for (StackList stackList : this.map.values()) {
            this.totalLines += (stackList.size() - 1) / 4 + 1;
        }
        if (!this.network.isEmpty()) {
            this.totalLines += (this.network.size() - 1) / 4 + 1;
        }
        if (this.totalLines < this.lines) {
            this.totalLines = this.lines;
        }
    }

    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.getTitle());
            return;
        }
        int mouseX = this.gui.getMouseX() - this.posX();
        int mouseY = this.gui.getMouseY() - this.posY;
        int i = 0;
        for (Map.Entry<RequesterReference<I>, StackList<I>> entry : this.map.entrySet()) {
            if (i >= this.currentLine && i < this.currentLine + this.lines) {
                int x = this.sideOffset() + 2;
                int y = 21 + (i - this.currentLine) * 18;
                if (!entry.getKey().getTileIcon().func_190926_b() && mouseX >= x - 1 && mouseX < x + 17 && mouseY >= y - 1 && mouseY < y + 17) {
                    list.addAll(this.gui.func_191927_a(entry.getKey().getTileIcon()));
                }
                if (!entry.getKey().getIcon().func_190926_b() && mouseX >= x + 17 && mouseX < x + 35 && mouseY >= y - 1 && mouseY < y + 17) {
                    list.addAll(this.gui.func_191927_a(entry.getKey().getIcon()));
                }
            }
            if ((i = this.addTooltip(entry.getValue(), i, list, mouseX, mouseY)) < this.currentLine + this.lines) continue;
            return;
        }
        if (!this.network.isEmpty() && (i = this.addTooltip(this.network, i, list, mouseX, mouseY)) >= this.currentLine + this.lines) {
            return;
        }
    }

    private int addTooltip(StackList<I> value, int i, List<String> list, int mouseX, int mouseY) {
        Iterator<Type<I>> iterator = value.getTypeIterator();
        while (iterator.hasNext()) {
            for (int j = 0; j < 4; ++j) {
                Type<I> type = iterator.next();
                if (i >= this.currentLine && i < this.currentLine + this.lines) {
                    int x = this.sideOffset() + 2 + 38 + 18 * j;
                    int y = 21 + (i - this.currentLine) * 18;
                    if (mouseX >= x - 1 && mouseX < x + 17 && mouseY >= y - 1 && mouseY < y + 17) {
                        list.addAll(type.getTooltip(this.gui));
                    }
                }
                if (!iterator.hasNext()) break;
            }
            if (++i < this.currentLine + this.lines) continue;
            return i;
        }
        return i;
    }

    public void drawForeground() {
        GlStateManager.func_179140_f();
        this.drawTabIcon(this.input ? CoreTextures.ICON_INPUT : CoreTextures.ICON_OUTPUT);
        if (!this.isFullyOpened()) {
            return;
        }
        if (this.currentLine > 0) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP, this.sideOffset() + this.maxWidth - 20, 16);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_UP_INACTIVE, this.sideOffset() + this.maxWidth - 20, 16);
        }
        if (this.currentLine < this.totalLines - this.lines) {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN, this.sideOffset() + this.maxWidth - 20, 76);
        } else {
            this.gui.drawIcon(CoreTextures.ICON_ARROW_DOWN_INACTIVE, this.sideOffset() + this.maxWidth - 20, 76);
        }
        this.getFontRenderer().func_78276_b(this.getTitle(), this.sideOffset() + 18, 6, -13158601);
        RenderHelper.func_74518_a();
        RenderHelper.func_74520_c();
        int x = this.sideOffset() + 2;
        int y = 21;
        Gui.func_73734_a((int)(x + 37 - 1), (int)(y - 1), (int)(x + 37), (int)(y + this.lines * 18 - 1), (int)-13158601);
        int i = 0;
        for (Map.Entry<RequesterReference<I>, StackList<I>> entry : this.map.entrySet()) {
            if (i >= this.currentLine && i < this.currentLine + this.lines) {
                int x2 = this.sideOffset() + 2;
                int y2 = 21 + (i - this.currentLine) * 18;
                if (i > this.currentLine) {
                    Gui.func_73734_a((int)(x2 - 1), (int)(y2 - 1), (int)(this.sideOffset() + this.maxWidth - 20), (int)y2, (int)-13158601);
                }
                if (!entry.getKey().getTileIcon().func_190926_b()) {
                    this.gui.drawItemStack(entry.getKey().getTileIcon(), x2, y2, false, null);
                }
                if (!entry.getKey().getIcon().func_190926_b()) {
                    this.gui.drawItemStack(entry.getKey().getIcon(), x2 + 18, y2, false, null);
                }
            }
            if ((i = this.render(entry.getValue(), i)) < this.currentLine + this.lines) continue;
            return;
        }
        if (!this.network.isEmpty()) {
            if (i >= this.currentLine && i < this.currentLine + this.lines) {
                int x3 = this.sideOffset() + 2;
                int y3 = 21 + (i - this.currentLine) * 18;
                if (i > this.currentLine) {
                    Gui.func_73734_a((int)(x3 - 1), (int)(y3 - 1), (int)(this.sideOffset() + this.maxWidth - 20), (int)y3, (int)-13158601);
                }
            }
            if ((i = this.render(this.network, i)) >= this.currentLine + this.lines) {
                return;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int render(StackList<I> list, int i) {
        Iterator<Type<I>> iterator = list.getTypeIterator();
        while (iterator.hasNext()) {
            for (int j = 0; j < 4; ++j) {
                Type<I> type = iterator.next();
                if (i >= this.currentLine && i < this.currentLine + this.lines) {
                    int x = this.sideOffset() + 2 + 38 + 18 * j;
                    int y = 21 + (i - this.currentLine) * 18;
                    StackHandler.render(this.gui, x, y, type.getAsStack(), StackHandler.getScaledNumber(list.amount((I)type)));
                }
                if (!iterator.hasNext()) break;
            }
            if (++i < this.currentLine + this.lines) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return i;
        }
        return i;
    }

    public boolean onMouseWheel(int mouseX, int mouseY, int movement) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if (movement > 0) {
            this.currentLine = MathHelper.clamp((int)(this.currentLine - 1), (int)0, (int)(this.totalLines - this.lines));
            return true;
        }
        if (movement < 0) {
            this.currentLine = MathHelper.clamp((int)(this.currentLine + 1), (int)0, (int)(this.totalLines - this.lines));
            return true;
        }
        return false;
    }

    private String getTitle() {
        return StringHelper.localize((String)("info.logistics.tab." + (this.input ? "input" : "output")));
    }
}

