/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.process.IProcessRequester;
import astavie.thermallogistics.process.Proposal;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.Shared;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.collection.MissingList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public abstract class Process<I> {
    protected final IProcessRequester<I> requester;

    public Process(IProcessRequester<I> requester) {
        this.requester = requester;
    }

    public boolean update(boolean onlyCheck) {
        Map<RequesterReference<I>, StackList<I>> requests = this.requester.getRequests();
        for (RequesterReference<I> source : requests.keySet()) {
            if (source == null) {
                if (onlyCheck || !this.updateRetrieval(requests.get(null))) continue;
                return true;
            }
            StackList<I> list = requests.get(source);
            IRequester<I> r = source.get();
            if (!(r instanceof ICrafter)) {
                for (Type<I> type : list.types()) {
                    this.requester.onFail(source, type, list.amount((I)type));
                }
                return true;
            }
            ICrafter crafter = (ICrafter)r;
            if (!crafter.isEnabled() || !crafter.hasRouteTo(this.requester)) {
                for (Type<I> type : list.types()) {
                    this.requester.onFail(source, type, list.amount((I)type));
                }
                return true;
            }
            boolean b = false;
            for (Type<I> type : list.types()) {
                long remove = list.amount((I)type) - crafter.reserved(this.requester, type);
                if (remove <= 0L) continue;
                this.requester.onFail(source, type, remove);
                b = true;
            }
            if (b) {
                return true;
            }
            if (onlyCheck || !this.attemptPull(crafter, list)) continue;
            return true;
        }
        return !onlyCheck && this.requester.hasWants() && this.updateWants();
    }

    protected abstract boolean updateRetrieval(StackList<I> var1);

    protected abstract boolean updateWants();

    protected abstract boolean attemptPull(ICrafter<I> var1, StackList<I> var2);

    public List<Request<I>> request(Type<I> type, long amount, @Nullable Function<Type<I>, Long> func) {
        LinkedList<Request<I>> requests = new LinkedList<Request<I>>();
        StackList stacks = Snapshot.INSTANCE.getStacks(this.requester.getDuct().getGrid());
        long am = func == null ? stacks.amount(type) : func.apply(type).longValue();
        long removed = Math.min(am, amount);
        if (removed > 0L) {
            stacks.remove(type, removed);
            amount -= removed;
            requests.add(new Request<I>(type, removed, new Source(this.requester.getSide()), 0));
        }
        if (amount > 0L) {
            Shared<Long> shared = new Shared<Long>(amount);
            this.requestFromCrafters(requests, type, shared, true, true, false, false, false);
            amount = shared.get();
        }
        if (amount > 0L) {
            MissingList list = new MissingList();
            list.add(type, amount);
            requests.add(new Request<I>(type, amount, 0, list, false));
        }
        return requests;
    }

    public long request(Type<I> type, long amount, List<Request<I>> requests, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        long requested = 0L;
        StackList stacks = Snapshot.INSTANCE.getStacks(this.requester.getDuct().getGrid());
        long am = stacks.amount(type);
        long removed = Math.min(am, amount);
        if (removed > 0L) {
            stacks.remove(type, removed);
            amount -= removed;
            requests.add(new Request<I>(type, removed, new Source(this.requester.getSide()), 0));
            requested += removed;
        }
        if (amount > 0L) {
            Shared<Long> shared = new Shared<Long>(amount);
            this.requestFromCrafters(requests, type, shared, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt, true);
            requested += amount - shared.get();
        }
        return requested;
    }

    public abstract void findCrafter(Predicate<ICrafter<I>> var1, boolean var2);

    public ICrafter<I> getCrafter(Type<I> output) {
        Shared shared = new Shared();
        this.findCrafter(crafter -> {
            if (crafter.getOutputs().types().contains(output)) {
                shared.accept(crafter);
                return true;
            }
            return false;
        }, true);
        return (ICrafter)shared.get();
    }

    public Pair<ICrafter<I>, Type<I>> getCrafter(Type<I> output, Set<ICrafter<?>> used, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        Shared shared = new Shared();
        this.findCrafter(crafter -> {
            if (used.contains(crafter)) {
                return false;
            }
            for (Type type : crafter.getOutputs().types()) {
                if (!type.isIdentical(output, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) continue;
                shared.accept(Pair.of((Object)crafter, type));
                return true;
            }
            return false;
        }, true);
        return (Pair)shared.get();
    }

    public Triple<ICrafter<I>, Type<I>, Long> getCrafter(Set<ICrafter<?>> used, Function<Type<I>, Long> amountRequired) {
        Shared shared = new Shared();
        this.findCrafter(crafter -> {
            if (used.contains(crafter)) {
                return false;
            }
            for (Type type : crafter.getOutputs().types()) {
                long a = (Long)amountRequired.apply(type);
                if (a <= 0L) continue;
                shared.accept(Triple.of((Object)crafter, type, (Object)a));
                return true;
            }
            return false;
        }, true);
        return (Triple)shared.get();
    }

    public Pair<ICrafter<I>, Type<I>> getCrafterWithLeftovers(Type<I> output, Set<ICrafter<?>> used, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt) {
        Shared shared = new Shared();
        this.findCrafter(crafter -> {
            if (used.contains(crafter)) {
                return false;
            }
            for (Type type : Snapshot.INSTANCE.getLeftovers(crafter.createReference()).types()) {
                if (!type.isIdentical(output, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) continue;
                shared.accept(Pair.of((Object)crafter, type));
                return true;
            }
            return false;
        }, false);
        return (Pair)shared.get();
    }

    public Triple<ICrafter<I>, Type<I>, Long> getCrafterWithLeftovers(Set<ICrafter<?>> used, Function<Type<I>, Long> amountRequired) {
        Shared shared = new Shared();
        this.findCrafter(crafter -> {
            if (used.contains(crafter)) {
                return false;
            }
            for (Type type : Snapshot.INSTANCE.getLeftovers(crafter.createReference()).types()) {
                long a = (Long)amountRequired.apply(type);
                if (a <= 0L) continue;
                shared.accept(Triple.of((Object)crafter, type, (Object)a));
                return true;
            }
            return false;
        }, false);
        return (Triple)shared.get();
    }

    private void requestFromCrafters(List<Request<I>> requests, Type<I> type, Shared<Long> amount, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt, boolean applyMissing) {
        MissingList missing = new MissingList();
        Proposal proposal = new Proposal(null, null, 0L);
        long a = amount.get();
        if (!this.requestFirst(missing, proposal, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt, type, a, applyMissing)) {
            missing = null;
        }
        for (Proposal prop : proposal.children) {
            requests.add(new Request(prop.type, prop.amount, new Source(this.requester.getSide(), prop.me), 0));
            a -= prop.amount;
        }
        if (!applyMissing) {
            if (missing == null) {
                requests.add(new Request<I>(type, a, 0, null, true));
            } else if (!missing.isEmpty()) {
                requests.add(new Request<I>(type, a, 0, missing, false));
            }
            amount.accept(0L);
        } else {
            amount.accept(a);
        }
    }

    public boolean requestInternal(MissingList missing, Proposal<I> proposal, Set<ICrafter<?>> used, long timeStarted, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt, Type<I> subType, long subAmount) {
        ICrafter crafter;
        Pair<ICrafter<I>, Type<I>> pair;
        StackList network = Snapshot.INSTANCE.getMutatedStacks(this.requester.getDuct().getGrid());
        for (Type<I> compare : network.types()) {
            long remaining;
            if (!compare.isIdentical(subType, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt) || (remaining = network.remove(compare, subAmount)) >= subAmount) continue;
            proposal.children.add(new Proposal(null, compare, subAmount - remaining));
            subAmount = remaining;
            if (subAmount != 0L) continue;
            return true;
        }
        if (subAmount > 0L && (pair = this.getCrafterWithLeftovers(subType, used, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) != null) {
            crafter = (ICrafter)pair.getLeft();
            Type compare = (Type)pair.getRight();
            StackList leftovers = Snapshot.INSTANCE.getLeftovers(crafter.createReference());
            long remain = leftovers.remove(compare, subAmount);
            if (remain < subAmount) {
                proposal.children.add(new Proposal(crafter.createReference(), compare, subAmount - remain));
                subAmount = remain;
                if (subAmount == 0L) {
                    return true;
                }
            }
        }
        if (subAmount > 0L) {
            pair = this.getCrafter(subType, used, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt);
            if (pair != null) {
                crafter = (ICrafter)pair.getLeft();
                Type compare = (Type)pair.getRight();
                long qtyPerCraft = crafter.amountCrafted(compare);
                while (subAmount > 0L) {
                    Proposal subProposal;
                    long remove = Math.min(subAmount, qtyPerCraft);
                    if (!crafter.requestInternal(compare, remove, missing, subProposal = new Proposal(crafter.createReference(), compare, remove), used, timeStarted, true)) {
                        return false;
                    }
                    proposal.children.add(subProposal);
                    subAmount -= remove;
                }
            } else {
                proposal.children.add(new Proposal<I>(null, subType, subAmount, true));
                missing.add(subType, subAmount);
            }
        }
        return true;
    }

    private boolean requestFirst(MissingList missing, Proposal<I> proposal, boolean ignoreMod, boolean ignoreOreDict, boolean ignoreMetadata, boolean ignoreNbt, Type<I> subType, long subAmount, boolean applyMissing) {
        Type compare;
        ICrafter crafter;
        Pair<ICrafter<I>, Type<I>> pair;
        HashSet used = new HashSet();
        Snapshot.INSTANCE.clearMutated();
        if (subAmount > 0L && (pair = this.getCrafterWithLeftovers(subType, used, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt)) != null) {
            crafter = (ICrafter)pair.getLeft();
            compare = (Type)pair.getRight();
            StackList leftovers = Snapshot.INSTANCE.getLeftovers(crafter.createReference());
            long remain = leftovers.remove(compare, subAmount);
            if (remain < subAmount) {
                Proposal subProposal = new Proposal(crafter.createReference(), compare, subAmount - remain);
                proposal.children.add(subProposal);
                subAmount = remain;
                Snapshot.INSTANCE.applyMutated();
                crafter.applyProposal(this.requester, subProposal);
                if (subAmount == 0L) {
                    return true;
                }
            }
        }
        if (subAmount > 0L) {
            pair = this.getCrafter(subType, used, ignoreMod, ignoreOreDict, ignoreMetadata, ignoreNbt);
            if (pair != null) {
                crafter = (ICrafter)pair.getLeft();
                compare = (Type)pair.getRight();
                long qtyPerCraft = crafter.amountCrafted(compare);
                while (subAmount > 0L) {
                    Proposal subProposal;
                    long remove = Math.min(subAmount, qtyPerCraft);
                    if (!crafter.requestInternal(compare, remove, missing, subProposal = new Proposal(crafter.createReference(), compare, remove), used, System.currentTimeMillis(), true)) {
                        Snapshot.INSTANCE.clearMutated();
                        return false;
                    }
                    subAmount -= remove;
                    if (!applyMissing && !missing.isEmpty()) continue;
                    proposal.children.add(subProposal);
                    Snapshot.INSTANCE.applyMutated();
                    crafter.applyProposal(this.requester, subProposal);
                }
            } else {
                missing.add(subType, subAmount);
            }
        }
        Snapshot.INSTANCE.clearMutated();
        return true;
    }

    protected boolean requestFirstRequester(Proposal<I> proposal, Function<Type<I>, Long> amountRequired, boolean applyMissing) {
        Type compare;
        ICrafter crafter;
        long subAmount;
        MissingList missing = new MissingList();
        HashSet used = new HashSet();
        Snapshot.INSTANCE.clearMutated();
        Triple<ICrafter<I>, Type<I>, Long> pair = this.getCrafterWithLeftovers(used, amountRequired);
        if (pair != null) {
            subAmount = (Long)pair.getRight();
            crafter = (ICrafter)pair.getLeft();
            compare = (Type)pair.getMiddle();
            StackList leftovers = Snapshot.INSTANCE.getLeftovers(crafter.createReference());
            long remain = leftovers.remove(compare, subAmount);
            if (remain < subAmount) {
                Proposal subProposal = new Proposal(crafter.createReference(), compare, subAmount - remain);
                proposal.children.add(subProposal);
                Snapshot.INSTANCE.applyMutated();
                crafter.applyProposal(this.requester, subProposal);
                return true;
            }
        }
        if ((pair = this.getCrafter(used, amountRequired)) != null) {
            long remove;
            crafter = (ICrafter)pair.getLeft();
            compare = (Type)pair.getMiddle();
            long qtyPerCraft = crafter.amountCrafted(compare);
            for (subAmount = ((Long)pair.getRight()).longValue(); subAmount > 0L; subAmount -= remove) {
                Proposal subProposal;
                remove = Math.min(subAmount, qtyPerCraft);
                if (!crafter.requestInternal(compare, remove, missing, subProposal = new Proposal(crafter.createReference(), compare, remove), used, System.currentTimeMillis(), true)) {
                    Snapshot.INSTANCE.clearMutated();
                    return false;
                }
                if (!applyMissing && !missing.isEmpty()) break;
                proposal.children.add(subProposal);
                Snapshot.INSTANCE.applyMutated();
                crafter.applyProposal(this.requester, subProposal);
            }
        }
        Snapshot.INSTANCE.clearMutated();
        return true;
    }
}

