/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.process.IProcessRequesterFluid;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Proposal;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.FluidList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.FluidType;
import astavie.thermallogistics.util.type.Type;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.FluidTankGrid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessFluid
extends Process<FluidStack> {
    public ProcessFluid(IProcessRequesterFluid requester) {
        super(requester);
    }

    private static FluidStack drain(FluidTankGrid tank, int maxPull, IFluidHandler inv, Function<Type<FluidStack>, Long> required, IFluidHandler ownHandler) {
        for (IFluidTankProperties properties : inv.getTankProperties()) {
            int input;
            FluidType type;
            int amount;
            FluidStack item = properties.getContents();
            if (item == null || (amount = (int)Math.min((long)maxPull, required.apply(type = new FluidType(item)))) == 0) continue;
            StackHandler.SIM = true;
            amount = ownHandler.fill(type.withAmount(amount), false);
            StackHandler.SIM = false;
            if (amount == 0 || (item = inv.drain(type.withAmount(amount), false)) == null || (input = tank.fill(item, false)) == 0) continue;
            return type.withAmount(tank.fill(inv.drain(type.withAmount(input), true), true));
        }
        return null;
    }

    private FluidTankGrid getTank() {
        return ((GridFluid)((DuctUnitFluid)this.requester.getDuct()).getGrid()).myTank;
    }

    private int getMaxPull(FluidTankGrid tank) {
        return (int)Math.ceil((float)tank.fluidThroughput * ((IProcessRequesterFluid)this.requester).throttle());
    }

    @Override
    protected boolean updateRetrieval(StackList<FluidStack> requests) {
        DuctUnitFluid.Cache ownCache = ((DuctUnitFluid.Cache[])((DuctUnitFluid)this.requester.getDuct()).tileCache)[this.requester.getSide() ^ 1];
        if (ownCache == null) {
            return false;
        }
        IFluidHandler ownHandler = ownCache.getHandler((int)this.requester.getSide());
        if (ownHandler == null) {
            return false;
        }
        ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
        for (Pair source : sources) {
            IFluidHandler inv;
            DuctUnitFluid.Cache cache;
            DuctUnitFluid endPoint = (DuctUnitFluid)source.getLeft();
            byte side = (Byte)source.getRight();
            Attachment attachment = endPoint.parent.getAttachment((int)side);
            if (attachment != null && !attachment.canSend() || (cache = ((DuctUnitFluid.Cache[])endPoint.tileCache)[side]) == null || !endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || (inv = cache.getHandler(side ^ 1)) == null || inv.equals(ownHandler)) continue;
            FluidTankGrid tank = this.getTank();
            FluidStack extract = ProcessFluid.drain(tank, this.getMaxPull(tank), inv, requests::amount, ownHandler);
            if (extract == null) continue;
            sources.advanceCursor();
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateWants() {
        FluidList stacks = Snapshot.INSTANCE.getFluids((GridFluid)this.requester.getDuct().getGrid());
        if (stacks.types().stream().anyMatch(type -> stacks.amount(type) > 0L && this.requester.amountRequired(type) > 0L)) {
            DuctUnitFluid.Cache ownCache = ((DuctUnitFluid.Cache[])((DuctUnitFluid)this.requester.getDuct()).tileCache)[this.requester.getSide() ^ 1];
            if (ownCache == null) {
                return false;
            }
            IFluidHandler ownHandler = ownCache.getHandler((int)this.requester.getSide());
            if (ownHandler == null) {
                return false;
            }
            ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
            for (Pair source : sources) {
                IFluidHandler inv;
                DuctUnitFluid.Cache cache;
                DuctUnitFluid endPoint = (DuctUnitFluid)source.getLeft();
                byte side = (Byte)source.getRight();
                Attachment attachment = endPoint.parent.getAttachment((int)side);
                if (attachment != null && !attachment.canSend() || (cache = ((DuctUnitFluid.Cache[])endPoint.tileCache)[side]) == null || !endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || (inv = cache.getHandler(side ^ 1)) == null || inv.equals(ownHandler)) continue;
                FluidTankGrid tank = this.getTank();
                FluidStack extract = ProcessFluid.drain(tank, this.getMaxPull(tank), inv, this.requester::amountRequired, ownHandler);
                if (extract == null) continue;
                sources.advanceCursor();
                return true;
            }
        } else if (this.requester.getDuct().world().func_82737_E() % (long)((IProcessRequesterFluid)this.requester).tickDelay() == 0L) {
            Proposal proposal = new Proposal(null, null, 0L);
            this.requestFirstRequester(proposal, type -> Math.min(this.requester.amountRequired(type), (long)((IProcessRequesterFluid)this.requester).maxSize()), false);
            LinkedList requests = new LinkedList();
            for (Proposal prop : proposal.children) {
                requests.add(new Request(prop.type, prop.amount, new Source(this.requester.getSide(), prop.me), 0));
            }
            if (requests.size() > 0) {
                for (Request request : requests) {
                    this.requester.addRequest(request);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean attemptPull(ICrafter<FluidStack> crafter, StackList<FluidStack> stacks) {
        DuctUnitFluid.Cache ownCache = ((DuctUnitFluid.Cache[])((DuctUnitFluid)this.requester.getDuct()).tileCache)[this.requester.getSide() ^ 1];
        if (ownCache == null) {
            return false;
        }
        IFluidHandler ownHandler = ownCache.getHandler((int)this.requester.getSide());
        if (ownHandler == null) {
            return false;
        }
        DuctUnitFluid duct = (DuctUnitFluid)crafter.getDuct();
        if (duct == null) {
            return false;
        }
        byte side = crafter.getSide();
        DuctUnitFluid.Cache cache = ((DuctUnitFluid.Cache[])duct.tileCache)[side ^ 1];
        if (cache == null) {
            return false;
        }
        IFluidHandler inv = cache.getHandler((int)side);
        if (inv == null) {
            return false;
        }
        FluidTankGrid tank = this.getTank();
        FluidStack extract = ProcessFluid.drain(tank, this.getMaxPull(tank), inv, stacks::amount, ownHandler);
        if (extract != null) {
            crafter.finish(this.requester, new FluidType(extract), extract.amount);
            this.requester.onCrafterSend(crafter, new FluidType(extract), extract.amount);
            return true;
        }
        return false;
    }

    @Override
    public void findCrafter(Predicate<ICrafter<FluidStack>> predicate, boolean advanceCursor) {
        ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
        for (Pair source : sources) {
            DuctUnitFluid fluidDuct = (DuctUnitFluid)source.getLeft();
            byte side = (Byte)source.getRight();
            Attachment attachment = fluidDuct.parent.getAttachment((int)side);
            if (attachment != null && StackHandler.forEachCrafter(attachment, predicate)) {
                if (!advanceCursor) break;
                sources.advanceCursor();
                break;
            }
            DuctUnitFluid.Cache cache = ((DuctUnitFluid.Cache[])fluidDuct.tileCache)[side];
            if (cache == null) {
                if (!advanceCursor) continue;
                sources.advanceCursor();
                continue;
            }
            if (StackHandler.forEachCrafter(cache.tile, predicate)) {
                if (!advanceCursor) break;
                sources.advanceCursor();
                break;
            }
            if (!advanceCursor) continue;
            sources.advanceCursor();
        }
    }
}

