/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.process;

import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.process.IProcessRequesterItem;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Proposal;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.ItemType;
import astavie.thermallogistics.util.type.Type;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.ListWrapper;
import java.util.LinkedList;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessItem
extends Process<ItemStack> {
    public ProcessItem(IProcessRequesterItem requester) {
        super(requester);
    }

    @Override
    protected boolean updateRetrieval(StackList<ItemStack> requests) {
        DuctUnitItem.Cache ownCache = ((DuctUnitItem.Cache[])((DuctUnitItem)this.requester.getDuct()).tileCache)[this.requester.getSide() ^ 1];
        if (ownCache == null) {
            return false;
        }
        IItemHandler ownHandler = ownCache.getItemHandler((int)this.requester.getSide());
        if (ownHandler == null) {
            return false;
        }
        Function<Type<ItemStack>, Long> required = type -> Math.min(requests.amount((ItemStack)type), ((IProcessRequesterItem)this.requester).amountEmpty((Type<ItemStack>)type));
        ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
        for (Pair source : sources) {
            ItemStack extract;
            IItemHandler inv;
            DuctUnitItem.Cache cache;
            DuctUnitItem endPoint = (DuctUnitItem)source.getLeft();
            byte side = (Byte)source.getRight();
            Attachment attachment = endPoint.parent.getAttachment((int)side);
            if (attachment != null && !attachment.canSend() || (cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[side]) == null || !endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || !endPoint.parent.getConnectionType((int)side).allowTransfer || (inv = cache.getItemHandler(side ^ 1)) == null || inv.equals(ownHandler) || (extract = this.extract(endPoint, side, inv, required, (DuctUnitItem)this.requester.getDuct(), (byte)(this.requester.getSide() ^ 1))).func_190926_b()) continue;
            sources.advanceCursor();
            return true;
        }
        return false;
    }

    @Override
    protected boolean updateWants() {
        byte endSide = this.requester.getSide();
        ItemList stacks = Snapshot.INSTANCE.getItems((GridItem)this.requester.getDuct().getGrid());
        if (stacks.types().stream().anyMatch(type -> stacks.amount(type) > 0L && this.requester.amountRequired(type) > 0L)) {
            DuctUnitItem.Cache ownCache = ((DuctUnitItem.Cache[])((DuctUnitItem)this.requester.getDuct()).tileCache)[this.requester.getSide() ^ 1];
            if (ownCache == null) {
                return false;
            }
            IItemHandler ownHandler = ownCache.getItemHandler((int)this.requester.getSide());
            if (ownHandler == null) {
                return false;
            }
            ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
            for (Pair source : sources) {
                ItemStack extract;
                IItemHandler inv;
                DuctUnitItem.Cache cache;
                DuctUnitItem endPoint = (DuctUnitItem)source.getLeft();
                byte side = (Byte)source.getRight();
                Attachment attachment = endPoint.parent.getAttachment((int)side);
                if (attachment != null && !attachment.canSend() || (cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[side]) == null || !endPoint.isInput((int)side) && !endPoint.isOutput((int)side) || !endPoint.parent.getConnectionType((int)side).allowTransfer || (inv = cache.getItemHandler(side ^ 1)) == null || inv.equals(ownHandler) || (extract = this.extract(endPoint, side, inv, this.requester::amountRequired, (DuctUnitItem)this.requester.getDuct(), (byte)(endSide ^ 1))).func_190926_b()) continue;
                sources.advanceCursor();
                return true;
            }
        } else {
            Proposal proposal = new Proposal(null, null, 0L);
            this.requestFirstRequester(proposal, type -> Math.min(this.requester.amountRequired(type), (long)((IProcessRequesterItem)this.requester).maxSize()), false);
            LinkedList requests = new LinkedList();
            for (Proposal prop : proposal.children) {
                requests.add(new Request(prop.type, prop.amount, new Source(this.requester.getSide(), prop.me), 0));
            }
            if (requests.size() > 0) {
                for (Request request : requests) {
                    this.requester.addRequest(request);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean attemptPull(ICrafter<ItemStack> crafter, StackList<ItemStack> list) {
        DuctUnitItem duct = (DuctUnitItem)crafter.getDuct();
        if (duct == null) {
            return false;
        }
        byte side = crafter.getSide();
        DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])duct.tileCache)[side ^ 1];
        if (cache == null) {
            return false;
        }
        IItemHandler inv = cache.getItemHandler((int)side);
        if (inv == null) {
            return false;
        }
        Function<Type<ItemStack>, Long> required = type -> Math.min(list.amount((ItemStack)type), ((IProcessRequesterItem)this.requester).amountEmpty((Type<ItemStack>)type));
        ItemStack extract = this.extract(duct, (byte)(side ^ 1), inv, required, (DuctUnitItem)this.requester.getDuct(), (byte)(this.requester.getSide() ^ 1));
        if (!extract.func_190926_b()) {
            crafter.finish(this.requester, new ItemType(extract), extract.func_190916_E());
            this.requester.onCrafterSend(crafter, new ItemType(extract), extract.func_190916_E());
            return true;
        }
        return false;
    }

    @Override
    public void findCrafter(Predicate<ICrafter<ItemStack>> predicate, boolean advanceCursor) {
        ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> sources = this.requester.getSources();
        for (Pair source : sources) {
            DuctUnitItem endPoint = (DuctUnitItem)source.getLeft();
            byte side = (Byte)source.getRight();
            Attachment attachment = endPoint.parent.getAttachment((int)side);
            if (attachment != null && StackHandler.forEachCrafter(attachment, predicate)) {
                if (!advanceCursor) break;
                sources.advanceCursor();
                break;
            }
            DuctUnitItem.Cache cache = ((DuctUnitItem.Cache[])endPoint.tileCache)[side];
            if (cache == null) {
                if (!advanceCursor) continue;
                sources.advanceCursor();
                continue;
            }
            if (StackHandler.forEachCrafter(cache.tile, predicate)) {
                if (!advanceCursor) break;
                sources.advanceCursor();
                break;
            }
            if (!advanceCursor) continue;
            sources.advanceCursor();
        }
    }

    private ItemStack extract(DuctUnitItem duct, byte side, IItemHandler inv, Function<Type<ItemStack>, Long> required, DuctUnitItem end, byte endSide) {
        Route route = duct.getRoute((IGridTileRoute)end);
        if (route == null) {
            return ItemStack.field_190927_a;
        }
        int maxPull = ((IProcessRequesterItem)this.requester).maxSize();
        boolean multiStack = ((IProcessRequesterItem)this.requester).multiStack();
        byte speed = ((IProcessRequesterItem)this.requester).speedBoost();
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack item = inv.getStackInSlot(slot);
            ItemType type = new ItemType(item);
            long req = required.apply(type);
            if (req == 0L) continue;
            item = type.withAmount((int)Math.min((long)maxPull, req));
            int left = StackHandler.canRouteItem(end, item, endSide, null);
            item.func_190918_g(left);
            if (item.func_190926_b() || (item = inv.extractItem(slot, maxPull = item.func_190916_E(), false)).func_190926_b()) continue;
            route = route.copy();
            route.pathDirections.add(endSide);
            if (multiStack && item.func_190916_E() < maxPull) {
                while (item.func_190916_E() < maxPull && slot < inv.getSlots()) {
                    ItemStack extract;
                    if (type.references(inv.getStackInSlot(slot)) && !(extract = inv.extractItem(slot, maxPull - item.func_190916_E(), false)).func_190926_b()) {
                        item.func_190917_f(extract.func_190916_E());
                    }
                    ++slot;
                }
            }
            duct.insertNewItem(new TravelingItem(item, (IGridTile)duct, route, (byte)(side ^ 1), speed));
            return item;
        }
        return ItemStack.field_190927_a;
    }
}

