/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.tile;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.attachment.IRequesterContainer;
import astavie.thermallogistics.block.BlockTerminal;
import astavie.thermallogistics.process.IProcessRequester;
import astavie.thermallogistics.process.Process;
import astavie.thermallogistics.process.Request;
import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.tile.InventorySpecial;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import cofh.CoFHCore;
import cofh.core.block.TileNameable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.network.PacketTileInfo;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileTerminal<I>
extends TileNameable
implements ITickable,
IRequesterContainer<I> {
    public final InventorySpecial requester = new InventorySpecial(1, i -> i.func_77973_b() == ThermalLogistics.Items.requester, null);
    public final StackList<I> terminal = this.createStackList();
    public final LinkedList<Request<I>> requests = new LinkedList();
    private final Set<Container> registry = new HashSet<Container>();
    protected TerminalRequester<I>[] requesters = new TerminalRequester[6];
    public boolean refresh = false;

    private static <I> boolean references(@Nullable RequesterReference<I> reference, @Nullable ICrafter<I> crafter) {
        return reference == null && crafter == null || reference != null && reference.references(crafter);
    }

    public PacketTileInfo getSyncPacket() {
        PacketTileInfo packet = PacketTileInfo.newPacket((TileEntity)this);
        this.sync((PacketBase)packet);
        return packet;
    }

    private void sync(PacketBase packet) {
        this.terminal.writePacket(packet);
        packet.addInt(this.requests.size());
        for (int i = 0; i < this.requests.size(); ++i) {
            Request<I> request = this.requests.get(i);
            Request.writePacket(packet, request, i);
        }
    }

    private void read(PacketBase packet) {
        this.terminal.readPacket(packet);
        this.requests.clear();
        int size = packet.getInt();
        for (int i = 0; i < size; ++i) {
            this.addRequest(Request.readPacket(packet, this.terminal::readType));
        }
    }

    protected abstract void read(PacketBase var1, byte var2, EntityPlayer var3);

    public void handleTileInfoPacket(PacketBase payload, boolean isServer, EntityPlayer player) {
        if (isServer) {
            byte message = payload.getByte();
            if (message == 0) {
                this.request(payload);
            } else if (message == 1) {
                int start = payload.getInt();
                int end = payload.getInt();
                if (start < this.requests.size()) {
                    this.clearRequests(this.requests.subList(start, Math.min(end, this.requests.size())));
                    this.markChunkDirty();
                    PacketHandler.sendToAllAround((PacketBase)this.getSyncPacket(), (TileEntity)this);
                }
            } else {
                this.read(payload, message, player);
            }
        } else {
            this.refresh = true;
            this.read(payload);
        }
    }

    private void clearRequests(List<Request<I>> list) {
        Iterator<Request<I>> iterator = list.iterator();
        while (iterator.hasNext()) {
            this.removeRequest(iterator.next());
            iterator.remove();
        }
    }

    private void removeRequest(Request<I> request) {
        if (!request.isError() && request.source.isCrafter()) {
            TerminalRequester<I> requester = this.requesters[request.source.side];
            ((ICrafter)request.source.crafter.get()).cancel(requester, request.type, request.amount);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newSate) {
        return oldState.func_177230_c().getClass() != newSate.func_177230_c().getClass();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (Request request : this.requests) {
            if (request.isError()) continue;
            list.func_74742_a((NBTBase)Request.writeNBT(request));
        }
        nbt.func_74782_a("requester", (NBTBase)this.requester.get().func_77955_b(new NBTTagCompound()));
        nbt.func_74782_a("requests", (NBTBase)list);
        return nbt;
    }

    public abstract String getTileName();

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.requester.set(new ItemStack(nbt.func_74775_l("requester")));
        this.requests.clear();
        NBTTagList list = nbt.func_150295_c("requests", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.requests.add(Request.readNBT(list.func_150305_b(i), this.terminal::readType, i));
        }
    }

    public void register(Container container) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            this.registry.add(container);
            this.setActive(true);
        }
    }

    public void remove(Container container) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            this.registry.remove(container);
            if (this.registry.isEmpty()) {
                this.setActive(false);
            }
        }
    }

    private void setActive(boolean active) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        BlockTerminal block = (BlockTerminal)state.func_177230_c();
        if (block.active != active) {
            block.keepInventory = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, block.getActive(active).func_176223_P().func_177226_a(BlockTerminal.DIRECTION, (Comparable)((Object)((BlockTerminal.Direction)((Object)state.func_177229_b(BlockTerminal.DIRECTION))))), 3);
            block.keepInventory = false;
            this.func_145829_t();
            this.field_145850_b.func_175690_a(this.field_174879_c, (TileEntity)this);
            this.markChunkDirty();
        }
    }

    protected Object getMod() {
        return CoFHCore.instance;
    }

    protected String getModVersion() {
        return ThermalLogistics.MOD_VERSION;
    }

    public boolean hasGui() {
        return true;
    }

    public abstract Object getGuiClient(InventoryPlayer var1);

    public abstract Object getGuiServer(InventoryPlayer var1);

    public boolean openGui(EntityPlayer player) {
        if (this.hasGui()) {
            PacketHandler.sendTo((PacketBase)this.getSyncPacket(), (EntityPlayer)player);
            player.openGui(this.getMod(), 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasGui();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.requester.get().func_190926_b()) {
                this.clearRequests(this.requests);
            } else if (this.field_145850_b.func_82737_E() % (long)ServoItem.tickDelays[this.requester.get().func_77960_j()] == 0L) {
                for (int i = this.requests.size() - 1; i >= 0; --i) {
                    Request<I> request = this.requests.get(i);
                    if (request.isError() || this.requesters[request.source.side].isEnabled()) continue;
                    this.requests.remove(i);
                    this.request(request.type, request.amount);
                }
                boolean onlyCheck = false;
                for (TerminalRequester<I> requester : this.requesters) {
                    if (!requester.isEnabled() || !requester.process.update(onlyCheck)) continue;
                    onlyCheck = true;
                }
            }
        }
    }

    @Override
    public List<IRequester<I>> getRequesters() {
        return Arrays.asList(this.requesters);
    }

    protected abstract StackList<I> createStackList();

    private void request(PacketBase payload) {
        Type<I> type = this.terminal.readType(payload);
        long amount = payload.getLong();
        this.request(type, amount);
    }

    private void request(Type<I> type, long amount) {
        this.updateTerminal();
        long left = amount;
        Request lastError = null;
        for (int side = 0; side < 6 && left > 0L; side = (int)((byte)(side + 1))) {
            if (!this.requesters[side].isEnabled()) continue;
            List requests = this.requesters[side].process.request(type, left, this.terminal::amount);
            left = 0L;
            for (Request request : requests) {
                if (request.isError()) {
                    if (request.complex) {
                        lastError = null;
                        this.addRequest(request);
                        continue;
                    }
                    if (request.missing.map.size() == 1 && request.missing.map.containsKey(type)) {
                        lastError = request;
                        left += request.amount;
                        continue;
                    }
                    lastError = null;
                    this.addRequest(request);
                    continue;
                }
                this.addRequest(request);
            }
        }
        if (lastError != null) {
            this.addRequest(lastError);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.markChunkDirty();
            PacketHandler.sendToAllAround((PacketBase)this.getSyncPacket(), (TileEntity)this);
        }
    }

    protected long amountRequested(Source<I> source, Type<I> type) {
        long amount = 0L;
        for (Request request : this.requests) {
            if (request.isError() || !request.source.equals(source) || !request.type.equals(type)) continue;
            amount += request.amount;
        }
        return amount;
    }

    protected void removeRequested(Source<I> source, Type<I> type, long amount) {
        Iterator iterator = this.requests.iterator();
        while (iterator.hasNext()) {
            Request request = (Request)iterator.next();
            if (request.isError() || !request.source.equals(source) || !request.type.equals(type)) continue;
            long remove = Math.min(request.amount, amount);
            request.amount -= remove;
            amount -= remove;
            if (request.amount == 0L) {
                iterator.remove();
            }
            if (amount != 0L) continue;
            return;
        }
    }

    public abstract void updateTerminal();

    protected abstract DuctUnit<?, ?, ?> getDuct(byte var1);

    protected abstract ItemStack getIcon();

    private void addRequest(Request<I> request) {
        if (!request.isError()) {
            Request<I> last;
            if (!this.field_145850_b.field_72995_K && !request.source.isCrafter()) {
                Snapshot.INSTANCE.getStacks(this.getDuct(request.source.side).getGrid()).remove(request.type, request.amount);
                this.terminal.remove(request.type, request.amount);
            }
            if (!this.requests.isEmpty() && !(last = this.requests.getLast()).isError() && last.source.equals(request.source) && last.type.equals(request.type)) {
                last.amount += request.amount;
                return;
            }
        }
        this.requests.add(request);
    }

    public static abstract class TerminalRequester<I>
    implements IProcessRequester<I> {
        protected final TileTerminal<I> terminal;
        protected final byte side;
        protected Process<I> process;

        public TerminalRequester(TileTerminal<I> terminal, byte side) {
            this.terminal = terminal;
            this.side = side;
        }

        public boolean isEnabled() {
            return this.getDuct() != null;
        }

        @Override
        public Map<RequesterReference<I>, StackList<I>> getRequests() {
            HashMap<RequesterReference<I>, StackList<I>> map = new HashMap<RequesterReference<I>, StackList<I>>();
            for (Request request : this.terminal.requests) {
                if (request.isError() || request.source.side != this.side) continue;
                map.computeIfAbsent(request.source.crafter, c -> this.terminal.createStackList());
                ((StackList)map.get(request.source.crafter)).add(request.type, request.amount);
            }
            return map;
        }

        @Override
        public void onCrafterSend(ICrafter<I> crafter, Type<I> type, long amount) {
            for (int i = 0; i < this.terminal.requests.size(); ++i) {
                Request request = this.terminal.requests.get(i);
                if (request.isError() || !request.source.isCrafter() || !TileTerminal.references(request.source.crafter, crafter) || request.source.side != this.side || !request.type.equals(type)) continue;
                if (request.amount <= amount) {
                    amount -= request.amount;
                    request.source = new Source(this.side);
                } else {
                    request.amount -= amount;
                    this.terminal.requests.add(i, new Request<I>(type, amount, new Source(this.side), 0));
                    amount = 0L;
                }
                if (amount != 0L) continue;
                return;
            }
            throw new IllegalStateException();
        }

        @Override
        public boolean hasWants() {
            return false;
        }

        @Override
        public long amountRequired(Type<I> type) {
            return 0L;
        }

        @Override
        public void addRequest(Request<I> request) {
            ((TileTerminal)this.terminal).addRequest(request);
        }

        @Override
        public boolean referencedBy(RequesterReference<?> reference) {
            return reference.dim == ((TileTerminal)this.terminal).field_145850_b.field_73011_w.getDimension() && reference.pos.equals((Object)((TileTerminal)this.terminal).field_174879_c) && reference.index == this.side;
        }

        @Override
        public RequesterReference<I> createReference() {
            return new RequesterReference(((TileTerminal)this.terminal).field_145850_b.field_73011_w.getDimension(), ((TileTerminal)this.terminal).field_174879_c, 0, this.side);
        }

        @Override
        public ItemStack getIcon() {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack getTileIcon() {
            return this.terminal.getIcon();
        }

        @Override
        public BlockPos getDestination() {
            return ((TileTerminal)this.terminal).field_174879_c;
        }

        @Override
        public DuctUnit<?, ?, ?> getDuct() {
            return this.terminal.getDuct(this.side);
        }

        @Override
        public byte getSide() {
            return this.side;
        }

        @Override
        public void onFail(Type<I> type, long amount) {
            Source source = new Source(this.side);
            long remove = Math.min(this.terminal.amountRequested(source, type), amount);
            this.terminal.removeRequested(source, type, remove);
            ((TileTerminal)this.terminal).addRequest(new Request<I>(type, remove, 0, null, true));
        }

        @Override
        public void onFail(RequesterReference<I> crafter, Type<I> type, long amount) {
            Source<I> source = new Source<I>(this.side, crafter);
            long remove = Math.min(this.terminal.amountRequested(source, type), amount);
            this.terminal.removeRequested(source, type, remove);
            ((TileTerminal)this.terminal).addRequest(new Request<I>(type, remove, 0, null, true));
        }

        @Override
        public StackList<I> getRequestedStacks() {
            StackList<I> list = this.terminal.createStackList();
            for (Request request : this.terminal.requests) {
                if (request.isError() || request.source.isCrafter() || request.source.side != this.side) continue;
                list.add(request.type, request.amount);
            }
            return list;
        }

        @Override
        public StackList<I> getRequestedStacks(ICrafter<I> crafter) {
            StackList<I> list = this.terminal.createStackList();
            for (Request request : this.terminal.requests) {
                if (request.isError() || !request.source.isCrafter() || request.source.side != this.side || !request.source.crafter.references(crafter)) continue;
                list.add(request.type, request.amount);
            }
            return list;
        }
    }
}

