/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.tile;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.DistributorItem;
import astavie.thermallogistics.block.BlockTerminal;
import astavie.thermallogistics.client.gui.GuiTerminalItem;
import astavie.thermallogistics.container.ContainerTerminalItem;
import astavie.thermallogistics.process.IProcessRequesterItem;
import astavie.thermallogistics.process.ProcessItem;
import astavie.thermallogistics.process.Source;
import astavie.thermallogistics.tile.TileTerminal;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.Shared;
import astavie.thermallogistics.util.Snapshot;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.ItemType;
import astavie.thermallogistics.util.type.Type;
import codechicken.lib.inventory.InventorySimple;
import cofh.core.inventory.InventoryCraftingFalse;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.util.helpers.InventoryHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermaldynamics.duct.attachments.servo.ServoItem;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.util.ListWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class TileTerminalItem
extends TileTerminal<ItemStack> {
    public final Shared.Item[] shared = new Shared.Item[9];
    public final InventorySimple inventory = new InventorySimple(27);

    public TileTerminalItem() {
        for (byte side = 0; side < 6; side = (byte)(side + 1)) {
            this.requesters[side] = new TerminalItemRequester(this, side);
        }
    }

    @Override
    protected void read(PacketBase packet, byte message, EntityPlayer player) {
        if (message == 2) {
            boolean shift = packet.getBool();
            Ingredient[] ingredients = new Ingredient[9];
            for (int i = 0; i < 9; ++i) {
                ItemStack[] stacks = new ItemStack[packet.getInt()];
                for (int j = 0; j < stacks.length; ++j) {
                    stacks[j] = packet.getItemStack();
                }
                ingredients[i] = Ingredient.func_193369_a((ItemStack[])stacks);
            }
            block2: do {
                ItemList items = new ItemList();
                for (int slot = 0; slot < this.inventory.func_70302_i_(); ++slot) {
                    if (this.inventory.func_70301_a(slot).func_190926_b()) continue;
                    items.add(this.inventory.func_70301_a(slot));
                }
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    if (stack.func_190926_b()) continue;
                    items.add(stack);
                }
                for (Ingredient ingredient : ingredients) {
                    if (ingredient != Ingredient.field_193370_a && !items.remove(ingredient)) break block2;
                }
                InventoryCraftingFalse inventory = new InventoryCraftingFalse(3, 3);
                int ingredientsLength = ingredients.length;
                block6: for (int i = 0; i < ingredientsLength; ++i) {
                    ItemStack stack;
                    int slot;
                    Ingredient ingredient;
                    ingredient = ingredients[i];
                    if (ingredient == Ingredient.field_193370_a) continue;
                    for (slot = 0; slot < this.inventory.func_70302_i_(); ++slot) {
                        stack = this.inventory.func_70301_a(slot);
                        if (!ingredient.apply(stack)) continue;
                        inventory.func_70299_a(i, ItemHelper.cloneStack((ItemStack)stack, (int)1));
                        continue block6;
                    }
                    for (slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
                        stack = player.field_71071_by.func_70301_a(slot);
                        if (!ingredient.apply(stack)) continue;
                        inventory.func_70299_a(i, ItemHelper.cloneStack((ItemStack)stack, (int)1));
                        continue block6;
                    }
                }
                IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)inventory, (World)player.field_70170_p);
                if (recipe == null) break;
                ItemStack craft = recipe.func_77572_b((InventoryCrafting)inventory);
                ItemStack hand = player.field_71071_by.func_70445_o();
                if (!shift && !hand.func_190926_b() && (!ItemHelper.itemsIdentical((ItemStack)craft, (ItemStack)hand) || craft.func_190916_E() + hand.func_190916_E() > hand.func_77976_d())) break;
                craft.func_77980_a(this.field_145850_b, player, craft.func_190916_E());
                FMLCommonHandler.instance().firePlayerCraftingEvent(player, craft, (IInventory)inventory);
                if (!recipe.func_192399_d()) {
                    player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{recipe}));
                }
                int ingredientsLength2 = ingredients.length;
                block9: for (int i = 0; i < ingredientsLength2; ++i) {
                    ItemStack stack;
                    int slot;
                    Ingredient ingredient = ingredients[i];
                    if (ingredient == Ingredient.field_193370_a) continue;
                    for (slot = 0; slot < this.inventory.func_70302_i_(); ++slot) {
                        stack = this.inventory.func_70301_a(slot);
                        if (!ingredient.apply(stack)) continue;
                        this.inventory.func_70298_a(slot, 1);
                        continue block9;
                    }
                    for (slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
                        stack = player.field_71071_by.func_70301_a(slot);
                        if (!ingredient.apply(stack)) continue;
                        player.field_71071_by.func_70298_a(slot, 1);
                        continue block9;
                    }
                }
                ForgeHooks.setCraftingPlayer((EntityPlayer)player);
                NonNullList ret = recipe.func_179532_b((InventoryCrafting)inventory);
                ForgeHooks.setCraftingPlayer(null);
                for (ItemStack stack : ret) {
                    ItemStack item = InventoryHelper.insertStackIntoInventory((IItemHandler)new InvWrapper((IInventory)this.inventory), (ItemStack)stack.func_77946_l(), (boolean)false);
                    if (item.func_190926_b()) continue;
                    player.field_71071_by.func_191975_a(this.field_145850_b, item);
                }
                if (shift) {
                    ItemStack item = InventoryHelper.insertStackIntoInventory((IItemHandler)new InvWrapper((IInventory)this.inventory), (ItemStack)craft.func_77946_l(), (boolean)false);
                    if (item.func_190926_b()) continue;
                    player.field_71071_by.func_191975_a(this.field_145850_b, item);
                    continue;
                }
                player.field_71071_by.func_70437_b(hand.func_190926_b() ? craft.func_77946_l() : ItemHelper.cloneStack((ItemStack)hand, (int)(hand.func_190916_E() + craft.func_190916_E())));
                ((EntityPlayerMP)player).func_71113_k();
            } while (shift);
            player.field_71070_bA.func_75142_b();
        } else if (message == 3) {
            if (this.requester.get().func_190926_b()) {
                return;
            }
            ItemStack hand = player.field_71071_by.func_70445_o();
            if (this.dump(hand)) {
                player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                ((EntityPlayerMP)player).func_71113_k();
            }
        } else if (message == 4) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack item = this.inventory.func_70301_a(i);
                if (item.func_190926_b()) continue;
                item.func_190920_e(InventoryHelper.insertStackIntoInventory((IItemHandler)new PlayerMainInvWrapper(player.field_71071_by), (ItemStack)item.func_77946_l(), (boolean)false).func_190916_E());
            }
            player.field_71070_bA.func_75142_b();
        } else if (message == 5) {
            if (this.requester.get().func_190926_b()) {
                return;
            }
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b() || !this.dump(stack)) continue;
                this.inventory.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    public DuctUnitItem getDuct(byte side) {
        DuctUnitItem duct;
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.func_82600_a((int)side)));
        if (tile instanceof TileGrid && (duct = (DuctUnitItem)((TileGrid)tile).getDuct(DuctToken.ITEMS)) != null && duct.isOutput(side ^ 1)) {
            return duct;
        }
        return null;
    }

    private ListWrapper<Route<DuctUnitItem, GridItem>> getRoutes(DuctUnitItem duct) {
        ListWrapper routesWithInsertSideList = new ListWrapper();
        if (duct.getGrid() == null) {
            routesWithInsertSideList.setList(new LinkedList(), ListWrapper.SortType.NORMAL);
            return routesWithInsertSideList;
        }
        Stream routesWithDestinations = ServoItem.getRoutesWithDestinations((Collection)duct.getCache().outputRoutes);
        LinkedList objects = Lists.newLinkedList();
        routesWithDestinations.forEach(objects::add);
        routesWithInsertSideList.setList(objects, ListWrapper.SortType.NORMAL);
        return routesWithInsertSideList;
    }

    private boolean dump(ItemStack stack) {
        int type = this.requester.get().func_77960_j();
        for (byte side = 0; side < 6; side = (byte)(side + 1)) {
            TravelingItem item;
            DuctUnitItem duct = this.getDuct(side);
            if (duct == null || (item = DistributorItem.findRouteForItem(stack, this.getRoutes(duct), duct, side ^ 1, ServoItem.range[type], ServoItem.speedBoost[type])) == null) continue;
            duct.insertNewItem(item);
            return true;
        }
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList slots = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound item = stack.func_77955_b(new NBTTagCompound());
            item.func_74768_a("slot", i);
            slots.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a("inventory", (NBTBase)slots);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList slots = nbt.func_150295_c("inventory", 10);
        for (int i = 0; i < slots.func_74745_c(); ++i) {
            NBTTagCompound item = slots.func_150305_b(i);
            this.inventory.func_70299_a(item.func_74762_e("slot"), new ItemStack(item));
        }
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiTerminalItem(this, inventory);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTerminalItem(this, inventory);
    }

    @Override
    protected StackList<ItemStack> createStackList() {
        return new ItemList();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != ((BlockTerminal.Direction)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockTerminal.DIRECTION))).getFace() || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing != null && facing != ((BlockTerminal.Direction)((Object)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockTerminal.DIRECTION))).getFace()) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new Inventory(this, (IInventory)this.inventory, (byte)facing.func_176745_a()));
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public String getTileName() {
        return ThermalLogistics.Blocks.terminal_item.func_149739_a() + ".name";
    }

    @Override
    public void updateTerminal() {
        HashSet<GridItem> grids = new HashSet<GridItem>();
        HashSet<IItemHandler> inventories = new HashSet<IItemHandler>();
        this.terminal.clear();
        for (byte side = 0; side < 6; side = (byte)(side + 1)) {
            DuctUnitItem duct = this.getDuct(side);
            if (duct == null || grids.contains(duct.getGrid())) continue;
            this.terminal.addAll(Snapshot.INSTANCE.getItems((GridItem)duct.getGrid()));
            for (IItemHandler handler : Snapshot.INSTANCE.getInventories((GridItem)duct.getGrid())) {
                if (inventories.add(handler)) continue;
                for (int slot = 0; slot < handler.getSlots(); ++slot) {
                    ItemStack extract = handler.getStackInSlot(slot);
                    if (extract.func_190926_b()) continue;
                    this.terminal.remove(extract);
                }
            }
            grids.add((GridItem)duct.getGrid());
        }
    }

    @Override
    protected ItemStack getIcon() {
        return new ItemStack((Block)ThermalLogistics.Blocks.terminal_item);
    }

    private static class TerminalItemRequester
    extends TileTerminal.TerminalRequester<ItemStack>
    implements IProcessRequesterItem {
        public TerminalItemRequester(TileTerminal<ItemStack> terminal, byte side) {
            super(terminal, side);
            this.process = new ProcessItem(this);
        }

        @Override
        public int maxSize() {
            return ServoItem.maxSize[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public boolean multiStack() {
            return ServoItem.multiStack[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public byte speedBoost() {
            return ServoItem.speedBoost[this.terminal.requester.get().func_77960_j()];
        }

        @Override
        public ListWrapper<Pair<DuctUnit<?, ?, ?>, Byte>> getSources() {
            ListWrapper sources = new ListWrapper();
            LinkedList list = new LinkedList();
            Stream stream = ServoItem.getRoutesWithDestinations((Collection)((DuctUnitItem)this.getDuct()).getCache().outputRoutes);
            stream.map(r -> Pair.of((Object)((DuctUnit)r.endPoint), (Object)r.getLastSide())).forEach(list::add);
            sources.setList(list, ListWrapper.SortType.NORMAL);
            return sources;
        }

        @Override
        public StackList<ItemStack> getRequestedStacks() {
            GridItem grid;
            StackList<ItemStack> list = super.getRequestedStacks().copy();
            DuctUnit<?, ?, ?> duct = this.getDuct();
            if (duct != null && (grid = (GridItem)duct.getGrid()) != null) {
                StackMap map = grid.travelingItems.getOrDefault(this.getDestination(), new StackMap());
                for (ItemStack item : map.getItems()) {
                    list.remove(item);
                }
            }
            return list;
        }

        @Override
        public Map<RequesterReference<ItemStack>, StackList<ItemStack>> getRequests() {
            Map<RequesterReference<ItemStack>, StackList<ItemStack>> requests = super.getRequests();
            if (requests.containsKey(null)) {
                StackList<ItemStack> list = requests.get(null);
                StackMap map = ((GridItem)this.getDuct().getGrid()).travelingItems.getOrDefault(this.getDestination(), new StackMap());
                for (ItemStack item : map.getItems()) {
                    list.remove(item);
                }
            }
            return requests;
        }

        @Override
        public long amountEmpty(Type<ItemStack> type) {
            return Integer.MAX_VALUE;
        }
    }

    private static class Inventory
    extends InvWrapper {
        private final TileTerminalItem tile;
        private final byte side;

        private Inventory(TileTerminalItem tile, IInventory inv, byte side) {
            super(inv);
            this.tile = tile;
            this.side = side;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            int amount;
            if (simulate) {
                if (StackHandler.SIM) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
            ItemStack remainder = super.insertItem(slot, stack, simulate);
            if (!simulate && (amount = stack.func_190916_E() - remainder.func_190916_E()) > 0) {
                this.tile.removeRequested(new Source(this.side), new ItemType(stack), amount);
                PacketHandler.sendToAllAround((PacketBase)this.tile.getSyncPacket(), (TileEntity)this.tile);
            }
            return remainder;
        }
    }
}

