/*
 * Decompiled with CFR 0.152.
 */
package astavie.thermallogistics.util;

import astavie.thermallogistics.ThermalLogistics;
import astavie.thermallogistics.attachment.ICrafter;
import astavie.thermallogistics.attachment.IRequester;
import astavie.thermallogistics.util.RequesterReference;
import astavie.thermallogistics.util.StackHandler;
import astavie.thermallogistics.util.collection.EmptyList;
import astavie.thermallogistics.util.collection.FluidList;
import astavie.thermallogistics.util.collection.ItemList;
import astavie.thermallogistics.util.collection.StackList;
import astavie.thermallogistics.util.type.Type;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.fluid.DuctUnitFluid;
import cofh.thermaldynamics.duct.fluid.GridFluid;
import cofh.thermaldynamics.duct.item.DuctUnitItem;
import cofh.thermaldynamics.duct.item.GridItem;
import cofh.thermaldynamics.duct.item.StackMap;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;

public class Snapshot {
    public static final Snapshot INSTANCE = new Snapshot();
    private long globalTick;
    private Map<MultiBlockGrid<?>, Long> tick = new HashMap();
    private Multimap<GridItem, IItemHandler> inventories = HashMultimap.create();
    private Multimap<GridFluid, IFluidHandler> tanks = HashMultimap.create();
    private Map<GridItem, ItemList> items = new HashMap<GridItem, ItemList>();
    private Map<GridFluid, FluidList> fluids = new HashMap<GridFluid, FluidList>();
    private Map<GridItem, ItemList> itemsMutated = new HashMap<GridItem, ItemList>();
    private Map<GridFluid, FluidList> fluidsMutated = new HashMap<GridFluid, FluidList>();
    private Map<RequesterReference<?>, StackList<?>> leftoversMutated = new HashMap();

    private Snapshot() {
    }

    public void clearMutated() {
        this.itemsMutated.clear();
        this.fluidsMutated.clear();
        this.leftoversMutated.clear();
    }

    public void applyMutated() {
        this.items = this.itemsMutated;
        this.fluids = this.fluidsMutated;
        for (Map.Entry<RequesterReference<?>, StackList<?>> entry : this.leftoversMutated.entrySet()) {
            this.applyLeftover(entry.getKey(), entry.getValue());
        }
        this.itemsMutated = new HashMap<GridItem, ItemList>();
        this.fluidsMutated = new HashMap<GridFluid, FluidList>();
        this.leftoversMutated = new HashMap();
    }

    private void refresh(World world) {
        if (this.globalTick >= world.func_82737_E() + (long)ThermalLogistics.INSTANCE.refreshDelay) {
            return;
        }
        this.globalTick = world.func_82737_E();
        Iterator<MultiBlockGrid<?>> iterator = this.tick.keySet().iterator();
        while (iterator.hasNext()) {
            MultiBlockGrid<?> grid = iterator.next();
            if (grid.worldGrid.tickingGrids.contains(grid)) continue;
            iterator.remove();
            this.inventories.removeAll(grid);
            this.tanks.removeAll(grid);
            this.items.remove(grid);
            this.fluids.remove(grid);
        }
    }

    private void refresh(GridItem grid) {
        World world = grid.worldGrid.worldObj;
        this.refresh(world);
        if (this.tick.getOrDefault(grid, 0L) >= world.func_82737_E() + (long)ThermalLogistics.INSTANCE.refreshDelay) {
            return;
        }
        this.tick.put((MultiBlockGrid<?>)grid, world.func_82737_E());
        Collection handlers = this.inventories.get((Object)grid);
        handlers.clear();
        this.items.computeIfAbsent(grid, g -> new ItemList());
        ItemList list = this.items.get(grid);
        list.clear();
        HashSet requesters = new HashSet();
        for (DuctUnitItem duct : grid.nodeSet) {
            for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
                DuctUnitItem.Cache cache;
                if (!duct.isInput(n) && !duct.isOutput(n) || !duct.parent.getConnectionType((int)n).allowTransfer || (cache = ((DuctUnitItem.Cache[])duct.tileCache)[n]) == null) continue;
                Attachment attachment = duct.parent.getAttachment(n);
                if (attachment != null) {
                    StackHandler.addRequesters(requesters, attachment);
                    StackHandler.addCraftable(list, attachment);
                    if (!attachment.canSend()) continue;
                }
                StackHandler.addRequesters(requesters, cache.tile);
                StackHandler.addCraftable(list, cache.tile);
                IItemHandler iItemHandler = cache.getItemHandler(n ^ 1);
                if (iItemHandler == null || handlers.contains(iItemHandler)) continue;
                handlers.add(iItemHandler);
                for (int slot = 0; slot < iItemHandler.getSlots(); ++slot) {
                    ItemStack extract = iItemHandler.getStackInSlot(slot);
                    if (extract.func_190926_b()) continue;
                    list.add(extract);
                }
            }
        }
        HashMap<IRequester, ItemList> leftovers = new HashMap<IRequester, ItemList>();
        for (IRequester iRequester : requesters) {
            StackList requested = iRequester.getRequestedStacks();
            for (Type type : requested.types()) {
                long leftover = list.remove(type, requested.amount(type));
                if (leftover <= 0L) continue;
                leftovers.computeIfAbsent(iRequester, r -> new ItemList());
                ((ItemList)leftovers.get(iRequester)).add(type, leftover);
            }
        }
        for (Map.Entry entry : leftovers.entrySet()) {
            StackMap travelling = grid.travelingItems.getOrDefault(((IRequester)entry.getKey()).getDestination(), new StackMap());
            for (ItemStack itemStack : travelling.getItems()) {
                ((ItemList)entry.getValue()).remove(itemStack);
            }
            for (Type type : ((ItemList)entry.getValue()).types()) {
                long amount = ((ItemList)entry.getValue()).amount(type);
                ((IRequester)entry.getKey()).onFail(type, amount);
            }
        }
    }

    private void refresh(GridFluid grid) {
        World world = grid.worldGrid.worldObj;
        this.refresh(world);
        if (this.tick.getOrDefault(grid, 0L) >= world.func_82737_E() + (long)ThermalLogistics.INSTANCE.refreshDelay) {
            return;
        }
        this.tick.put((MultiBlockGrid<?>)grid, world.func_82737_E());
        Collection handlers = this.tanks.get((Object)grid);
        handlers.clear();
        this.fluids.computeIfAbsent(grid, g -> new FluidList());
        FluidList list = this.fluids.get(grid);
        list.clear();
        if (grid.hasValidFluid()) {
            list.add(grid.getFluid());
        }
        HashSet requesters = new HashSet();
        for (DuctUnitFluid duct : grid.nodeSet) {
            for (int n = 0; n < 6; n = (int)((byte)(n + 1))) {
                DuctUnitFluid.Cache cache;
                byte side = (byte)((n + duct.internalSideCounter) % 6);
                if (!duct.isInput((int)side) && !duct.isOutput((int)side) || !duct.parent.getConnectionType((int)side).allowTransfer || (cache = ((DuctUnitFluid.Cache[])duct.tileCache)[side]) == null) continue;
                Attachment attachment = duct.parent.getAttachment((int)side);
                if (attachment != null) {
                    StackHandler.addRequesters(requesters, attachment);
                    StackHandler.addCraftable(list, attachment);
                    if (!attachment.canSend()) continue;
                }
                StackHandler.addRequesters(requesters, cache.tile);
                StackHandler.addCraftable(list, cache.tile);
                IFluidHandler inv = cache.getHandler(side ^ 1);
                if (inv == null || handlers.contains(inv)) continue;
                handlers.add(inv);
                for (IFluidTankProperties tank : inv.getTankProperties()) {
                    FluidStack extract = tank.getContents();
                    if (extract == null) continue;
                    list.add(extract);
                }
            }
        }
        HashMap<IRequester, FluidList> leftovers = new HashMap<IRequester, FluidList>();
        for (IRequester iRequester : requesters) {
            StackList requested = iRequester.getRequestedStacks();
            for (Type type : requested.types()) {
                long leftover = list.remove(type, requested.amount(type));
                if (leftover <= 0L) continue;
                leftovers.computeIfAbsent(iRequester, r -> new FluidList());
                ((FluidList)leftovers.get(iRequester)).add(type, leftover);
            }
        }
        for (Map.Entry entry : leftovers.entrySet()) {
            for (Type type : ((FluidList)entry.getValue()).types()) {
                long amount = ((FluidList)entry.getValue()).amount(type);
                ((IRequester)entry.getKey()).onFail(type, amount);
            }
        }
    }

    public Collection<IItemHandler> getInventories(GridItem grid) {
        this.refresh(grid);
        return this.inventories.get((Object)grid);
    }

    public Collection<IFluidHandler> getTanks(GridFluid grid) {
        this.refresh(grid);
        return this.tanks.get((Object)grid);
    }

    public <I> StackList<I> getStacks(MultiBlockGrid<?> grid) {
        if (grid instanceof GridItem) {
            return this.getItems((GridItem)grid);
        }
        if (grid instanceof GridFluid) {
            return this.getFluids((GridFluid)grid);
        }
        return null;
    }

    public ItemList getItems(GridItem grid) {
        this.refresh(grid);
        return this.items.getOrDefault(grid, new ItemList());
    }

    public FluidList getFluids(GridFluid grid) {
        this.refresh(grid);
        return this.fluids.getOrDefault(grid, new FluidList());
    }

    public <I> StackList<I> getMutatedStacks(MultiBlockGrid<?> grid) {
        if (grid instanceof GridItem) {
            return this.getMutatedItems((GridItem)grid);
        }
        if (grid instanceof GridFluid) {
            return this.getMutatedFluids((GridFluid)grid);
        }
        return null;
    }

    public ItemList getMutatedItems(GridItem grid) {
        this.itemsMutated.computeIfAbsent(grid, g -> {
            ItemList itemList = new ItemList();
            itemList.addAll(this.getItems(grid));
            return itemList;
        });
        return this.itemsMutated.get(grid);
    }

    public FluidList getMutatedFluids(GridFluid grid) {
        this.fluidsMutated.computeIfAbsent(grid, g -> {
            FluidList itemList = new FluidList();
            itemList.addAll(this.getFluids(grid));
            return itemList;
        });
        return this.fluidsMutated.get(grid);
    }

    public <I> StackList<I> getLeftovers(RequesterReference<I> reference) {
        this.leftoversMutated.computeIfAbsent(reference, ref -> {
            IRequester requester = reference.get();
            if (requester instanceof ICrafter) {
                return ((ICrafter)requester).getLeftovers().copy();
            }
            return EmptyList.getInstance();
        });
        return this.leftoversMutated.get(reference);
    }

    private <I> void applyLeftover(RequesterReference<I> reference, StackList<?> list) {
        ((ICrafter)reference.get()).applyLeftovers(list);
    }
}

