/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.container.guisync.GuiSync;
import appeng.helpers.InventoryAction;
import appeng.util.Platform;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.container.ContainerWT;
import p455w0rd.ae2wtlib.api.networking.security.WTIActionHost;
import p455w0rd.ae2wtlib.api.networking.security.WTPlayerSource;
import p455w0rd.wct.container.CraftingCPURecord;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wct.sync.packets.PacketSwitchGuis;

public class ContainerCraftConfirm
extends ContainerWT {
    public final ArrayList<CraftingCPURecord> cpus = new ArrayList();
    private int wctSlot = -1;
    private boolean isBauble = false;
    private Future<ICraftingJob> job;
    private ICraftingJob result;
    @GuiSync(value=0)
    public long bytesUsed;
    @GuiSync(value=1)
    public long cpuBytesAvail;
    @GuiSync(value=2)
    public int cpuCoProcessors;
    @GuiSync(value=3)
    public boolean autoStart = false;
    @GuiSync(value=4)
    public boolean simulation = true;
    @GuiSync(value=5)
    public int selectedCpu = -1;
    @GuiSync(value=6)
    public boolean noCPU = true;
    @GuiSync(value=7)
    public String myName = "";

    public ContainerCraftConfirm(InventoryPlayer ip, ITerminalHost te, boolean isBauble, int wctSlot) {
        super(ip, (Object)te, wctSlot, isBauble);
        this.isBauble = isBauble;
        this.wctSlot = wctSlot;
    }

    public void cycleCpu(boolean next) {
        if (next) {
            this.setSelectedCpu(this.getSelectedCpu() + 1);
        } else {
            this.setSelectedCpu(this.getSelectedCpu() - 1);
        }
        if (this.getSelectedCpu() < -1) {
            this.setSelectedCpu(this.cpus.size() - 1);
        } else if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
        }
        if (this.getSelectedCpu() == -1) {
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else {
            this.setName(this.cpus.get(this.getSelectedCpu()).getName());
            this.setCpuAvailableBytes(this.cpus.get(this.getSelectedCpu()).getSize());
            this.setCpuCoProcessors(this.cpus.get(this.getSelectedCpu()).getProcessors());
        }
    }

    public void func_75142_b() {
        if (Platform.isClient()) {
            return;
        }
        IGrid gr = this.getGrid();
        if (gr == null) {
            return;
        }
        ICraftingGrid cc = (ICraftingGrid)gr.getCache(ICraftingGrid.class);
        ImmutableSet cpuSet = cc.getCpus();
        int matches = 0;
        boolean changed = false;
        for (ICraftingCPU c : cpuSet) {
            boolean found = false;
            for (CraftingCPURecord ccr : this.cpus) {
                if (ccr.getCpu() != c) continue;
                found = true;
            }
            boolean matched = this.cpuMatches(c);
            if (matched) {
                ++matches;
            }
            if (found != !matched) continue;
            changed = true;
        }
        if (changed || this.cpus.size() != matches) {
            this.cpus.clear();
            for (ICraftingCPU c : cpuSet) {
                if (!this.cpuMatches(c)) continue;
                this.cpus.add(new CraftingCPURecord(c.getAvailableStorage(), c.getCoProcessors(), c));
            }
            this.sendCPUs();
        }
        this.setNoCPU(this.cpus.isEmpty());
        super.func_75142_b();
        if (this.getJob() != null && this.getJob().isDone()) {
            try {
                this.result = this.getJob().get();
                if (!this.result.isSimulation()) {
                    this.setSimulation(false);
                    if (this.isAutoStart()) {
                        this.startJob();
                        return;
                    }
                } else {
                    this.setSimulation(true);
                }
                try {
                    PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                    PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                    PacketMEInventoryUpdate c = this.result.isSimulation() ? new PacketMEInventoryUpdate(2) : null;
                    IItemList plan = ((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createList();
                    this.result.populatePlan(plan);
                    this.setUsedBytes(this.result.getByteTotal());
                    for (IAEItemStack out : plan) {
                        IAEItemStack o = out.copy();
                        o.reset();
                        o.setStackSize(out.getStackSize());
                        IAEItemStack p = out.copy();
                        p.reset();
                        p.setStackSize(out.getCountRequestable());
                        IStorageGrid sg = (IStorageGrid)this.getGrid().getCache(IStorageGrid.class);
                        IMEMonitor items = sg.getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                        IAEItemStack m = null;
                        if (c != null && this.result.isSimulation()) {
                            m = o.copy();
                            if ((o = (IAEItemStack)items.extractItems((IAEStack)o, Actionable.SIMULATE, this.getActionSource())) == null) {
                                o = m.copy();
                                o.setStackSize(0L);
                            }
                            m.setStackSize(m.getStackSize() - o.getStackSize());
                        }
                        if (o.getStackSize() > 0L) {
                            a.appendItem(o);
                        }
                        if (p.getStackSize() > 0L) {
                            b.appendItem(p);
                        }
                        if (c == null || m == null || m.getStackSize() <= 0L) continue;
                        c.appendItem(m);
                    }
                    for (Object g : this.field_75149_d) {
                        if (!(g instanceof EntityPlayer)) continue;
                        ModNetworking.instance().sendTo(a, (EntityPlayerMP)g);
                        ModNetworking.instance().sendTo(b, (EntityPlayerMP)g);
                        if (c == null) continue;
                        ModNetworking.instance().sendTo(c, (EntityPlayerMP)g);
                    }
                }
                catch (IOException a) {
                }
            }
            catch (Throwable e) {
                this.getPlayer().func_145747_a((ITextComponent)new TextComponentString("Error: " + e.toString()));
                this.setValidContainer(false);
                this.result = null;
            }
            this.setJob(null);
        }
        this.verifyPermissions(SecurityPermissions.CRAFT, false);
    }

    private IGrid getGrid() {
        WTIActionHost h = (WTIActionHost)this.getTarget();
        IGridNode an = h.getActionableNode(true);
        if (an != null) {
            return an.getGrid();
        }
        return null;
    }

    private boolean cpuMatches(ICraftingCPU c) {
        return c.getAvailableStorage() >= this.getUsedBytes() && !c.isBusy();
    }

    private void sendCPUs() {
        Collections.sort(this.cpus);
        if (this.getSelectedCpu() >= this.cpus.size()) {
            this.setSelectedCpu(-1);
            this.setCpuAvailableBytes(0L);
            this.setCpuCoProcessors(0);
            this.setName("");
        } else if (this.getSelectedCpu() != -1) {
            this.setName(this.cpus.get(this.getSelectedCpu()).getName());
            this.setCpuAvailableBytes(this.cpus.get(this.getSelectedCpu()).getSize());
            this.setCpuCoProcessors(this.cpus.get(this.getSelectedCpu()).getProcessors());
        }
    }

    public void startJob() {
        int originalGui = 0;
        WTIActionHost ah = ContainerCraftConfirm.getActionHost((Object)this.getGuiObject());
        if (ah instanceof WTGuiObject) {
            originalGui = 0;
        }
        if (this.result != null && !this.isSimulation()) {
            ICraftingGrid cc = (ICraftingGrid)this.getGrid().getCache(ICraftingGrid.class);
            ICraftingLink g = cc.submitJob(this.result, null, this.getSelectedCpu() == -1 ? null : this.cpus.get(this.getSelectedCpu()).getCpu(), true, this.getActionSrc());
            this.setAutoStart(false);
            if (g != null && originalGui == 0) {
                ModNetworking.instance().sendTo(new PacketSwitchGuis(originalGui), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                EntityPlayerMP player = (EntityPlayerMP)this.getInventoryPlayer().field_70458_d;
                World world = this.getWorld();
                int x = (int)player.field_70165_t;
                int y = (int)player.field_70163_u;
                int z = (int)player.field_70161_v;
                ModGuiHandler.open(originalGui, (EntityPlayer)player, world, new BlockPos(x, y, z), false, this.isBauble, this.wctSlot);
            }
        }
    }

    private IActionSource getActionSrc() {
        return new WTPlayerSource(this.getPlayerInv().field_70458_d, (WTIActionHost)this.getTarget());
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public void func_75134_a(EntityPlayer par1EntityPlayer) {
        super.func_75134_a(par1EntityPlayer);
        if (this.getJob() != null) {
            this.getJob().cancel(true);
            this.setJob(null);
        }
    }

    public World getWorld() {
        return this.getPlayer().func_130014_f_();
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public long getUsedBytes() {
        return this.bytesUsed;
    }

    private void setUsedBytes(long bytesUsed) {
        this.bytesUsed = bytesUsed;
    }

    public long getCpuAvailableBytes() {
        return this.cpuBytesAvail;
    }

    private void setCpuAvailableBytes(long cpuBytesAvail) {
        this.cpuBytesAvail = cpuBytesAvail;
    }

    public int getCpuCoProcessors() {
        return this.cpuCoProcessors;
    }

    private void setCpuCoProcessors(int cpuCoProcessors) {
        this.cpuCoProcessors = cpuCoProcessors;
    }

    public int getSelectedCpu() {
        return this.selectedCpu;
    }

    private void setSelectedCpu(int selectedCpu) {
        this.selectedCpu = selectedCpu;
    }

    public String getName() {
        return this.myName;
    }

    private void setName(@Nonnull String myName) {
        this.myName = myName;
    }

    public boolean hasNoCPU() {
        return this.noCPU;
    }

    private void setNoCPU(boolean noCPU) {
        this.noCPU = noCPU;
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    private void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    public Future<ICraftingJob> getJob() {
        return this.job;
    }

    public void setJob(Future<ICraftingJob> job) {
        this.job = job;
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
    }
}

