/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.sync;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import p455w0rd.wct.sync.WCTPacket;
import p455w0rd.wct.sync.packets.PacketCraftRequest;
import p455w0rd.wct.sync.packets.PacketCycleMagnetKeybind;
import p455w0rd.wct.sync.packets.PacketInventoryAction;
import p455w0rd.wct.sync.packets.PacketJEIRecipe;
import p455w0rd.wct.sync.packets.PacketMEInventoryUpdate;
import p455w0rd.wct.sync.packets.PacketMagnetFilterHeld;
import p455w0rd.wct.sync.packets.PacketMagnetFilterWCT;
import p455w0rd.wct.sync.packets.PacketOpenGui;
import p455w0rd.wct.sync.packets.PacketSetMagnetHeld;
import p455w0rd.wct.sync.packets.PacketSetMagnetWCT;
import p455w0rd.wct.sync.packets.PacketSetShiftCraft;
import p455w0rd.wct.sync.packets.PacketSwapSlots;
import p455w0rd.wct.sync.packets.PacketSwitchGuis;
import p455w0rd.wct.sync.packets.PacketTargetItemStack;
import p455w0rd.wct.sync.packets.PacketValueConfig;

public class WCTPacketHandlerBase {
    private static final Map<Class<? extends WCTPacket>, PacketTypes> REVERSE_LOOKUP = new HashMap<Class<? extends WCTPacket>, PacketTypes>();

    public static enum PacketTypes {
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_ME_INVENTORY_UPDATE(PacketMEInventoryUpdate.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_SWITCH_GUIS(PacketSwitchGuis.class),
        PACKET_SWAP_SLOTS(PacketSwapSlots.class),
        PACKET_RECIPE_NEI(PacketJEIRecipe.class),
        PACKET_TARGET_ITEM(PacketTargetItemStack.class),
        PACKET_CRAFTING_REQUEST(PacketCraftRequest.class),
        PACKET_MAGNETFILTER_MODE_HELD(PacketMagnetFilterHeld.class),
        PACKET_MAGNETFILTER_MODE_WCT(PacketMagnetFilterWCT.class),
        PACKET_OPENGUI(PacketOpenGui.class),
        PACKET_SWITCHMAGNETMODE_HELD(PacketSetMagnetHeld.class),
        PACKET_SWITCHMAGNETMODE_WCT(PacketSetMagnetWCT.class),
        PACKET_CYCLEMAGNETMODE_KEYBIND(PacketCycleMagnetKeybind.class),
        PACKET_SHIFTCRAFT(PacketSetShiftCraft.class);

        private final Class<? extends WCTPacket> packetClass;
        private final Constructor<? extends WCTPacket> packetConstructor;

        private PacketTypes(Class<? extends WCTPacket> c) {
            this.packetClass = c;
            Constructor<? extends WCTPacket> x = null;
            try {
                x = this.packetClass.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
            this.packetConstructor = x;
            REVERSE_LOOKUP.put(this.packetClass, this);
            if (this.packetConstructor == null) {
                throw new IllegalStateException("Invalid Packet Class " + c + ", must be constructable on DataInputStream");
            }
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        static PacketTypes getID(Class<? extends WCTPacket> c) {
            return (PacketTypes)((Object)REVERSE_LOOKUP.get(c));
        }

        public WCTPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.packetConstructor.newInstance(in);
        }
    }
}

