/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wpt.sync.packets;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.networking.storage.IStorageGrid;
import appeng.helpers.IContainerCraftingPacket;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.WrapperInvItemHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.IItemHandler;
import p455w0rd.ae2wtlib.api.networking.INetworkInfo;
import p455w0rd.wpt.container.ContainerWPT;
import p455w0rd.wpt.sync.WPTPacket;

public class PacketJEIPatternRecipe
extends WPTPacket {
    NBTTagCompound input;
    NBTTagCompound output;

    public PacketJEIPatternRecipe(ByteBuf stream) {
        this.input = ByteBufUtils.readTag((ByteBuf)stream);
        if (stream.readBoolean()) {
            this.output = ByteBufUtils.readTag((ByteBuf)stream);
        }
    }

    public PacketJEIPatternRecipe(@Nonnull NBTTagCompound input, @Nullable NBTTagCompound output) {
        this.input = input;
        this.output = output;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)input);
        if (output != null) {
            data.writeBoolean(true);
            ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)output);
        } else {
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, WPTPacket packet, EntityPlayer player) {
        Container con = player.field_71070_bA;
        ItemStack[] recipe = new ItemStack[9];
        ItemStack[] recipeOutput = null;
        for (int i = 0; i < recipe.length; ++i) {
            NBTTagCompound currentStack = (NBTTagCompound)this.input.func_74781_a("#" + i);
            recipe[i] = currentStack == null ? ItemStack.field_190927_a : new ItemStack(currentStack);
        }
        if (this.output != null) {
            recipeOutput = new ItemStack[3];
            NBTTagList outputList = this.output.func_150295_c("Outputs", 10);
            for (int i = 0; i < recipeOutput.length; ++i) {
                recipeOutput[i] = new ItemStack(outputList.func_150305_b(i));
            }
        }
        if (con instanceof IContainerCraftingPacket && con instanceof ContainerWPT) {
            IActionHost obj;
            IContainerCraftingPacket cct = (IContainerCraftingPacket)con;
            IGridNode node = cct.getNetworkNode();
            if (node == null && (obj = (IActionHost)cct.getActionSource().machine().get()) != null) {
                node = obj.getActionableNode();
            }
            if (node != null) {
                IGrid grid = node.getGrid();
                if (grid == null) {
                    return;
                }
                IStorageGrid inv = (IStorageGrid)grid.getCache(IStorageGrid.class);
                ISecurityGrid security = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
                IItemHandler craftMatrix = cct.getInventoryByName("crafting");
                if (inv != null && recipe != null && security != null) {
                    for (int i = 0; i < craftMatrix.getSlots(); ++i) {
                        ItemStack currentItem = ItemStack.field_190927_a;
                        if (recipe[i] != null) {
                            currentItem = recipe[i].func_77946_l();
                        }
                        ItemHandlerUtil.setStackInSlot((IItemHandler)craftMatrix, (int)i, (ItemStack)currentItem);
                    }
                    if (recipeOutput == null) {
                        con.func_75130_a((IInventory)new WrapperInvItemHandler(craftMatrix));
                    }
                }
                if (recipeOutput != null && !((ContainerWPT)con).isCraftingMode()) {
                    IItemHandler outputInv = cct.getInventoryByName("output");
                    for (int i = 0; i < recipeOutput.length; ++i) {
                        ItemHandlerUtil.setStackInSlot((IItemHandler)outputInv, (int)i, (ItemStack)recipeOutput[i]);
                    }
                }
            }
        }
    }
}

