/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.init;

import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RAEquipment;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thundr.redstonerepository.RedstoneRepository;
import thundr.redstonerepository.item.ItemMaterial;
import thundr.redstonerepository.item.armor.ItemArmorGelid;
import thundr.redstonerepository.item.tool.ItemAxeGelid;
import thundr.redstonerepository.item.tool.ItemBattleWrenchGelid;
import thundr.redstonerepository.item.tool.ItemBowGelid;
import thundr.redstonerepository.item.tool.ItemExcavatorGelid;
import thundr.redstonerepository.item.tool.ItemFishingRodGelid;
import thundr.redstonerepository.item.tool.ItemHammerGelid;
import thundr.redstonerepository.item.tool.ItemPickaxeGelid;
import thundr.redstonerepository.item.tool.ItemShieldGelid;
import thundr.redstonerepository.item.tool.ItemShovelGelid;
import thundr.redstonerepository.item.tool.ItemSickleGelid;
import thundr.redstonerepository.item.tool.ItemSwordGelid;
import thundr.redstonerepository.item.tool.ItemWrenchGelid;
import thundr.redstonerepository.item.util.ItemCapacitorAmulet;
import thundr.redstonerepository.item.util.ItemFeeder;
import thundr.redstonerepository.item.util.ItemRingBase;
import thundr.redstonerepository.item.util.ItemRingEffect;
import thundr.redstonerepository.item.util.ItemRingMining;

public class RedstoneRepositoryEquipment {
    public static final RedstoneRepositoryEquipment INSTANCE = new RedstoneRepositoryEquipment();
    public static EquipmentInit equipInit;
    public static ItemArmor.ArmorMaterial ARMOR_MATERIAL_GELID;
    public static Item.ToolMaterial TOOL_MATERIAL_GELID;

    private RedstoneRepositoryEquipment() {
    }

    public static void preInit() {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.preInit();
            RedstoneRepository.PROXY.addIModelRegister(armorSet);
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).preInit();
            RedstoneRepository.PROXY.addIModelRegister((IModelRegister)enum_);
        }
        equipInit = new EquipmentInit();
        equipInit.preInit();
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.initialize();
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).initialize();
        }
        equipInit.initialize();
    }

    static {
        int helmet = 3;
        int chestplate = 8;
        int leggings = 6;
        int boots = 3;
        int harvestLevel = 4;
        float efficiency = 8.0f;
        String category = "Equipment.Armor";
        String comment = "Adjust this value to set the default protection provided by the Gelid Enderium Helmet.";
        helmet = RedstoneRepository.CONFIG_COMMON.getConfiguration().getInt("HelmetProtection", category, helmet, 1, 10, comment);
        comment = "Adjust this value to set the default protection provided by the Gelid Enderium Chestplate.";
        chestplate = RedstoneRepository.CONFIG_COMMON.getConfiguration().getInt("ChestplateProtection", category, chestplate, 1, 10, comment);
        comment = "Adjust this value to set the default protection provided by the Gelid Enderium Leggings.";
        leggings = RedstoneRepository.CONFIG_COMMON.getConfiguration().getInt("LeggingsProtection", category, leggings, 1, 10, comment);
        comment = "Adjust this value to set the default protection provided by the Gelid Enderium Boots.";
        boots = RedstoneRepository.CONFIG_COMMON.getConfiguration().getInt("BootsProtection", category, boots, 1, 10, comment);
        category = "Equipment.Tools";
        comment = "Adjust this value to set the default harvest level of Gelid Enderium Tools.";
        harvestLevel = RedstoneRepository.CONFIG_COMMON.getConfiguration().getInt("HarvestLevel", category, harvestLevel, 0, 10, comment);
        comment = "Adjust this value to set the default efficiency (mining speed) of Gelid Enderium Tools";
        efficiency = RedstoneRepository.CONFIG_COMMON.getConfiguration().getFloat("Efficiency", category, efficiency, 2.0f, 32.0f, comment);
        ARMOR_MATERIAL_GELID = EnumHelper.addArmorMaterial((String)"RR:GELIDENDERIUM", (String)"gelid_armor", (int)100, (int[])new int[]{boots, leggings, chestplate, helmet}, (int)20, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
        TOOL_MATERIAL_GELID = EnumHelper.addToolMaterial((String)"RR:GELIDENDERIUM", (int)harvestLevel, (int)100, (float)efficiency, (float)0.0f, (int)25);
    }

    public static class EquipmentInit
    implements IInitializer,
    IModelRegister {
        @GameRegistry.ItemStackHolder(value="thermalexpansion:capacitor", meta=4)
        public static final ItemStack resonantCapacitor = null;
        public static ItemFeeder itemFeeder;
        public static ItemCapacitorAmulet itemCapacitorAmulet;
        public static ItemRingBase itemBaseRing;
        public static ItemRingEffect itemEffectRing;
        public static ItemRingMining itemMiningRing;
        public static ItemStack capacitorAmuletGelid;
        public static ItemStack feederStack;
        public static ItemStack baseRingStack;
        public static ItemStack effectRingStack;
        public static ItemStack miningRingStack;
        public static ItemStack mushroomStewBucket;
        public static boolean[] enable;
        public static int capacity;
        public static int transfer;
        public static int hungerPointsMax;
        public static int feederCapacity;
        public static int feederMaxTransfer;
        public static int feederEnergyPerUse;
        public static int feederMaxSat;
        public static int cooldownThreshold;
        public static int cooldownDuration;
        public static int powerMultiplier;
        public static int effectRingTransfer;
        public static int effectRingCapacity;

        public boolean preInit() {
            this.config();
            itemCapacitorAmulet = new ItemCapacitorAmulet(capacity, transfer);
            itemCapacitorAmulet.func_77655_b("redstonerepository.util.gelidCapacitor").func_77637_a(RedstoneRepository.tabCommon);
            itemCapacitorAmulet.setRegistryName("util.capacitor_gelid");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemCapacitorAmulet);
            capacitorAmuletGelid = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)itemCapacitorAmulet), (int)0);
            itemFeeder = new ItemFeeder(hungerPointsMax, feederCapacity, feederMaxTransfer, feederEnergyPerUse, feederMaxSat);
            itemFeeder.func_77655_b("redstonerepository.util.feeder").func_77637_a(RedstoneRepository.tabCommon);
            itemFeeder.setRegistryName("util.feeder");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemFeeder);
            feederStack = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)itemFeeder), (int)0);
            itemBaseRing = new ItemRingBase();
            itemBaseRing.func_77655_b("redstonerepository.util.ring.base").func_77637_a(RedstoneRepository.tabCommon);
            itemBaseRing.setRegistryName("util.ring_base");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBaseRing);
            baseRingStack = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)itemBaseRing), (int)0);
            itemEffectRing = new ItemRingEffect(cooldownThreshold, cooldownDuration, powerMultiplier, effectRingTransfer, effectRingCapacity);
            itemEffectRing.func_77655_b("redstonerepository.util.ring.effect").func_77637_a(RedstoneRepository.tabCommon);
            itemEffectRing.setRegistryName("util.ring_effect");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemEffectRing);
            effectRingStack = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)itemEffectRing), (int)0);
            itemMiningRing = new ItemRingMining();
            itemMiningRing.func_77655_b("redstonerepository.util.ring.mining").func_77637_a(RedstoneRepository.tabCommon);
            itemMiningRing.setRegistryName("util.ring_mining");
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemMiningRing);
            miningRingStack = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)itemMiningRing), (int)0);
            RedstoneRepository.PROXY.addIModelRegister(this);
            return true;
        }

        public void config() {
            boolean enableConfig = RedstoneRepository.CONFIG_COMMON.get("Item.Capacitor", "Enable", true, "Enable the Gelid Capacitor Amulet");
            boolean enableLoaded = Loader.isModLoaded((String)"baubles");
            EquipmentInit.enable[0] = enableConfig && enableLoaded;
            transfer = RedstoneRepository.CONFIG_COMMON.get("Item.Capacitor", "BaseTransfer", 100000, "Set the base transfer rate of the Gelid Capacitor Amulet in RF/t (Default 100,000) ");
            capacity = RedstoneRepository.CONFIG_COMMON.get("Item.Capacitor", "BaseCapacity", 100000000, "Set the base capacity of the Gelid Capacitor Amulet in RF/t (Default 100,000,000) ");
            boolean enableFeederConfig = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "Enable", true, "Enable the Endoscopic Gastrostomizer (Automatic Feeder)");
            EquipmentInit.enable[1] = enableFeederConfig && enableLoaded;
            hungerPointsMax = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "MaxHungerPoints", 500, "Set the maximum hunger point storage of the Endoscopic Gastrostomizer (EG) (Default 500)");
            feederCapacity = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "BaseCapacity", 4000000, "Set the base capacity of the E.G. in RF (Default 4,000,000) ");
            feederMaxTransfer = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "MaxTransfer", 8000, "Set the maximum transfer rate into the item in RF/t (Default 8000)");
            feederEnergyPerUse = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "EnergyPerUse", 30000, "Set amount of energy used per food point in RF (Default 3000)");
            feederMaxSat = RedstoneRepository.CONFIG_COMMON.get("Item.Feeder", "SaturationFillLevel", 5, "Maximum amount of hunger saturation to automatically fill to. Higher numbers consume hunger points more quickly. (Default 5, Max 20)");
            boolean enableEffectRingConfig = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "Enable", true, "Enable the Cryotheum Stasis Ring");
            EquipmentInit.enable[2] = enableEffectRingConfig && enableLoaded;
            cooldownThreshold = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "CooldownThreshold", 100, "Set how many ticks the ring must be worn before it can be removed without causing a cooldown. (Default 100)");
            cooldownDuration = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "CooldownDuration", 1200, "Set how many ticks the ring's cooldown lasts for. (Default 1200)");
            powerMultiplier = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "PowerMultiplier", 1, "Set the multiplier for power usage. Be careful with this, it can get insane fast. (Default 1)");
            effectRingTransfer = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "Transfer", 500000, "Set RF/T transfer rate maximum. (Default 500,000)");
            effectRingCapacity = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Effect", "Capacity", 4000000, "Set RF capacity. (Default 4,000,000)");
            boolean enableMiningRingConfig = RedstoneRepository.CONFIG_COMMON.get("Item.Ring.Mining", "Enable", true, "Enable the Mining Stabilization Ring");
            EquipmentInit.enable[3] = enableMiningRingConfig && enableLoaded;
        }

        public boolean initialize() {
            mushroomStewBucket = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)"mushroom_stew", (int)1000));
            if (enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)capacitorAmuletGelid, (Object[])new Object[]{" S ", "ACA", "AGA", Character.valueOf('S'), ItemMaterial.stringFluxed, Character.valueOf('A'), ItemMaterial.plateArmorGelidEnderium, Character.valueOf('G'), ItemMaterial.ingotGelidEnderium, Character.valueOf('C'), resonantCapacitor});
            }
            if (enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)feederStack, (Object[])new Object[]{"SCS", "PMP", " G ", Character.valueOf('S'), ItemMaterial.stringFluxed, Character.valueOf('C'), resonantCapacitor, Character.valueOf('M'), mushroomStewBucket, Character.valueOf('P'), ItemMaterial.plateGelidEnderium, Character.valueOf('G'), ItemMaterial.gearGelidEnderium});
            }
            if (enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)effectRingStack, (Object[])new Object[]{"GMP", "NBN", "LSR", Character.valueOf('B'), baseRingStack, Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('G'), Items.field_151073_bk, Character.valueOf('M'), Items.field_151064_bs, Character.valueOf('P'), Items.field_151065_br, Character.valueOf('L'), Items.field_151060_bw, Character.valueOf('S'), Items.field_151071_bq, Character.valueOf('R'), Items.field_179556_br});
            }
            if (enable[3]) {
                ItemStack aerotheumBucket = FluidUtil.getFilledBucket((FluidStack)FluidRegistry.getFluidStack((String)"aerotheum", (int)1000));
                RecipeHelper.addShapedRecipe((ItemStack)miningRingStack, (Object[])new Object[]{" E ", " B ", "FGF", Character.valueOf('B'), baseRingStack, Character.valueOf('E'), Items.field_185160_cR, Character.valueOf('F'), Items.field_151008_G, Character.valueOf('G'), aerotheumBucket});
            }
            RecipeHelper.addShapedRecipe((ItemStack)baseRingStack, (Object[])new Object[]{" I ", "I I", " G ", Character.valueOf('G'), ItemMaterial.gemGelidCrystal, Character.valueOf('I'), ItemMaterial.ingotGelidEnderium});
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            ModelLoader.setCustomModelResourceLocation((Item)itemCapacitorAmulet, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "util/capacitor_gelid"), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemFeeder, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "util/feeder"), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemBaseRing, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "util/ring_base"), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemEffectRing, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "util/ring_effect"), "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)itemMiningRing, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "util/ring_mining"), "inventory"));
        }

        static {
            enable = new boolean[5];
        }
    }

    public static enum ToolSet implements IModelRegister
    {
        GELID("gelid", TOOL_MATERIAL_GELID);

        private final String name;
        private final Item.ToolMaterial TOOL_MATERIAL;
        public ItemBattleWrenchGelid itemBattleWrench;
        public ItemSwordGelid itemSword;
        public ItemShovelGelid itemShovel;
        public ItemPickaxeGelid itemPickaxe;
        public ItemAxeGelid itemAxe;
        public ItemSickleGelid itemSickle;
        public ItemBowGelid itemBow;
        public ItemShieldGelid itemShield;
        public ItemHammerGelid itemHammer;
        public ItemExcavatorGelid itemExcavator;
        public ItemFishingRodGelid itemFishingRod;
        public ItemWrenchGelid itemWrench;
        public ItemStack toolBattleWrench;
        public ItemStack toolSword;
        public ItemStack toolShovel;
        public ItemStack toolPickaxe;
        public ItemStack toolAxe;
        public ItemStack toolSickle;
        public ItemStack toolBow;
        public ItemStack toolShield;
        public ItemStack toolHammer;
        public ItemStack toolExcavator;
        public ItemStack toolFishingRod;
        public ItemStack toolWrench;
        private float arrowDamage = 0.5f;
        private float arrowSpeed = 0.5f;
        private float zoomMultiplier = 0.35f;
        private int luckModifier = 1;
        private int speedModifier = 1;
        public int axeBlocksCutPerTick;
        public boolean[] enable = new boolean[12];

        private ToolSet(String name, Item.ToolMaterial material) {
            this.name = name.toLowerCase(Locale.US);
            this.TOOL_MATERIAL = material;
        }

        protected void create() {
            this.itemBattleWrench = new ItemBattleWrenchGelid(this.TOOL_MATERIAL);
            this.itemSword = new ItemSwordGelid(this.TOOL_MATERIAL);
            this.itemShovel = new ItemShovelGelid(this.TOOL_MATERIAL);
            this.itemPickaxe = new ItemPickaxeGelid(this.TOOL_MATERIAL);
            this.itemAxe = new ItemAxeGelid(this.TOOL_MATERIAL, this.axeBlocksCutPerTick);
            this.itemSickle = new ItemSickleGelid(this.TOOL_MATERIAL);
            this.itemBow = new ItemBowGelid(this.TOOL_MATERIAL);
            this.itemShield = new ItemShieldGelid(this.TOOL_MATERIAL);
            this.itemHammer = new ItemHammerGelid(this.TOOL_MATERIAL);
            this.itemExcavator = new ItemExcavatorGelid(this.TOOL_MATERIAL);
            this.itemFishingRod = new ItemFishingRodGelid(this.TOOL_MATERIAL);
            this.itemWrench = new ItemWrenchGelid(this.TOOL_MATERIAL);
        }

        protected void config() {
            this.axeBlocksCutPerTick = RedstoneRepository.CONFIG_COMMON.getConfiguration().get("Equipment.Tools.Axe", "BlocksPerTick", 3, "Sets the number of blocks per tick the axe attempts to cut in empowered mode. Higher values cause more lag. ").setMinValue(0).setMaxValue(10).getInt();
        }

        protected void preInit() {
            String TOOL = "redstonerepository.tool." + this.name;
            String category = "Equipment.Tools." + StringHelper.titleCase((String)this.name);
            this.enable[0] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "BattleWrench", true).getBoolean(true);
            this.enable[1] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Sword", true).getBoolean(true);
            this.enable[2] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Shovel", true).getBoolean(true);
            this.enable[3] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Pickaxe", true).getBoolean(true);
            this.enable[4] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Axe", true).getBoolean(true);
            this.enable[5] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Sickle", true).getBoolean(true);
            this.enable[6] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Bow", true).getBoolean(true);
            this.enable[7] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Shield", true).getBoolean(true);
            this.enable[8] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Hammer", true).getBoolean(true);
            this.enable[9] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Excavator", true).getBoolean(true);
            this.enable[10] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "FishingRod", true).getBoolean(true);
            this.enable[11] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Wrench", true).getBoolean(true);
            this.config();
            this.create();
            this.itemBattleWrench.func_77655_b(TOOL + "BattleWrench").func_77637_a(RedstoneRepository.tabCommon);
            this.itemBattleWrench.setShowInCreative(this.enable[0]);
            this.itemBattleWrench.setRegistryName("tool.battlewrench_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemBattleWrench);
            this.itemSword.func_77655_b(TOOL + "Sword").func_77637_a(RedstoneRepository.tabCommon);
            this.itemSword.setShowInCreative(this.enable[1]);
            this.itemSword.setRegistryName("tool.sword_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSword);
            this.itemShovel.func_77655_b(TOOL + "Shovel").func_77637_a(RedstoneRepository.tabCommon);
            this.itemShovel.setShowInCreative(this.enable[2]);
            this.itemShovel.setRegistryName("tool.shovel_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShovel);
            this.itemPickaxe.func_77655_b(TOOL + "Pickaxe").func_77637_a(RedstoneRepository.tabCommon);
            this.itemPickaxe.setShowInCreative(this.enable[3]);
            this.itemPickaxe.setRegistryName("tool.pickaxe_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemPickaxe);
            this.itemAxe.func_77655_b(TOOL + "Axe").func_77637_a(RedstoneRepository.tabCommon);
            this.itemAxe.setShowInCreative(this.enable[4]);
            this.itemAxe.setRegistryName("tool.axe_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemAxe);
            this.itemSickle.func_77655_b(TOOL + "Sickle").func_77637_a(RedstoneRepository.tabCommon);
            this.itemSickle.setShowInCreative(this.enable[5]);
            this.itemSickle.setRegistryName("tool.sickle_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemSickle);
            this.itemBow.func_77655_b(TOOL + "Bow").func_77637_a(RedstoneRepository.tabCommon);
            this.itemBow.setShowInCreative(this.enable[6]);
            this.itemBow.setRegistryName("tool.bow_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemBow);
            this.itemShield.func_77655_b(TOOL + "Shield").func_77637_a(RedstoneRepository.tabCommon);
            this.itemShield.setShowInCreative(this.enable[7]);
            this.itemShield.setRegistryName("tool.shield_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemShield);
            this.itemHammer.func_77655_b(TOOL + "Hammer").func_77637_a(RedstoneRepository.tabCommon);
            this.itemHammer.setShowInCreative(this.enable[8]);
            this.itemHammer.setRegistryName("tool.hammer_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHammer);
            this.itemExcavator.func_77655_b(TOOL + "Excavator").func_77637_a(RedstoneRepository.tabCommon);
            this.itemExcavator.setShowInCreative(this.enable[9]);
            this.itemExcavator.setRegistryName("tool.excavator_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemExcavator);
            this.itemFishingRod.func_77655_b(TOOL + "FishingRod").func_77637_a(RedstoneRepository.tabCommon);
            this.itemFishingRod.setShowInCreative(this.enable[10]);
            this.itemFishingRod.setRegistryName("tool.fishing_rod_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemFishingRod);
            this.itemWrench.func_77655_b(TOOL + "Wrench").func_77637_a(RedstoneRepository.tabCommon);
            this.itemWrench.setShowInCreative(this.enable[11]);
            this.itemWrench.setRegistryName("tool.wrench_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemWrench);
            this.toolBattleWrench = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBattleWrench), (int)0);
            this.toolSword = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemSword), (int)0);
            this.toolShovel = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemShovel), (int)0);
            this.toolPickaxe = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemPickaxe), (int)0);
            this.toolAxe = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemAxe), (int)0);
            this.toolSickle = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemSickle), (int)0);
            this.toolBow = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBow), (int)0);
            this.toolShield = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemShield), (int)0);
            this.toolHammer = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemHammer), (int)0);
            this.toolExcavator = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemExcavator), (int)0);
            this.toolFishingRod = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemFishingRod), (int)0);
            this.toolWrench = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemWrench), (int)0);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolBattleWrench, (Object[])new Object[]{"IWI", " G ", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('G'), "gearGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('W'), RAEquipment.ToolSet.FLUX.itemBattleWrench});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSword, (Object[])new Object[]{" I ", " S ", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemSword});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShovel, (Object[])new Object[]{" I ", " S ", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemShovel});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolPickaxe, (Object[])new Object[]{"III", " P ", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('P'), RAEquipment.ToolSet.FLUX.itemPickaxe});
            }
            if (this.enable[4]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolAxe, (Object[])new Object[]{"II ", "IA ", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('A'), RAEquipment.ToolSet.FLUX.itemAxe});
            }
            if (this.enable[5]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", " SI", "RI ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemSickle});
            }
            if (this.enable[6]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" IX", "RSX", " IX", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemBow, Character.valueOf('X'), "stringFluxed"});
            }
            if (this.enable[7]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolShield, (Object[])new Object[]{"IGI", "ISI", " I ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('G'), ItemMaterial.gemGelidCrystal, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemShield});
            }
            if (this.enable[8]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolHammer, (Object[])new Object[]{"III", "ISI", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemHammer});
            }
            if (this.enable[9]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolExcavator, (Object[])new Object[]{" I ", "ISI", " R ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemExcavator});
            }
            if (this.enable[10]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " SX", "R X", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemFishingRod, Character.valueOf('X'), "stringFluxed"});
            }
            if (this.enable[11]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.toolWrench, (Object[])new Object[]{"ISI", " R ", " I ", Character.valueOf('I'), "ingotGelidEnderium", Character.valueOf('R'), ItemMaterial.rodGelidObsidian, Character.valueOf('S'), RAEquipment.ToolSet.FLUX.itemWrench});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "tool/" + stackName), "inventory"));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemBattleWrench, "battle_wrench_" + this.name);
            this.registerModel((Item)this.itemSword, "sword_" + this.name);
            this.registerModel((Item)this.itemShovel, "shovel_" + this.name);
            this.registerModel((Item)this.itemPickaxe, "pickaxe_" + this.name);
            this.registerModel((Item)this.itemAxe, "axe_" + this.name);
            this.registerModel((Item)this.itemSickle, "sickle_" + this.name);
            this.registerModel((Item)this.itemBow, "bow_" + this.name);
            this.registerModel((Item)this.itemShield, "shield_" + this.name);
            this.registerModel((Item)this.itemHammer, "hammer_" + this.name);
            this.registerModel((Item)this.itemExcavator, "excavator_" + this.name);
            this.registerModel((Item)this.itemFishingRod, "fishing_rod_" + this.name);
            this.registerModel((Item)this.itemWrench, "wrench_" + this.name);
        }
    }

    public static enum ArmorSet implements IModelRegister
    {
        GELID("gelid", ARMOR_MATERIAL_GELID);

        private final String name;
        private final ItemArmor.ArmorMaterial ARMOR_MATERIAL;
        public ItemArmorGelid itemHelmet;
        public ItemArmorGelid itemChestplate;
        public ItemArmorGelid itemLeggings;
        public ItemArmorGelid itemBoots;
        public ItemStack armorHelmet;
        public ItemStack armorChestplate;
        public ItemStack armorLeggings;
        public ItemStack armorBoots;
        public boolean[] enable = new boolean[4];

        private ArmorSet(String name, ItemArmor.ArmorMaterial material) {
            this.name = name.toLowerCase(Locale.US);
            this.ARMOR_MATERIAL = material;
        }

        protected void create() {
            this.itemHelmet = new ItemArmorGelid(this.ARMOR_MATERIAL, EntityEquipmentSlot.HEAD);
            this.itemChestplate = new ItemArmorGelid(this.ARMOR_MATERIAL, EntityEquipmentSlot.CHEST);
            this.itemLeggings = new ItemArmorGelid(this.ARMOR_MATERIAL, EntityEquipmentSlot.LEGS);
            this.itemBoots = new ItemArmorGelid(this.ARMOR_MATERIAL, EntityEquipmentSlot.FEET);
        }

        protected void preInit() {
            String ARMOR = "redstonerepository.armor." + this.name;
            String PATH_ARMOR = "redstonerepository:textures/models/armor/";
            String[] TEXTURE = new String[]{"redstonerepository:textures/models/armor/" + this.name + "_1.png", "redstonerepository:textures/models/armor/" + this.name + "_2.png"};
            String category = "Equipment.Armor." + StringHelper.titleCase((String)this.name);
            this.enable[0] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Helmet", true).getBoolean(true);
            this.enable[1] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Chestplate", true).getBoolean(true);
            this.enable[2] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Leggings", true).getBoolean(true);
            this.enable[3] = RedstoneRepository.CONFIG_COMMON.getConfiguration().get(category, "Boots", true).getBoolean(true);
            this.create();
            this.itemHelmet.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Helmet").func_77637_a(RedstoneRepository.tabCommon);
            this.itemHelmet.setShowInCreative(this.enable[0]);
            this.itemHelmet.setRegistryName("armor.helmet_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemHelmet);
            this.itemChestplate.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Chestplate").func_77637_a(RedstoneRepository.tabCommon);
            this.itemChestplate.setShowInCreative(this.enable[1]);
            this.itemChestplate.setRegistryName("armor.chestplate" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemChestplate);
            this.itemLeggings.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Leggings").func_77637_a(RedstoneRepository.tabCommon);
            this.itemLeggings.setShowInCreative(this.enable[2]);
            this.itemLeggings.setRegistryName("armor.leggings_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemLeggings);
            this.itemBoots.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Boots").func_77637_a(RedstoneRepository.tabCommon);
            this.itemBoots.setShowInCreative(this.enable[3]);
            this.itemBoots.setRegistryName("armor.boots_" + this.name);
            ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this.itemBoots);
            this.armorHelmet = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemHelmet), (int)0);
            this.armorChestplate = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemChestplate), (int)0);
            this.armorLeggings = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemLeggings), (int)0);
            this.armorBoots = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBoots), (int)0);
        }

        protected void initialize() {
            if (this.enable[0]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorHelmet, (Object[])new Object[]{"III", "IAI", Character.valueOf('I'), ItemMaterial.plateArmorGelidEnderium, Character.valueOf('A'), RAEquipment.ArmorSet.FLUX.itemHelmet});
            }
            if (this.enable[1]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorChestplate, (Object[])new Object[]{"IAI", "III", "III", Character.valueOf('I'), ItemMaterial.plateArmorGelidEnderium, Character.valueOf('A'), RAEquipment.ArmorSet.FLUX.itemPlate});
            }
            if (this.enable[2]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorLeggings, (Object[])new Object[]{"III", "IAI", "I I", Character.valueOf('I'), ItemMaterial.plateArmorGelidEnderium, Character.valueOf('A'), RAEquipment.ArmorSet.FLUX.itemLegs});
            }
            if (this.enable[3]) {
                RecipeHelper.addShapedRecipe((ItemStack)this.armorBoots, (Object[])new Object[]{"IAI", "I I", Character.valueOf('I'), ItemMaterial.plateArmorGelidEnderium, Character.valueOf('A'), RAEquipment.ArmorSet.FLUX.itemBoots});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("redstonerepository", "armor"), "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemHelmet, "helmet_" + this.name);
            this.registerModel((Item)this.itemChestplate, "chestplate_" + this.name);
            this.registerModel((Item)this.itemLeggings, "leggings_" + this.name);
            this.registerModel((Item)this.itemBoots, "boots_" + this.name);
        }
    }
}

