/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.item.tool;

import cofh.redstonearsenal.item.tool.ItemAxeFlux;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thundr.redstonerepository.item.GelidEnderiumEnergy;

public class ItemAxeGelid
extends ItemAxeFlux {
    public static final int LIGHTNING_ENERGY = 6400;
    public static final int EMPOWERED_LIGHTNING_ENERGY = 48000;
    public static int blocksPerTick;

    public ItemAxeGelid(Item.ToolMaterial toolMaterial, int axeBlocksCutPerTick) {
        super(toolMaterial);
        this.maxEnergy = GelidEnderiumEnergy.maxEnergy;
        this.energyPerUse = GelidEnderiumEnergy.energyPerUse;
        this.energyPerUseCharged = GelidEnderiumEnergy.energyPerUseCharged;
        this.maxTransfer = GelidEnderiumEnergy.maxTransfer;
        this.damage = 10;
        blocksPerTick = axeBlocksCutPerTick;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        Random rand = new Random();
        ItemStack held = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && this.isEmpowered(held) && (world.func_72896_J() || world.func_72911_I())) {
            WorldInfo worldinfo = world.func_72912_H();
            int i = 300 + rand.nextInt(600) * 20;
            worldinfo.func_76084_b(false);
            worldinfo.func_76069_a(false);
            worldinfo.func_76080_g(i);
            world.func_72838_d((Entity)new EntityLightningBolt(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, true));
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(held, false);
            }
        }
        player.func_184609_a(EnumHand.MAIN_HAND);
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack held = player.func_184586_b(hand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.getEnergyStored(held) > 6400) {
            if (!this.isEmpowered(held)) {
                world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z, false));
                if (!player.field_71075_bZ.field_75098_d) {
                    this.extractEnergy(held, 6400, false);
                }
            } else if (this.isEmpowered(held) && this.getEnergyStored(held) >= 48000) {
                for (int i = 0; i <= 10; ++i) {
                    world.func_72838_d((Entity)new EntityLightningBolt(world, (double)x, (double)y, (double)z, false));
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    this.extractEnergy(held, 48000, false);
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        Block block = state.func_177230_c();
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f && this.isEmpowered(stack) && block.isWood((IBlockAccess)world, pos) && this.canHarvestBlock(state, stack)) {
            if (!world.field_72995_K) {
                MinecraftForge.EVENT_BUS.register((Object)new CutTreeTask(stack, pos, player));
            }
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("\u00a7aRight click a block to call down the power of the sky.");
        tooltip.add("\u00a7aRight click the air to clear the skies when empowered.");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 1333581;
    }

    protected boolean harvestBlock(World world, BlockPos pos, EntityPlayer player) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        EntityPlayerMP playerMP = null;
        if (player instanceof EntityPlayerMP) {
            playerMP = (EntityPlayerMP)player;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!this.toolClasses.contains((Object)state.func_177230_c().getHarvestTool(state)) && !this.canHarvestBlock(state, player.func_184614_ca())) {
            return false;
        }
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
            return false;
        }
        if (!world.field_72995_K) {
            int xpToDrop = 0;
            if (playerMP != null && (xpToDrop = ForgeHooks.onBlockBreakEvent((World)world, (GameType)playerMP.field_71134_c.func_73081_b(), (EntityPlayerMP)playerMP, (BlockPos)pos)) == -1) {
                return false;
            }
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
                if (!player.field_71075_bZ.field_75098_d) {
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
                    if (xpToDrop > 0) {
                        block.func_180637_b(world, pos, xpToDrop);
                    }
                }
            }
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            if (block.removedByPlayer(state, world, pos, player, !player.field_71075_bZ.field_75098_d)) {
                block.func_176206_d(world, pos, state);
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new CPacketPlayerDigging(CPacketPlayerDigging.Action.STOP_DESTROY_BLOCK, pos, Minecraft.func_71410_x().field_71476_x.field_178784_b));
        }
        return true;
    }

    public static class CutTreeTask {
        public World world;
        public ItemStack tool;
        public ItemAxeGelid axe;
        public BlockPos pos;
        public EntityPlayer player = null;
        public int maxIterations = 10000;
        public int iterationCount = 0;
        public Queue<BlockPos> candidates = new LinkedList<BlockPos>();
        public HashSet<BlockPos> visited = new HashSet();

        public CutTreeTask(@Nonnull ItemStack stack, @Nonnull BlockPos pos, @Nonnull EntityPlayer player) {
            if (!(stack.func_77973_b() instanceof ItemAxeGelid)) {
                this.unregister();
                return;
            }
            this.tool = stack;
            this.axe = (ItemAxeGelid)stack.func_77973_b();
            this.pos = pos;
            this.player = player;
            this.world = player.func_130014_f_();
            this.candidates.add(pos);
        }

        @SubscribeEvent
        public void cutTree(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.unregister();
                return;
            }
            if (event.world.field_73011_w.getDimension() != this.world.field_73011_w.getDimension()) {
                return;
            }
            if (this.axe == null) {
                this.unregister();
                return;
            }
            if (this.axe.getEnergyStored(this.tool) < this.axe.getEnergyPerUse(this.tool)) {
                this.unregister();
                return;
            }
            int blocksIter = blocksPerTick;
            while (blocksIter > 0) {
                BlockPos newPos;
                float refStrength;
                IBlockState state;
                if (this.candidates.isEmpty()) {
                    this.unregister();
                    return;
                }
                BlockPos curPos = this.candidates.remove();
                if (!this.visited.add(curPos) || !(state = this.world.func_180495_p(curPos)).func_177230_c().isWood((IBlockAccess)this.world, curPos) || (refStrength = state.func_185903_a(this.player, this.world, curPos)) == 0.0f) continue;
                EnumFacing[] cardinals = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
                for (EnumFacing face : cardinals) {
                    newPos = curPos.func_177972_a(face);
                    if (this.visited.contains(newPos)) continue;
                    this.candidates.add(newPos);
                }
                int y = 1;
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        newPos = curPos.func_177982_a(x, y, z);
                        if (this.visited.contains(newPos)) continue;
                        this.candidates.add(newPos);
                    }
                }
                this.axe.harvestBlock(this.world, curPos, this.player);
                this.world.func_184133_a(null, curPos, SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!this.player.field_71075_bZ.field_75098_d && this.axe.useEnergy(this.tool, false) == 0) break;
                ++this.iterationCount;
                if (this.iterationCount > this.maxIterations) {
                    this.unregister();
                    return;
                }
                --blocksIter;
            }
        }

        private void unregister() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

