/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.item.tool;

import cofh.core.util.RayTracer;
import cofh.core.util.helpers.StringHelper;
import cofh.redstonearsenal.item.tool.ItemPickaxeFlux;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import thundr.redstonerepository.item.GelidEnderiumEnergy;

public class ItemPickaxeGelid
extends ItemPickaxeFlux {
    public ItemPickaxeGelid(Item.ToolMaterial toolMaterial) {
        super(toolMaterial);
        this.maxEnergy = GelidEnderiumEnergy.maxEnergy;
        this.energyPerUse = GelidEnderiumEnergy.energyPerUse;
        this.energyPerUseCharged = GelidEnderiumEnergy.energyPerUseCharged;
        this.maxTransfer = GelidEnderiumEnergy.maxTransfer;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K && player.func_70093_af()) {
            TileEntity tile;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((tile = world.func_175625_s(pos)) != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing)) {
                stack.func_77978_p().func_74757_a("Bound", true);
                stack.func_77978_p().func_74768_a("CoordX", x);
                stack.func_77978_p().func_74768_a("CoordY", y);
                stack.func_77978_p().func_74768_a("CoordZ", z);
                stack.func_77978_p().func_74768_a("DimID", world.field_73011_w.getDimension());
                stack.func_77978_p().func_74768_a("Side", facing.func_176745_a());
                player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation("info.redstonerepository.chat.boundto.txt", new Object[0]).func_150254_d() + " x: " + x + " y: " + y + " z: " + z), false);
                return EnumActionResult.SUCCESS;
            }
            stack.func_77978_p().func_74757_a("Bound", false);
            stack.func_77978_p().func_74768_a("CoordX", 0);
            stack.func_77978_p().func_74768_a("CoordY", 0);
            stack.func_77978_p().func_74768_a("CoordZ", 0);
            stack.func_77978_p().func_74768_a("DimID", 0);
            stack.func_77978_p().func_74768_a("Side", 0);
            player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation("info.redstonerepository.chat.unbound.txt", new Object[0]).func_150254_d()), false);
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("\u00a7aSneak right click to bind an inventory when empowered.");
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o()) {
            int[] values = new int[5];
            boolean isBound = false;
            NBTTagCompound tags = stack.func_77978_p();
            if (tags.func_74764_b("CoordX")) {
                values[0] = tags.func_74762_e("CoordX");
            }
            if (tags.func_74764_b("CoordY")) {
                values[1] = tags.func_74762_e("CoordY");
            }
            if (tags.func_74764_b("CoordZ")) {
                values[2] = tags.func_74762_e("CoordZ");
            }
            if (tags.func_74764_b("DimID")) {
                values[3] = tags.func_74762_e("DimID");
            }
            if (tags.func_74764_b("Side")) {
                values[4] = tags.func_74762_e("Side");
            }
            if (tags.func_74764_b("Bound")) {
                isBound = tags.func_74767_n("Bound");
            }
            String sideString = EnumFacing.func_82600_a((int)values[4]).func_176610_l().toLowerCase();
            if (StringHelper.isControlKeyDown()) {
                if (isBound) {
                    tooltip.add(StringHelper.localize((String)("\u00a7a" + StringHelper.localize((String)"info.redstonerepository.tooltip.bound") + "\u00a77 " + values[0] + ", " + values[1] + ", " + values[2] + ". DimID: " + values[3])));
                    tooltip.add(StringHelper.localize((String)("\u00a7b" + StringHelper.localize((String)"info.redstonerepository.tooltip.side") + "\u00a77 " + Character.toUpperCase(sideString.charAt(0)) + sideString.substring(1))));
                } else {
                    tooltip.add("\u00a7aNot Bound to an Inventory");
                }
            } else {
                tooltip.add(StringHelper.localize((String)"info.redstonerepository.tooltip.hold") + " \u00a7e\u00a7o" + StringHelper.localize((String)"info.redstonerepository.tooltip.control") + " \u00a77" + StringHelper.localize((String)"info.redstonerepository.tooltip.forDetails"));
            }
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
            return false;
        }
        world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            boolean used = false;
            if (this.isEmpowered(stack) && this.canHarvestBlock(state, stack)) {
                RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
                if (traceResult == null || traceResult.field_178784_b == null) {
                    return false;
                }
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                int radius = 1;
                switch (traceResult.field_178784_b) {
                    case DOWN: 
                    case UP: {
                        for (int i = x - radius; i <= x + radius; ++i) {
                            for (int k = z - radius; k <= z + radius; ++k) {
                                BlockPos adjPos = new BlockPos(i, y, k);
                                IBlockState adjState = world.func_180495_p(adjPos);
                                float strength = adjState.func_185903_a(player, world, adjPos);
                                if (strength <= 0.0f || refStrength / strength > 10.0f) continue;
                                used |= this.harvestBlock(world, adjPos, player);
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        for (int i = x - radius; i <= x + radius; ++i) {
                            for (int j = y - radius; j <= y + radius; ++j) {
                                BlockPos adjPos = new BlockPos(i, j, z);
                                IBlockState adjState = world.func_180495_p(adjPos);
                                float strength = adjState.func_185903_a(player, world, adjPos);
                                if (strength <= 0.0f || refStrength / strength > 10.0f) continue;
                                used |= this.harvestBlock(world, adjPos, player);
                            }
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        for (int j = y - radius; j <= y + radius; ++j) {
                            for (int k = z - radius; k <= z + radius; ++k) {
                                BlockPos adjPos = new BlockPos(x, j, k);
                                IBlockState adjState = world.func_180495_p(adjPos);
                                float strength = adjState.func_185903_a(player, world, adjPos);
                                if (strength <= 0.0f || refStrength / strength > 10.0f) continue;
                                used |= this.harvestBlock(world, adjPos, player);
                            }
                        }
                        break;
                    }
                }
            }
            if (used && !player.field_71075_bZ.field_75098_d) {
                this.useEnergy(stack, false);
            }
        }
        return false;
    }

    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        RayTraceResult traceResult = RayTracer.retrace((EntityPlayer)player, (boolean)false);
        if (traceResult == null || traceResult.field_178784_b == null || !this.isEmpowered(stack) || !this.canHarvestBlock(world.func_180495_p(pos), stack)) {
            return ImmutableList.copyOf(area);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (i == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos harvestPos;
                        if (i == x && j == y || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, z)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case WEST: 
            case EAST: {
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 1333581;
    }

    public int getEnergyPerUseCharged() {
        return this.energyPerUseCharged;
    }
}

