/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.item.util;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import thundr.redstonerepository.RedstoneRepository;
import thundr.redstonerepository.init.RedstoneRepositoryEquipment;
import thundr.redstonerepository.item.ItemCoreRF;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemCapacitorAmulet
extends ItemCoreRF
implements IBauble,
IEnergyContainerItem,
IEnchantableItem,
INBTCopyIngredient {
    protected int maxEnergy = 320000;
    protected int maxTransfer = 4000;
    protected int energyPerUse = 800;
    protected int energyPerUseCharged = 6400;
    @CapabilityInject(value=IBaublesItemHandler.class)
    private static final Capability<IBaublesItemHandler> CAPABILITY_BAUBLES = null;

    public ItemCapacitorAmulet() {
        super("redstonerepository");
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77655_b("redstonerepository.util.gelidCapacitor");
        this.func_77637_a(RedstoneRepository.tabCommon);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.isActive(stack) ? 1.0f : 0.0f);
    }

    public ItemCapacitorAmulet(int capacity, int transfer) {
        super("redstonerepository");
        this.maxEnergy = capacity;
        this.maxTransfer = transfer;
        this.func_77655_b("redstonerepository.util.gelidCapacitor");
        this.func_77637_a(RedstoneRepository.tabCommon);
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.isActive(stack) ? 1.0f : 0.0f);
    }

    private static Iterable<ItemStack> getBaubles(Entity entity) {
        if (CAPABILITY_BAUBLES == null) {
            return Collections.emptyList();
        }
        IBaublesItemHandler handler = (IBaublesItemHandler)entity.getCapability(CAPABILITY_BAUBLES, null);
        if (handler == null) {
            return Collections.emptyList();
        }
        IntStream stream = IntStream.range(0, handler.getSlots());
        handler.getClass();
        return stream.mapToObj(arg_0 -> ((IBaublesItemHandler)handler).getStackInSlot(arg_0)).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.redstonerepository.capacitor.title"));
        if (this.isActive(stack)) {
            tooltip.add(StringHelper.getDeactivationText((String)"info.redstonerepository.capacitor.deactivate"));
        } else {
            tooltip.add(StringHelper.getActivationText((String)"info.redstonerepository.capacitor.activate"));
        }
        if (!RedstoneRepositoryEquipment.EquipmentInit.enable[0]) {
            tooltip.add("\u00a74Baubles not loaded: Recipe disabled.");
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getCapacity(stack)) + " RF");
        tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)this.maxTransfer) + "/" + StringHelper.formatNumber((long)this.maxTransfer) + " RF/t");
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    public void onWornTick(ItemStack cap, EntityLivingBase player) {
        if (!this.isActive(cap) || player.field_70170_p.field_72995_K || CoreUtils.isFakePlayer((Entity)player) || !(player instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player;
        Iterable playerItems = Iterables.concat((Iterable)entityPlayer.field_71071_by.field_70460_b, (Iterable)entityPlayer.field_71071_by.field_70462_a, (Iterable)entityPlayer.field_71071_by.field_184439_c, ItemCapacitorAmulet.getBaubles((Entity)entityPlayer));
        for (ItemStack playerItem : playerItems) {
            IEnergyStorage handler;
            if (playerItem.func_190926_b() || playerItem.equals(cap) || playerItem.func_77973_b() instanceof ItemCapacitorAmulet) continue;
            if (EnergyHelper.isEnergyContainerItem((ItemStack)playerItem)) {
                this.extractEnergy(cap, ((IEnergyContainerItem)playerItem.func_77973_b()).receiveEnergy(playerItem, Math.min(this.getEnergyStored(cap), this.maxTransfer), false), false);
                continue;
            }
            if (!EnergyHelper.isEnergyHandler((ItemStack)playerItem) || (handler = EnergyHelper.getEnergyHandler((ItemStack)playerItem)) == null) continue;
            this.extractEnergy(cap, handler.receiveEnergy(Math.min(this.getEnergyStored(cap), this.maxTransfer), false), false);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (player.func_70093_af() && this.setActiveState(stack, !this.isActive(stack))) {
            if (this.isActive(stack)) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
            } else {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public boolean isActive(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("Active");
    }

    public boolean setActiveState(ItemStack stack, boolean state) {
        if (this.getEnergyStored(stack) > 0) {
            stack.func_77978_p().func_74757_a("Active", state);
            return true;
        }
        stack.func_77978_p().func_74757_a("Active", false);
        return false;
    }

    protected int getCapacity(ItemStack stack) {
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return this.maxEnergy + this.maxEnergy * enchant / 2;
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return this.getCapacity(stack);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Override
    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getCapacity(stack);
    }

    public boolean setMode(ItemStack stack, int mode) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }
}

