/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.item.util;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import thundr.redstonerepository.RedstoneRepository;
import thundr.redstonerepository.init.RedstoneRepositoryEquipment;
import thundr.redstonerepository.item.ItemCoreRF;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemRingEffect
extends ItemCoreRF
implements IBauble {
    public static final int POTION_DURATION_TICKS = 290;
    public static final String POWER_TICK = "pwrTick";
    public static final String UNTIL_SAFE_TO_REMOVE = "cd";
    public static final String EFFECTS = "efx";
    public static final String AMPLIFIER = "amp";
    public static final String ON_COOLDOWN = "cd2";
    public ConcurrentHashMap<UUID, ArrayList<PotionEffect>> globalMap = new ConcurrentHashMap();
    public static int removalTimer = 100;
    public static int cooldownTimer = 1200;
    public static int cooldownThreshold;
    public static int cooldownDuration;
    public static int powerMultiplier;
    public static int effectRingTransfer;
    public static int effectRingCapacity;

    public ItemRingEffect(int cooldownThreshold, int cooldownDuration, int powerMultiplier, int effectRingTransfer, int effectRingCapacity) {
        super("redstonerepository");
        removalTimer = cooldownThreshold;
        cooldownTimer = cooldownDuration;
        this.maxEnergy = effectRingCapacity;
        this.maxTransfer = effectRingTransfer;
        this.energyPerUse = 2000 * powerMultiplier;
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77655_b("redstonerepository.util.ring.effect");
        this.func_77637_a(RedstoneRepository.tabCommon);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getMode(stack) == MODE.ENABLED.getValue() ? 1.0f : 0.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.redstonerepository.ring.effect.title"));
        if (this.getMode(stack) == MODE.ENABLED.getValue()) {
            tooltip.add(StringHelper.localizeFormat((String)"info.redstonerepository.tooltip.active", (Object[])new Object[]{"\u00a7a", "\u00a7r", StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        } else {
            tooltip.add(StringHelper.localizeFormat((String)"info.redstonerepository.tooltip.disabled", (Object[])new Object[]{"\u00a7c", "\u00a7r", StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e(ON_COOLDOWN) > 0) {
            tooltip.add("\u00a74" + StringHelper.localizeFormat((String)"info.redstonerepository.ring.effect.disabled", (Object[])new Object[]{StringHelper.formatNumber((long)(stack.func_77978_p().func_74762_e(ON_COOLDOWN) / 20 + 1))}));
        }
        if (!RedstoneRepositoryEquipment.EquipmentInit.enable[2]) {
            tooltip.add("\u00a74Baubles not loaded: Recipe disabled.");
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)this.maxTransfer) + "/" + StringHelper.formatNumber((long)this.maxTransfer) + " RF/t");
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(ItemStack ring, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer) || player.field_70170_p.field_72995_K || CoreUtils.isFakePlayer((Entity)player)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player;
        if (ring.func_77978_p() != null && !ring.func_77978_p().func_74764_b(ON_COOLDOWN)) {
            ring.func_77978_p().func_74768_a(ON_COOLDOWN, 0);
        }
        if (this.isActive(ring) && this.getEnergyStored(ring) >= this.getEnergyPerUse(ring) && ring.func_77978_p().func_74762_e(ON_COOLDOWN) == 0) {
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>(10);
            int powerUsage = this.getEnergyPerUse(ring);
            for (PotionEffect p : player.func_70651_bq()) {
                effects.add(p);
                powerUsage += (int)Math.pow(this.getEnergyPerUse(ring), p.func_76458_c());
            }
            this.writePotionEffectsToNBT(effects, ring);
            this.globalMap.put(entityPlayer.func_110124_au(), effects);
            ring.func_77978_p().func_74768_a(POWER_TICK, powerUsage);
            ring.func_77978_p().func_74768_a(UNTIL_SAFE_TO_REMOVE, removalTimer);
            entityPlayer.func_70674_bp();
        }
    }

    @Optional.Method(modid="baubles")
    public void onUnequipped(ItemStack ring, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer) || player.field_70170_p.field_72995_K || CoreUtils.isFakePlayer((Entity)player)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player;
        if (this.isActive(ring) && this.getEnergyStored(ring) >= this.getEnergyPerUse(ring)) {
            entityPlayer.func_70674_bp();
            if (ring.func_77978_p() != null) {
                if (ring.func_77978_p().func_74762_e(UNTIL_SAFE_TO_REMOVE) > 0 && ring.func_77978_p().func_74762_e(ON_COOLDOWN) == 0) {
                    ring.func_77978_p().func_74768_a(ON_COOLDOWN, cooldownTimer);
                }
                ring.func_77978_p().func_74768_a(UNTIL_SAFE_TO_REMOVE, 0);
            }
        }
        this.globalMap.remove(player.func_110124_au());
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(ItemStack ring, EntityLivingBase player) {
        if (!(player instanceof EntityPlayer) || player.field_70170_p.field_72995_K || CoreUtils.isFakePlayer((Entity)player)) {
            return;
        }
        if (ring.func_77978_p() != null) {
            return;
        }
        if (ring.func_77978_p().func_74762_e(POWER_TICK) > this.maxTransfer) {
            ring.func_77978_p().func_74768_a(ON_COOLDOWN, cooldownTimer);
            return;
        }
        if (ring.func_77978_p().func_74762_e(ON_COOLDOWN) > 0) {
            ring.func_77978_p().func_74768_a(ON_COOLDOWN, ring.func_77978_p().func_74762_e(ON_COOLDOWN) - 1);
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)player;
        ArrayList<PotionEffect> cacheEffects = this.globalMap.get(entityPlayer.func_110124_au());
        if (cacheEffects == null && ring.func_77978_p().func_74764_b(EFFECTS)) {
            cacheEffects = this.readPotionEffectsFromNBT(ring.func_77978_p());
            this.globalMap.put(entityPlayer.func_110124_au(), cacheEffects);
        }
        if (this.isActive(ring) && this.getEnergyStored(ring) >= ring.func_77978_p().func_74762_e(POWER_TICK)) {
            for (PotionEffect p : this.globalMap.get(entityPlayer.func_110124_au())) {
                player.func_70690_d(p);
            }
            this.useEnergyExact(ring, ring.func_77978_p().func_74762_e(POWER_TICK), false);
            ring.func_77978_p().func_74768_a(UNTIL_SAFE_TO_REMOVE, ring.func_77978_p().func_74762_e(UNTIL_SAFE_TO_REMOVE) - 1);
        } else {
            entityPlayer.func_70674_bp();
            this.globalMap.remove(player.func_110124_au());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity player, int itemSlot, boolean isSelected) {
        if (!(player instanceof EntityPlayer) || player.field_70170_p.field_72995_K || CoreUtils.isFakePlayer((Entity)player)) {
            return;
        }
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74762_e(ON_COOLDOWN) > 0) {
            stack.func_77978_p().func_74768_a(ON_COOLDOWN, stack.func_77978_p().func_74762_e(ON_COOLDOWN) - 1);
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public ArrayList<PotionEffect> readPotionEffectsFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null || tagCompound.func_74781_a(EFFECTS) == null || tagCompound.func_74781_a(AMPLIFIER) == null) {
            return new ArrayList<PotionEffect>();
        }
        NBTTagList nbtEffects = (NBTTagList)tagCompound.func_74781_a(EFFECTS);
        NBTTagList nbtAmp = (NBTTagList)tagCompound.func_74781_a(AMPLIFIER);
        ArrayList<PotionEffect> toLoadEffects = new ArrayList<PotionEffect>();
        for (int i = 0; i < nbtEffects.func_74745_c(); ++i) {
            PotionEffect p = new PotionEffect(Potion.func_188412_a((int)nbtEffects.func_186858_c(i)), 290, nbtAmp.func_186858_c(i));
            toLoadEffects.add(p);
        }
        return toLoadEffects;
    }

    public void writePotionEffectsToNBT(ArrayList<PotionEffect> effects, ItemStack ring) {
        NBTTagList tagListEffects = new NBTTagList();
        NBTTagList tagListIds = new NBTTagList();
        NBTTagCompound tagCompound = new NBTTagCompound();
        for (PotionEffect e : effects) {
            tagListEffects.func_74742_a((NBTBase)new NBTTagInt(e.func_76458_c()));
            tagListIds.func_74742_a((NBTBase)new NBTTagInt(Potion.func_188409_a((Potion)e.func_188419_a())));
        }
        if (!ring.func_77942_o()) {
            tagCompound.func_74782_a(EFFECTS, (NBTBase)tagListIds);
            tagCompound.func_74782_a(AMPLIFIER, (NBTBase)tagListEffects);
            ring.func_77982_d(tagCompound);
        } else {
            ring.func_77978_p().func_74782_a(EFFECTS, (NBTBase)tagListIds);
            ring.func_77978_p().func_74782_a(AMPLIFIER, (NBTBase)tagListEffects);
        }
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.getMode(stack) == MODE.ENABLED.getValue()) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
        }
    }

    public static enum MODE {
        DISABLED(0),
        ENABLED(1);

        private final int value;

        private MODE(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

