/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.item.util;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import thundr.redstonerepository.RedstoneRepository;
import thundr.redstonerepository.init.RedstoneRepositoryEquipment;
import thundr.redstonerepository.item.ItemCoreRF;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemRingMining
extends ItemCoreRF
implements IBauble {
    public ItemRingMining() {
        super("redstonerepository");
        this.maxEnergy = 4000000;
        this.maxTransfer = 5000;
        this.energyPerUse = 100;
        this.func_77656_e(0);
        this.setNoRepair();
        this.func_77625_d(1);
        this.func_77655_b("redstonerepository.util.ring.mining");
        this.func_77637_a(RedstoneRepository.tabCommon);
        this.func_185043_a(new ResourceLocation("active"), (stack, world, entity) -> this.getMode(stack) == MODE.ENABLED.getValue() ? 1.0f : 0.0f);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.redstonerepository.ring.mining.title"));
        if (this.getMode(stack) == MODE.ENABLED.getValue()) {
            tooltip.add(StringHelper.localizeFormat((String)"info.redstonerepository.tooltip.active", (Object[])new Object[]{"\u00a7a", "\u00a7r", StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        } else {
            tooltip.add(StringHelper.localizeFormat((String)"info.redstonerepository.tooltip.disabled", (Object[])new Object[]{"\u00a7c", "\u00a7r", StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        }
        if (!RedstoneRepositoryEquipment.EquipmentInit.enable[3]) {
            tooltip.add("\u00a74Baubles not loaded: Recipe disabled.");
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add(StringHelper.localize((String)"info.cofh.send") + "/" + StringHelper.localize((String)"info.cofh.receive") + ": " + StringHelper.formatNumber((long)this.maxTransfer) + "/" + StringHelper.formatNumber((long)this.maxTransfer) + " RF/t");
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.getMode(stack) == MODE.ENABLED.getValue()) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.8f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.5f);
        }
    }

    public static enum MODE {
        DISABLED(0),
        ENABLED(1);

        private final int value;

        private MODE(int newValue) {
            this.value = newValue;
        }

        public int getValue() {
            return this.value;
        }
    }
}

