/*
 * Decompiled with CFR 0.152.
 */
package thundr.redstonerepository.util;

import cofh.core.util.helpers.BaublesHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thundr.redstonerepository.RedstoneRepository;
import thundr.redstonerepository.item.tool.ItemPickaxeGelid;
import thundr.redstonerepository.item.util.ItemRingEffect;
import thundr.redstonerepository.item.util.ItemRingMining;

public class ToolEventHandler {
    public static int pickaxeDistanceFactor;
    public static int pickaxeDimensionFactor;

    public static void preInit() {
        pickaxeDistanceFactor = RedstoneRepository.CONFIG_COMMON.get("Equipment.Tools", "PickaxeDistanceDrainFactor", 5, "Set the factor that scales the power drained from the Gelid Enderium Pickaxe when teleporting items over a distance. (distance*factor*itemDrops=power)");
        pickaxeDimensionFactor = RedstoneRepository.CONFIG_COMMON.get("Equipment.Tools", "PickaxeDimensionDrainFactor", 7500, "Set the factor that scales the power drained from the Gelid Enderium Pickaxe when teleporting items between dimensions. This is a flat value per item.");
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (!world.field_72995_K && event.getHarvester() != null && !event.getHarvester().func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && event.getHarvester().func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemPickaxeGelid) {
            ItemStack stack = event.getHarvester().func_184586_b(EnumHand.MAIN_HAND);
            ItemPickaxeGelid pickaxe = (ItemPickaxeGelid)event.getHarvester().func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            if (this.isEmpowered(stack)) {
                if (stack.func_77978_p() == null) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                NBTTagCompound tag = stack.func_77978_p();
                int coordX = tag.func_74762_e("CoordX");
                int coordY = tag.func_74762_e("CoordY");
                int coordZ = tag.func_74762_e("CoordZ");
                int dimID = tag.func_74762_e("DimID");
                int side = tag.func_74762_e("Side");
                boolean isBound = tag.func_74767_n("Bound");
                if (isBound) {
                    WorldServer boundWorld = DimensionManager.getWorld((int)dimID);
                    if (event.getWorld().func_180495_p(event.getPos()) != boundWorld.func_180495_p(new BlockPos(coordX, coordY, coordZ))) {
                        EnumFacing dir;
                        TileEntity bound = boundWorld.func_175625_s(new BlockPos(coordX, coordY, coordZ));
                        if (!bound.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir = EnumFacing.func_82600_a((int)side))) {
                            return;
                        }
                        IItemHandler inventory = (IItemHandler)bound.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir);
                        for (int drop = 0; drop < event.getDrops().size(); ++drop) {
                            ItemStack returned = ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)((ItemStack)event.getDrops().get(drop)), (boolean)false);
                            int temp = this.drainEnergyByDistance(event.getPos(), new BlockPos(coordX, coordY, coordZ), dimID != event.getHarvester().field_71093_bK);
                            pickaxe.extractEnergy(stack, temp, false);
                            if (!returned.func_190926_b()) {
                                return;
                            }
                            event.setDropChance(0.0f);
                        }
                    }
                }
            }
        }
    }

    private int drainEnergyByDistance(BlockPos from, BlockPos to, boolean interdim) {
        if (!interdim) {
            return (int)(Math.sqrt(Math.pow(from.func_177958_n() - to.func_177958_n(), 2.0) + Math.pow(from.func_177956_o() - to.func_177956_o(), 2.0) + Math.pow(from.func_177958_n() - to.func_177958_n(), 2.0)) * (double)pickaxeDistanceFactor);
        }
        return pickaxeDimensionFactor;
    }

    public boolean isEmpowered(ItemStack stack) {
        ItemPickaxeGelid pick = (ItemPickaxeGelid)stack.func_77973_b();
        return pick.getMode(stack) == 1 && pick.getEnergyStored(stack) >= pick.getEnergyPerUseCharged();
    }

    @SubscribeEvent
    public void onUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemStack itemStack : BaublesHelper.getBaubles((Entity)player)) {
                int diff;
                ArrayList<PotionEffect> potions;
                ItemRingEffect ring;
                if (!(itemStack.func_77973_b() instanceof ItemRingEffect) || !(ring = (ItemRingEffect)itemStack.func_77973_b()).isActive(itemStack) || (potions = ring.globalMap.get(player.func_110124_au())) == null || (diff = player.func_70651_bq().size() - potions.size()) <= 0) continue;
                ring.useEnergy(itemStack, (int)Math.pow(2.0, (double)diff + 6.0), false);
                player.func_70674_bp();
                return;
            }
        }
    }

    @SubscribeEvent
    public void onBlockMined(PlayerEvent.BreakSpeed event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemStack itemStack : BaublesHelper.getBaubles((Entity)player)) {
                ItemRingMining ring;
                if (!(itemStack.func_77973_b() instanceof ItemRingMining) || !(ring = (ItemRingMining)itemStack.func_77973_b()).isActive(itemStack) || player.field_70122_E) continue;
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
                ring.useEnergy(itemStack, 1, false);
            }
        }
    }
}

