/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common;

import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.plugin.PluginLoader;
import aroma1997.backup.common.storageformat.IncrementalSupportingStorageFormat;
import aroma1997.backup.common.storageformat.SimpleStorageFormat;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import aroma1997.backup.common.util.IOHelper;

public class BackupStateHelper {
    public static void setup() {
        StorageFormatRegistry.INSTANCE.getCompressionStorageFormat = SimpleStorageFormat::new;
        StorageFormatRegistry.INSTANCE.getIncrementalStorageFormat = IncrementalSupportingStorageFormat::new;
        PluginLoader.load();
    }

    public static void loadPlugins() {
        IOHelper.printUserOut("Loading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            IOHelper.printUserOut("Loading module: \"" + plugin.getName() + "\".");
            plugin.load();
        }
        IOHelper.printUserOut("Done loading plugins.");
    }

    public static void postLoadPlugins() {
        IOHelper.printUserOut("Postloading " + PluginLoader.getPlugins().size() + " modules.");
        for (BackupPlugin plugin : PluginLoader.getPlugins()) {
            IOHelper.printUserOut("Postloading module: \"" + plugin.getName() + "\".");
            plugin.postLoad();
        }
        IOHelper.printUserOut("Done postloading plugins.");
    }
}

