/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.common.compression;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public final class CompressionHelper {
    private CompressionHelper() {
    }

    public static Map<File, String> listFiles(File dir) {
        HashMap<File, String> map = new HashMap<File, String>();
        CompressionHelper.discover(map, dir, "");
        return map;
    }

    public static void discover(Map<File, String> map, File file, String target) {
        CompressionHelper.fileHelper(file, target, (f, str) -> {
            if (!f.isDirectory()) {
                map.put((File)f, (String)str);
            }
        });
    }

    public static String appendFilename(String dir, String name) {
        if (dir.isEmpty()) {
            return name;
        }
        return dir + "/" + name;
    }

    public static void deleteFile(File file) {
        CompressionHelper.fileHelper(file, (f, str) -> f.delete());
    }

    public static void fileHelper(File file, BiConsumer<File, String> str) {
        CompressionHelper.fileHelper(file, "", str);
    }

    private static void fileHelper(File file, String currentPath, BiConsumer<File, String> consumer) {
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                String newPath = CompressionHelper.appendFilename(currentPath, sub.getName());
                CompressionHelper.fileHelper(sub, newPath, consumer);
            }
        }
        consumer.accept(file, currentPath);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        String prefix = "";
        if (filename.substring(0, index).endsWith(".tar")) {
            prefix = "tar.";
        }
        return prefix + filename.substring(index + 1);
    }
}

