/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup.corecompressions;

import aroma1997.backup.common.compression.ICompression;
import aroma1997.backup.common.plugin.BackupPlugin;
import aroma1997.backup.common.storageformat.StorageFormatRegistry;
import aroma1997.backup.corecompressions.FolderStorageFormat;
import aroma1997.backup.corecompressions.compression.TarCompression;
import aroma1997.backup.corecompressions.compression.TarGzCompression;
import aroma1997.backup.corecompressions.compression.ZipCompression;

public class CoreCompressionsPlugin
extends BackupPlugin {
    @Override
    public void load() {
        this.registerCompression(new ZipCompression(), "zip");
        this.registerCompression(new TarCompression(), "tar");
        this.registerCompression(new TarGzCompression(), "tar.gz");
        StorageFormatRegistry.INSTANCE.registerStorageFormat(StorageFormatRegistry.INSTANCE.getIncrementalStorageFormat.apply(new FolderStorageFormat()));
    }

    private void registerCompression(ICompression compression, String extension) {
        StorageFormatRegistry.INSTANCE.registerStorageFormat(StorageFormatRegistry.INSTANCE.getIncrementalStorageFormat.apply(StorageFormatRegistry.INSTANCE.getCompressionStorageFormat.apply(compression, extension)));
    }

    @Override
    public String getName() {
        return "Corecompressions";
    }
}

