/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.org.kamranzafar.jtar;

import aroma1997.org.kamranzafar.jtar.TarEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

public class TarOutputStream
extends OutputStream {
    private final OutputStream out;
    private long bytesWritten;
    private long currentFileSize;
    private TarEntry currentEntry;

    public TarOutputStream(OutputStream out) {
        this.out = out;
        this.bytesWritten = 0L;
        this.currentFileSize = 0L;
    }

    public TarOutputStream(File fout) throws FileNotFoundException {
        this.out = new BufferedOutputStream(new FileOutputStream(fout));
        this.bytesWritten = 0L;
        this.currentFileSize = 0L;
    }

    public TarOutputStream(File fout, boolean append) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(fout, "rw");
        long fileSize = fout.length();
        if (append && fileSize > 1024L) {
            raf.seek(fileSize - 1024L);
        }
        this.out = new BufferedOutputStream(new FileOutputStream(raf.getFD()));
    }

    @Override
    public void close() throws IOException {
        this.closeCurrentEntry();
        this.write(new byte[1024]);
        this.out.close();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.bytesWritten;
        if (this.currentEntry != null) {
            ++this.currentFileSize;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.currentEntry != null && !this.currentEntry.isDirectory() && this.currentEntry.getSize() < this.currentFileSize + (long)len) {
            throw new IOException("The current entry[" + this.currentEntry.getName() + "] size[" + this.currentEntry.getSize() + "] is smaller than the bytes[" + (this.currentFileSize + (long)len) + "] being written.");
        }
        this.out.write(b, off, len);
        this.bytesWritten += (long)len;
        if (this.currentEntry != null) {
            this.currentFileSize += (long)len;
        }
    }

    public void putNextEntry(TarEntry entry) throws IOException {
        this.closeCurrentEntry();
        byte[] header = new byte[512];
        entry.writeEntryHeader(header);
        this.write(header);
        this.currentEntry = entry;
    }

    protected void closeCurrentEntry() throws IOException {
        if (this.currentEntry != null) {
            if (this.currentEntry.getSize() > this.currentFileSize) {
                throw new IOException("The current entry[" + this.currentEntry.getName() + "] of size[" + this.currentEntry.getSize() + "] has not been fully written.");
            }
            this.currentEntry = null;
            this.currentFileSize = 0L;
            this.pad();
        }
    }

    protected void pad() throws IOException {
        int extra;
        if (this.bytesWritten > 0L && (extra = (int)(this.bytesWritten % 512L)) > 0) {
            this.write(new byte[512 - extra]);
        }
    }
}

