/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.tile;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.tile.IEmcStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEmcBase
extends TileEntity
implements IEmcStorage {
    protected long maximumEMC;
    protected long currentEMC = 0L;

    protected TileEmcBase() {
        this.setMaximumEMC(Long.MAX_VALUE);
    }

    public final void setMaximumEMC(long max) {
        this.maximumEMC = max;
        if (this.currentEMC > this.maximumEMC) {
            this.currentEMC = this.maximumEMC;
        }
    }

    @Override
    public long getStoredEmc() {
        return this.currentEMC;
    }

    @Override
    public long getMaximumEmc() {
        return this.maximumEMC;
    }

    protected void addEMC(long toAdd) {
        this.currentEMC += toAdd;
        if (this.currentEMC > this.maximumEMC) {
            this.currentEMC = this.maximumEMC;
        }
    }

    protected void removeEMC(long toRemove) {
        this.currentEMC -= toRemove;
        if (this.currentEMC < 0L) {
            this.currentEMC = 0L;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        if (this.currentEMC > this.maximumEMC) {
            this.currentEMC = this.maximumEMC;
        }
        tag.func_74772_a("EMC", this.currentEMC);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        long set = tag.func_74763_f("EMC");
        if (set > this.maximumEMC) {
            set = this.maximumEMC;
        }
        this.currentEMC = set;
    }
}

