/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HarvestGoddess
extends RingToggle
implements IPedestalItem {
    public HarvestGoddess() {
        super("harvest_god");
        this.setNoRepair();
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K || par4 > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        super.func_77663_a(stack, world, entity, par4, par5);
        EntityPlayer player = (EntityPlayer)entity;
        if (ItemHelper.getOrCreateCompound(stack).func_74767_n("Active")) {
            long storedEmc = HarvestGoddess.getEmc(stack);
            if (storedEmc == 0L && !HarvestGoddess.consumeFuel(player, stack, 64L, true)) {
                stack.func_77978_p().func_74757_a("Active", false);
            } else {
                WorldHelper.growNearbyRandomly(true, world, new BlockPos((Entity)player), player);
                HarvestGoddess.removeEmc(stack, EMCHelper.removeFractionalEMC(stack, 0.32f));
            }
        } else {
            WorldHelper.growNearbyRandomly(false, world, new BlockPos((Entity)player), player);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float par8, float par9, float par10) {
        if (world.field_72995_K || !player.func_175151_a(pos, facing, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af()) {
            Object[] obj = this.getStackFromInventory((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, Items.field_151100_aR, 15, 4);
            if (obj == null) {
                return EnumActionResult.FAIL;
            }
            ItemStack boneMeal = (ItemStack)obj[1];
            if (!boneMeal.func_190926_b() && this.useBoneMeal(world, pos)) {
                player.field_71071_by.func_70298_a(((Integer)obj[0]).intValue(), 4);
                player.field_71069_bz.func_75142_b();
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return this.plantSeeds(world, player, pos) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    private boolean useBoneMeal(World world, BlockPos pos) {
        boolean result = false;
        for (BlockPos currentPos : BlockPos.func_177975_b((BlockPos)pos.func_177982_a(-15, 0, -15), (BlockPos)pos.func_177982_a(15, 0, 15))) {
            IGrowable growable;
            IBlockState state = world.func_180495_p(currentPos);
            Block crop = state.func_177230_c();
            if (!(crop instanceof IGrowable) || !(growable = (IGrowable)crop).func_180670_a(world, world.field_73012_v, currentPos, state)) continue;
            if (!result) {
                result = true;
            }
            growable.func_176474_b(world, world.field_73012_v, currentPos.func_185334_h(), state);
        }
        return result;
    }

    private boolean plantSeeds(World world, EntityPlayer player, BlockPos pos) {
        boolean result = false;
        List<StackWithSlot> seeds = this.getAllSeeds((NonNullList<ItemStack>)player.field_71071_by.field_70462_a);
        if (seeds.isEmpty()) {
            return false;
        }
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-8, 0, -8), (BlockPos)pos.func_177982_a(8, 0, 8))) {
            IBlockState state = world.func_180495_p(currentPos);
            if (world.func_175623_d(currentPos)) continue;
            for (int i = 0; i < seeds.size(); ++i) {
                StackWithSlot s = seeds.get(i);
                IPlantable plant = s.stack.func_77973_b() instanceof IPlantable ? (IPlantable)s.stack.func_77973_b() : (IPlantable)Block.func_149634_a((Item)s.stack.func_77973_b());
                if (!state.func_177230_c().canSustainPlant(state, (IBlockAccess)world, currentPos, EnumFacing.UP, plant) || !world.func_175623_d(currentPos.func_177984_a())) continue;
                world.func_175656_a(currentPos.func_177984_a(), plant.getPlant((IBlockAccess)world, currentPos.func_177984_a()));
                player.field_71071_by.func_70298_a(s.slot, 1);
                player.field_71069_bz.func_75142_b();
                s.stack.func_190918_g(1);
                if (s.stack.func_190926_b()) {
                    seeds.remove(i);
                }
                if (result) continue;
                result = true;
            }
        }
        return result;
    }

    private List<StackWithSlot> getAllSeeds(NonNullList<ItemStack> inv) {
        ArrayList<StackWithSlot> result = new ArrayList<StackWithSlot>();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof IPlantable) {
                result.add(new StackWithSlot(stack, i));
                continue;
            }
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (block == null || !(block instanceof IPlantable)) continue;
            result.add(new StackWithSlot(stack, i));
        }
        return result;
    }

    private Object[] getStackFromInventory(NonNullList<ItemStack> inv, Item item, int meta, int minAmount) {
        Object[] obj = new Object[2];
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = (ItemStack)inv.get(i);
            if (stack.func_190926_b() || stack.func_190916_E() < minAmount || stack.func_77973_b() != item || stack.func_77952_i() != meta) continue;
            obj[0] = i;
            obj[1] = stack;
            return obj;
        }
        return null;
    }

    @Override
    public boolean changeMode(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        NBTTagCompound tag;
        tag.func_74757_a("Active", !(tag = ItemHelper.getOrCreateCompound(stack)).func_74767_n("Active"));
        return true;
    }

    @Override
    public void updateInPedestal(@Nonnull World world, @Nonnull BlockPos pos) {
        if (!world.field_72995_K && ProjectEConfig.pedestalCooldown.harvestPedCooldown != -1) {
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof DMPedestalTile)) {
                return;
            }
            DMPedestalTile tile = (DMPedestalTile)te;
            if (tile.getActivityCooldown() == 0) {
                WorldHelper.growNearbyRandomly(true, world, pos, null);
                tile.setActivityCooldown(ProjectEConfig.pedestalCooldown.harvestPedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getPedestalDescription() {
        ArrayList<String> list = new ArrayList<String>();
        if (ProjectEConfig.pedestalCooldown.harvestPedCooldown != -1) {
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.harvestgod.pedestal1", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.harvestgod.pedestal2", (Object[])new Object[0]));
            list.add(TextFormatting.BLUE + I18n.func_135052_a((String)"pe.harvestgod.pedestal3", (Object[])new Object[]{MathUtils.tickToSecFormatted(ProjectEConfig.pedestalCooldown.harvestPedCooldown)}));
        }
        return list;
    }

    private static class StackWithSlot {
        public final int slot;
        public final ItemStack stack;

        public StackWithSlot(ItemStack stack, int slot) {
            this.stack = stack.func_77946_l();
            this.slot = slot;
        }
    }
}

