/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wit.sync;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import p455w0rd.ae2wtlib.api.networking.INetworkInfo;
import p455w0rd.wit.init.ModNetworking;
import p455w0rd.wit.sync.PacketCallState;
import p455w0rd.wit.sync.WITPacketHandlerBase;

public abstract class WITPacket
implements Packet {
    private PacketBuffer p;
    private PacketCallState caller;

    public void serverPacketData(INetworkInfo manager, WITPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a server side handler.");
    }

    public final int getPacketID() {
        return WITPacketHandlerBase.PacketTypes.getID(this.getClass()).ordinal();
    }

    public void clientPacketData(INetworkInfo network, WITPacket packet, EntityPlayer player) {
        throw new UnsupportedOperationException("This packet ( " + this.getPacketID() + " does not implement a client side handler.");
    }

    protected void configureWrite(ByteBuf data) {
        data.capacity(data.readableBytes());
        this.p = new PacketBuffer(data);
    }

    public FMLProxyPacket getProxy() {
        if (this.p.array().length > 0x200000) {
            throw new IllegalArgumentException("Sorry AE2 made a " + this.p.array().length + " byte packet by accident!");
        }
        FMLProxyPacket pp = new FMLProxyPacket(this.p, ModNetworking.instance().getChannel());
        return pp;
    }

    public void func_148837_a(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public void func_148840_b(PacketBuffer buf) throws IOException {
        throw new RuntimeException("Not Implemented");
    }

    public ByteArrayInputStream getPacketByteArray(ByteBuf stream, int readerIndex, int readableBytes) {
        ByteArrayInputStream bytes;
        if (stream.hasArray()) {
            bytes = new ByteArrayInputStream(stream.array(), readerIndex, readableBytes);
        } else {
            byte[] data = new byte[stream.capacity()];
            stream.getBytes(readerIndex, data, 0, readableBytes);
            bytes = new ByteArrayInputStream(data);
        }
        return bytes;
    }

    public ByteArrayInputStream getPacketByteArray(ByteBuf stream) {
        return this.getPacketByteArray(stream, 0, stream.readableBytes());
    }

    public void setCallParam(PacketCallState call) {
        this.caller = call;
    }

    public void func_148833_a(INetHandler handler) {
        this.caller.call(this);
    }
}

