/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.jeid;

import java.util.ListIterator;
import java.util.function.Predicate;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.dimdev.jeid.ASMException;
import org.dimdev.jeid.Obf;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class JEIDTransformer
implements IClassTransformer {
    public static RegistryNamespaced<ResourceLocation, Potion> REGISTRY;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        ClassNode cn;
        ClassReader cr;
        if (transformedName.equals("net.minecraft.client.network.NetHandlerPlayClient")) {
            return this.transformNetHandlerPlayClient(basicClass);
        }
        if (transformedName.equals("net.minecraft.potion.PotionEffect")) {
            return this.transformPotionEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.network.play.server.SPacketEntityEffect")) {
            return this.transformSPacketEntityEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.network.play.server.SPacketRemoveEntityEffect")) {
            return this.transformSPacketRemoveEntityEffect(basicClass);
        }
        if (transformedName.equals("net.minecraft.item.ItemStack")) {
            return this.transformItemStack(basicClass);
        }
        if (transformedName.equals("net.minecraft.nbt.NBTTagCompound")) {
            cr = new ClassReader(basicClass);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (!cn.name.equals(Obf.NBTTagCompound)) {
                throw new ASMException("The class NBTTagCompound has broken mappings, should be " + cn.name);
            }
        }
        if (transformedName.equals("net.minecraft.network.PacketBuffer")) {
            cr = new ClassReader(basicClass);
            cn = new ClassNode();
            cr.accept((ClassVisitor)cn, 0);
            if (!cn.name.equals(Obf.PacketBuffer)) {
                throw new ASMException("The class PacketBuffer has broken mappings, should be " + cn.name);
            }
        }
        return basicClass;
    }

    private static MethodNode locateMethod(ClassNode cn, String desc, String ... namesIn) {
        return cn.methods.stream().filter(n -> n.desc.equals(desc) && JEIDTransformer.anyMatch(namesIn, n.name)).findAny().orElseThrow(() -> new ASMException(JEIDTransformer.getNames(namesIn) + ": " + desc + " cannot be found in " + cn.name, cn));
    }

    private static boolean anyMatch(String[] pool, String match) {
        for (String s : pool) {
            if (!s.equals(match)) continue;
            return true;
        }
        return false;
    }

    private static String getNames(String[] pool) {
        StringBuilder sb = new StringBuilder();
        for (String s : pool) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private static AbstractInsnNode locateTargetInsn(MethodNode mn, Predicate<AbstractInsnNode> filter) {
        AbstractInsnNode target = null;
        ListIterator i = mn.instructions.iterator();
        while (i.hasNext() && target == null) {
            AbstractInsnNode n = (AbstractInsnNode)i.next();
            if (!filter.test(n)) continue;
            target = n;
        }
        if (target == null) {
            throw new ASMException("Can't locate target instruction in " + mn.name, mn);
        }
        return target;
    }

    private byte[] transformItemStack(byte[] basicClass) {
        String getIntegerName;
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (!cn.name.equals(Obf.ItemStack)) {
            throw new ASMException("The class ItemStack has broken mappings, should be " + cn.name);
        }
        String descAddEnch = "(L" + Obf.Enchantment + ";I)V";
        MethodNode mn = JEIDTransformer.locateMethod(cn, descAddEnch, "addEnchantment", "func_77966_a", "a");
        String setIntegerName = Obf.isDeobf() ? "setInteger" : "func_74768_a";
        mn.instructions.remove(JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 147));
        AbstractInsnNode target2 = JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 182 && n.getPrevious().getPrevious().getPrevious().getOpcode() == 18 && ((LdcInsnNode)n.getPrevious().getPrevious().getPrevious()).cst.toString().equals("id"));
        mn.instructions.insertBefore(target2, (AbstractInsnNode)new MethodInsnNode(182, Obf.NBTTagCompound, setIntegerName, "(Ljava/lang/String;I)V", false));
        mn.instructions.remove(target2);
        String descr = "(L" + Obf.EntityPlayer + ";L" + Obf.ITooltipFlag + ";)Ljava/util/List;";
        String string = getIntegerName = Obf.isDeobf() ? "getInteger" : "func_74762_e";
        if (FMLLaunchHandler.side().isClient()) {
            MethodNode mn2 = JEIDTransformer.locateMethod(cn, descr, "func_82840_a", "getTooltip", "a");
            AbstractInsnNode target = JEIDTransformer.locateTargetInsn(mn2, n -> n.getOpcode() == 182 && n.getPrevious().getOpcode() == 18 && ((LdcInsnNode)n.getPrevious()).cst.toString().equals("id"));
            mn.instructions.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.NBTTagCompound, getIntegerName, "(Ljava/lang/String;)I", false));
            mn.instructions.remove(target);
        }
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformSPacketRemoveEntityEffect(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        String descriptors = "(L" + Obf.PacketBuffer + ";)V";
        MethodNode rpd = JEIDTransformer.locateMethod(cn, descriptors, "readPacketData", "a");
        AbstractInsnNode target = JEIDTransformer.locateTargetInsn(rpd, n -> n.getOpcode() == 182 && ((MethodInsnNode)n).name.equals("readUnsignedByte"));
        rpd.instructions.insert(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, "readInt", "()I", false));
        rpd.instructions.remove(target);
        MethodNode wpd = JEIDTransformer.locateMethod(cn, descriptors, "writePacketData", "b");
        target = JEIDTransformer.locateTargetInsn(wpd, n -> n.getOpcode() == 182 && ((MethodInsnNode)n).name.equals("writeByte"));
        wpd.instructions.insert(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, "writeInt", "(I)Lio/netty/buffer/ByteBuf;", false));
        wpd.instructions.remove(target);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformSPacketEntityEffect(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (!Obf.SPacketEntityEffect.equals(cn.name)) {
            // empty if block
        }
        cn.fields.add(new FieldNode(1, "effectInt", "I", null, (Object)0));
        MethodNode mn_init = JEIDTransformer.locateMethod(cn, "(IL" + Obf.PotionEffect + ";)V", "<init>", "<init>");
        ListIterator i = mn_init.instructions.iterator();
        AbstractInsnNode targetNode = null;
        int line = 0;
        while (i.hasNext() && targetNode == null) {
            AbstractInsnNode node = (AbstractInsnNode)i.next();
            if (!(node instanceof LineNumberNode)) continue;
            if (line == 1) {
                targetNode = node;
            }
            ++line;
        }
        if (targetNode == null) {
            throw new RuntimeException("Can't find target node for SPacketEntityEffect constructor");
        }
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(this.getClass()), "getIdFromPotEffect", "(L" + Obf.PotionEffect + ";)I", false));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new VarInsnNode(25, 2));
        mn_init.instructions.insert(targetNode, (AbstractInsnNode)new VarInsnNode(25, 0));
        MethodNode mn_empty_init = JEIDTransformer.locateMethod(cn, "()V", "<init>", "<init>");
        AbstractInsnNode tgt = JEIDTransformer.locateTargetInsn(mn_empty_init, n -> n.getOpcode() == 177);
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new LdcInsnNode((Object)0));
        mn_empty_init.instructions.insertBefore(tgt, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        MethodNode mn_readPacket = JEIDTransformer.locateMethod(cn, "(L" + Obf.PacketBuffer + ";)V", "readPacketData", "a");
        String readVarInt_name = Obf.isDeobf() ? "readVarInt" : "g";
        AbstractInsnNode target = JEIDTransformer.locateTargetInsn(mn_readPacket, n -> n.getOpcode() == 177).getPrevious().getPrevious();
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new VarInsnNode(25, 1));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, readVarInt_name, "()I", false));
        mn_readPacket.instructions.insertBefore(target, (AbstractInsnNode)new FieldInsnNode(181, Obf.SPacketEntityEffect, "effectInt", "I"));
        MethodNode mn_writePacket = JEIDTransformer.locateMethod(cn, "(L" + Obf.PacketBuffer + ";)V", "writePacketData", "b");
        String writeVarInt_name = Obf.isDeobf() ? "writeVarInt" : "d";
        AbstractInsnNode wp_target = JEIDTransformer.locateTargetInsn(mn_writePacket, n -> n.getOpcode() == 177).getPrevious().getPrevious();
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new VarInsnNode(25, 1));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new VarInsnNode(25, 0));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new FieldInsnNode(180, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new MethodInsnNode(182, Obf.PacketBuffer, writeVarInt_name, "(I)L" + Obf.PacketBuffer + ";", false));
        mn_writePacket.instructions.insertBefore(wp_target, (AbstractInsnNode)new InsnNode(87));
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformPotionEffect(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (!cn.name.equals(Obf.PotionEffect)) {
            throw new RuntimeException("Mapping mismatch! PotionEffect is " + cn.name + ", not " + Obf.PotionEffect);
        }
        MethodNode mn = JEIDTransformer.locateMethod(cn, "(L" + Obf.NBTTagCompound + ";)L" + Obf.NBTTagCompound + ";", "writeCustomPotionEffectToNBT", "a");
        AbstractInsnNode ant = JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 145);
        String mname = Obf.isDeobf() ? "setInteger" : "a";
        MethodInsnNode call = new MethodInsnNode(182, Obf.NBTTagCompound, mname, "(Ljava/lang/String;I)V", false);
        mn.instructions.remove(ant.getNext());
        mn.instructions.insert(ant, (AbstractInsnNode)call);
        mn.instructions.remove(ant);
        MethodNode mn2 = JEIDTransformer.locateMethod(cn, "(L" + Obf.NBTTagCompound + ";)L" + Obf.PotionEffect + ";", "readCustomPotionEffectFromNBT", "b");
        AbstractInsnNode ant2 = JEIDTransformer.locateTargetInsn(mn2, n -> n.getOpcode() == 182);
        String name2 = Obf.isDeobf() ? "getInteger" : "h";
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.remove(ant2.getNext());
        mn2.instructions.insert(ant2, (AbstractInsnNode)new MethodInsnNode(182, Obf.NBTTagCompound, name2, "(Ljava/lang/String;)I", false));
        mn2.instructions.remove(ant2);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    private byte[] transformNetHandlerPlayClient(byte[] basicClass) {
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        MethodNode mn = JEIDTransformer.locateMethod(cn, "(L" + Obf.SPacketEntityEffect + ";)V", "handleEntityEffect", "a");
        AbstractInsnNode target = JEIDTransformer.locateTargetInsn(mn, n -> n.getOpcode() == 17);
        mn.instructions.remove(target.getPrevious());
        mn.instructions.remove(target.getNext());
        mn.instructions.insertBefore(target, (AbstractInsnNode)new FieldInsnNode(180, Obf.SPacketEntityEffect, "effectInt", "I"));
        mn.instructions.remove(target);
        ClassWriter cw = new ClassWriter(3);
        cn.accept((ClassVisitor)cw);
        return cw.toByteArray();
    }

    public static int getIdFromPotEffect(PotionEffect pe) {
        return REGISTRY.func_148757_b((Object)pe.func_188419_a());
    }
}

