/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes;

import buildcraft.additionalpipes.utils.Log;
import buildcraft.lib.registry.RegistryConfig;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class APConfiguration {
    public static int chunkSightRange;
    public static boolean chunkSightAutorefresh;
    public static boolean enableDebugLog;
    public static boolean enableChunkloaderRecipe;
    public static int laserKeyCode;
    public static float powerTransmittanceCfg;
    public static int waterPumpWaterPerTick;
    public static int gravityFeedPipeTicksPerPull;
    public static boolean enableTriggers;
    public static boolean filterRightclicks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigs(File configFile) {
        Configuration config = new Configuration(configFile);
        try {
            config.load();
            Property powerTransmittance = config.get("general", "powerTransmittance", 90);
            powerTransmittance.setComment("Percentage of power a power teleport pipe transmits. Between 0 and 100.");
            powerTransmittanceCfg = (float)powerTransmittance.getInt() / 100.0f;
            if ((double)powerTransmittanceCfg > 1.0) {
                powerTransmittanceCfg = 1.0f;
            } else if ((double)powerTransmittanceCfg < 0.0) {
                powerTransmittanceCfg = 0.0f;
            }
            Property chunkSightRangeProperty = config.get("general", "chunkSightRange", 8);
            chunkSightRangeProperty.setComment("Range of chunk load boundaries.");
            chunkSightRange = chunkSightRangeProperty.getInt();
            Property laserKey = config.get("general", "laserKeyChar", 68);
            laserKey.setComment("Default key to toggle chunk load boundaries.");
            laserKeyCode = laserKey.getInt();
            Property filterRightclicksProperty = config.get("general", "filterRightclicks", false);
            filterRightclicksProperty.setComment("When right clicking on something with a gui, do not show the gui if you have a pipe in your hand");
            filterRightclicks = filterRightclicksProperty.getBoolean();
            Property enableDebugLogProperty = config.get("general", "enableDebugLog", false);
            enableDebugLogProperty.setComment("Enable debug logging for development");
            enableDebugLog = enableDebugLogProperty.getBoolean();
            Property waterPerTickProperty = config.get("general", "waterPumpWaterPerTick", 90);
            waterPerTickProperty.setComment("Amount of water the Water Pump Pipe produces in millibuckets/tick");
            waterPumpWaterPerTick = waterPerTickProperty.getInt();
            Property gpPullRateProperty = config.get("general", "gravityFeedPipeTicksPerPull", 48);
            gpPullRateProperty.setComment("How many ticks the Gravity Feed Pipe needs to extract an item");
            gravityFeedPipeTicksPerPull = gpPullRateProperty.getInt();
            Property enableChunkloaderProperty = config.get("general", "enableChunkloaderRecipe", true);
            enableChunkloaderProperty.setComment("Whether or not the chunkloader will have a crafting recipe.  Set to false to make it a creative-only item.");
            enableChunkloaderRecipe = enableChunkloaderProperty.getBoolean();
        }
        catch (Exception e) {
            Log.error("Error loading Additional Pipes configs." + e);
        }
        finally {
            config.save();
            RegistryConfig.setRegistryConfig((String)"additionalpipes", (Configuration)config);
        }
    }

    static {
        chunkSightAutorefresh = true;
        enableTriggers = true;
        filterRightclicks = false;
    }
}

