/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.APConfiguration;
import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.TeleportPipeType;
import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.transport.pipe.flow.IPipeTransportPowerHook;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import buildcraft.transport.tile.TilePipeHolder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class PipeBehaviorTeleportPower
extends PipeBehaviorTeleport
implements IPipeTransportPowerHook {
    public PipeBehaviorTeleportPower(IPipe pipe, NBTTagCompound tagCompound) {
        super(pipe, tagCompound, TeleportPipeType.POWER);
    }

    public PipeBehaviorTeleportPower(IPipe pipe) {
        super(pipe, TeleportPipeType.POWER);
    }

    public int requestPower(EnumFacing from, long value) {
        int requested = 0;
        if (!this.canReceive()) {
            return requested;
        }
        ArrayList<ITeleportPipe> pipeList = TeleportManager.instance.getConnectedPipes(this, true, false);
        if (pipeList.size() <= 0) {
            return requested;
        }
        for (PipeBehaviorTeleportPower pipeBehaviorTeleportPower : pipeList) {
            LinkedList<EnumFacing> possibleMovements = PipeBehaviorTeleportPower.getRealPossibleMovements(pipeBehaviorTeleportPower);
            for (EnumFacing orientation : possibleMovements) {
                IPipe nearbyPipe = pipeBehaviorTeleportPower.pipe.getConnectedPipe(from);
                PipeFlowPower pipeFlowPower = (PipeFlowPower)nearbyPipe.getFlow();
            }
        }
        return requested;
    }

    public int receivePower(EnumFacing from, long energy) {
        ArrayList<ITeleportPipe> connectedPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
        LinkedList<PipeBehaviorTeleportPower> sendingToList = new LinkedList<PipeBehaviorTeleportPower>();
        if (connectedPipes.size() <= 0 || (this.state & 1) == 0) {
            return 0;
        }
        for (PipeBehaviorTeleportPower pipeBehaviorTeleportPower : connectedPipes) {
            if (this.getPowerRequestsByNeighbors(pipeBehaviorTeleportPower).size() <= 0) continue;
            sendingToList.add(pipeBehaviorTeleportPower);
        }
        if (sendingToList.size() <= 0) {
            Log.debug("No pipes want power on channel " + this.getFrequency());
            return 0;
        }
        double powerToSend = APConfiguration.powerTransmittanceCfg * (float)energy / (float)sendingToList.size();
        for (PipeBehaviorTeleportPower receiver : sendingToList) {
            List<PowerRequest> needsPower = this.getPowerRequestsByNeighbors(receiver);
            if (needsPower.size() <= 0) continue;
            int dividedPowerToSend = MathHelper.func_76143_f((double)(powerToSend / (double)needsPower.size()));
            for (PowerRequest powerEntry : needsPower) {
                if (powerEntry.isPipe) {
                    PipeFlowPower pipeFlowPower = (PipeFlowPower)((TilePipeHolder)powerEntry.tile).getPipe().getFlow();
                    continue;
                }
                if (powerEntry.tile.hasCapability(MjAPI.CAP_RECEIVER, powerEntry.orientation)) {
                    IMjReceiver recv = (IMjReceiver)powerEntry.tile.getCapability(MjAPI.CAP_RECEIVER, powerEntry.orientation);
                    recv.receivePower((long)dividedPowerToSend, false);
                    continue;
                }
                Log.error("Don't know how to transmit power to tile " + powerEntry.tile.toString());
            }
        }
        return (int)energy;
    }

    private List<PowerRequest> getPowerRequestsByNeighbors(PipeBehaviorTeleportPower pipe) {
        LinkedList<EnumFacing> possibleMovements = PipeBehaviorTeleportPower.getRealPossibleMovements(pipe);
        LinkedList<PowerRequest> needsPower = new LinkedList<PowerRequest>();
        if (possibleMovements.size() > 0) {
            for (EnumFacing orientation : possibleMovements) {
                TileEntity tile = pipe.pipe.getConnectedTile(orientation);
                if (tile instanceof TilePipeHolder) {
                    TilePipeHolder adjacentPipe = (TilePipeHolder)tile;
                    if (!PipeBehaviorTeleportPower.pipeNeedsPower(adjacentPipe)) continue;
                    needsPower.add(new PowerRequest((TileEntity)adjacentPipe, orientation.func_176734_d()));
                    continue;
                }
                if (tile == null || this.getPowerRequestedByTileEntity(tile, orientation) <= 0L) continue;
                needsPower.add(new PowerRequest(tile, orientation.func_176734_d()));
            }
        }
        return needsPower;
    }

    private static boolean pipeNeedsPower(TilePipeHolder tile) {
        if (tile.getPipe().getFlow() instanceof PipeFlowPower) {
            PipeFlowPower flowPower = (PipeFlowPower)tile.getPipe().getFlow();
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            }
        }
        return false;
    }

    private long getPowerRequestedByTileEntity(TileEntity tile, EnumFacing sideOnPipe) {
        long requested;
        long power = 0L;
        IMjReceiver recv = (IMjReceiver)this.pipe.getHolder().getCapabilityFromPipe(sideOnPipe, MjAPI.CAP_RECEIVER);
        if (recv != null && recv.canReceive() && (requested = recv.getPowerRequested()) > 0L) {
            power += requested;
        }
        return power;
    }

    private static LinkedList<EnumFacing> getRealPossibleMovements(PipeBehaviorTeleportPower pipe) {
        LinkedList<EnumFacing> result = new LinkedList<EnumFacing>();
        for (EnumFacing orientation : EnumFacing.values()) {
            if (!pipe.pipe.isConnected(orientation) || pipe.pipe.getConnectedType(orientation) != IPipe.ConnectedType.PIPE) continue;
            result.add(orientation);
        }
        return result;
    }

    private static class PowerRequest {
        public final TileEntity tile;
        public final EnumFacing orientation;
        public final boolean isPipe;

        public PowerRequest(TileEntity te, EnumFacing o) {
            this.tile = te;
            this.orientation = o;
            this.isPipe = te instanceof IPipeHolder;
        }
    }
}

