/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.block;

import appeng.api.util.AEPartLocation;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseTileBlock;
import com.github.vfyjxf.ae2utilities.network.Ae2uGuiHandler;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceBase;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier1;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier2;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier3;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockEnhancedInterface
extends AEBaseTileBlock {
    public static final int MAX_TIER = 3;
    private static final PropertyBool OMNIDIRECTIONAL = PropertyBool.func_177716_a((String)"omnidirectional");
    private static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private final int tier;

    public BlockEnhancedInterface(int tier) {
        super(Material.field_151573_f);
        if (tier == 1) {
            this.setTileEntity(TileEnhancedInterfaceTier1.class);
        } else if (tier == 2) {
            this.setTileEntity(TileEnhancedInterfaceTier2.class);
        } else if (tier == 3) {
            this.setTileEntity(TileEnhancedInterfaceTier3.class);
        }
        this.tier = tier;
    }

    protected IProperty<?>[] getAEStates() {
        return new IProperty[]{OMNIDIRECTIONAL};
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{OMNIDIRECTIONAL, FACING});
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEnhancedInterfaceBase te = (TileEnhancedInterfaceBase)this.getTileEntity(world, pos);
        return te == null ? state : state.func_177226_a((IProperty)OMNIDIRECTIONAL, (Comparable)Boolean.valueOf(te.isOmniDirectional())).func_177226_a((IProperty)FACING, (Comparable)te.getForward());
    }

    public boolean onActivated(World world, BlockPos pos, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEnhancedInterfaceBase) {
            if (!world.field_72995_K) {
                Ae2uGuiHandler.openGui(player, this.tier, tile, AEPartLocation.fromFacing((EnumFacing)side));
            }
            return true;
        }
        return false;
    }

    @Nullable
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        switch (this.tier) {
            case 2: {
                return new TileEnhancedInterfaceTier2();
            }
            case 3: {
                return new TileEnhancedInterfaceTier3();
            }
        }
        return new TileEnhancedInterfaceTier1();
    }

    protected boolean hasCustomRotation() {
        return true;
    }

    protected void customRotateBlock(IOrientable rotatable, EnumFacing axis) {
        if (rotatable instanceof TileEnhancedInterfaceBase) {
            ((TileEnhancedInterfaceBase)rotatable).setSide(axis);
        }
    }
}

