/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.ae2utilities.mixins;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterface;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.helpers.ItemHandlerUtil;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.inv.WrapperFilteredItemHandler;
import appeng.util.inv.WrapperRangeItemHandler;
import appeng.util.inv.filter.IAEItemFilter;
import com.github.vfyjxf.ae2utilities.parts.PartEnhancedInterfaceTier1;
import com.github.vfyjxf.ae2utilities.parts.PartEnhancedInterfaceTier2;
import com.github.vfyjxf.ae2utilities.parts.PartEnhancedInterfaceTier3;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier1;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier2;
import com.github.vfyjxf.ae2utilities.tile.TileEnhancedInterfaceTier3;
import com.github.vfyjxf.ae2utilities.utils.InvTracker;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ContainerInterfaceTerminal.class}, remap=false)
public abstract class MixinContainerInterfaceTerminal
extends AEBaseContainer {
    @Shadow
    private IGrid grid;
    @Shadow
    private NBTTagCompound data;
    private final Map<IInterfaceHost, InvTracker> ifTrackerMap = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> idMap = new HashMap<Long, InvTracker>();

    private MixinContainerInterfaceTerminal(InventoryPlayer ip, Object anchor) {
        super(ip, anchor);
    }

    @Shadow
    protected abstract boolean isDifferent(ItemStack var1, ItemStack var2);

    @Overwrite
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()).isActive()) {
            DualityInterface dual;
            InvTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.ifTrackerMap.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.getUnlocalizedName().equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.ifTrackerMap.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.getUnlocalizedName().equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.getEnhancedInterface()) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.ifTrackerMap.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.getUnlocalizedName().equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.ifTrackerMap.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, InvTracker> en : this.ifTrackerMap.entrySet()) {
                InvTracker inv = en.getValue();
                for (int x = 0; x < inv.getServer().getSlots(); ++x) {
                    if (!this.isDifferent(inv.getServer().getStackInSlot(x), inv.getClient().getStackInSlot(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance().sendTo((AppEngPacket)new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    @Overwrite
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.idMap.get(id);
        if (inv != null) {
            ItemStack is = inv.getServer().getStackInSlot(slot);
            boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
            AdaptorItemHandler playerHand = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(player.field_71071_by));
            WrapperFilteredItemHandler theSlot = new WrapperFilteredItemHandler((IItemHandler)new WrapperRangeItemHandler(inv.getServer(), slot, slot + 1), new IAEItemFilter(){

                public boolean allowExtract(IItemHandler inv, int slot, int amount) {
                    return true;
                }

                public boolean allowInsert(IItemHandler inv, int slot, ItemStack stack) {
                    return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemEncodedPattern;
                }
            });
            AdaptorItemHandler interfaceSlot = new AdaptorItemHandler((IItemHandler)theSlot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemStack inSlot = theSlot.getStackInSlot(0);
                        if (inSlot.func_190926_b()) {
                            player.field_71071_by.func_70437_b(interfaceSlot.addItems(player.field_71071_by.func_70445_o()));
                            break;
                        }
                        inSlot = inSlot.func_77946_l();
                        ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(interfaceSlot.addItems(inHand.func_77946_l()));
                        if (player.field_71071_by.func_70445_o().func_190926_b()) {
                            player.field_71071_by.func_70437_b(inSlot);
                            break;
                        }
                        player.field_71071_by.func_70437_b(inHand);
                        ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)inSlot);
                        break;
                    }
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)playerHand.addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        ItemStack extra = playerHand.removeItems(1, ItemStack.field_190927_a, null);
                        if (!extra.func_190926_b()) {
                            extra = interfaceSlot.addItems(extra);
                        }
                        if (extra.func_190926_b()) break;
                        playerHand.addItems(extra);
                        break;
                    }
                    if (is.func_190926_b()) break;
                    ItemStack extra = interfaceSlot.removeItems((is.func_190916_E() + 1) / 2, ItemStack.field_190927_a, null);
                    if (!extra.func_190926_b()) {
                        extra = playerHand.addItems(extra);
                    }
                    if (extra.func_190926_b()) break;
                    interfaceSlot.addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    ItemHandlerUtil.setStackInSlot((IItemHandler)theSlot, (int)0, (ItemStack)playerInv.addItems(theSlot.getStackInSlot(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor((EntityPlayer)player);
                    for (int x = 0; x < inv.getServer().getSlots(); ++x) {
                        ItemHandlerUtil.setStackInSlot((IItemHandler)inv.getServer(), (int)x, (ItemStack)playerInvAd.addItems(inv.getServer().getStackInSlot(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                    player.field_71071_by.func_70437_b(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    @Overwrite
    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.idMap.clear();
        this.ifTrackerMap.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()).isActive()) {
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.ifTrackerMap.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.ifTrackerMap.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.getEnhancedInterface()) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.ifTrackerMap.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.ifTrackerMap.entrySet()) {
            InvTracker inv = en.getValue();
            this.idMap.put(inv.getWhich(), inv);
            this.addItems(data, inv, 0, inv.getServer().getSlots());
        }
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.getWhich(), 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.getSortBy());
            tag.func_74778_a("un", inv.getUnlocalizedName());
            tag.func_74768_a("tier", inv.getTier());
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.getServer().getStackInSlot(x + offset);
            ItemHandlerUtil.setStackInSlot((IItemHandler)inv.getClient(), (int)(x + offset), (ItemStack)(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l()));
            if (!is.func_190926_b()) {
                is.func_77955_b(itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    private Set<IGridNode> getEnhancedInterface() {
        HashSet<IGridNode> set = new HashSet<IGridNode>();
        for (IGridNode gn : this.grid.getMachines(TileEnhancedInterfaceTier1.class)) {
            set.add(gn);
        }
        for (IGridNode gn : this.grid.getMachines(TileEnhancedInterfaceTier2.class)) {
            set.add(gn);
        }
        for (IGridNode gn : this.grid.getMachines(TileEnhancedInterfaceTier3.class)) {
            set.add(gn);
        }
        for (IGridNode gn : this.grid.getMachines(PartEnhancedInterfaceTier1.class)) {
            set.add(gn);
        }
        for (IGridNode gn : this.grid.getMachines(PartEnhancedInterfaceTier2.class)) {
            set.add(gn);
        }
        for (IGridNode gn : this.grid.getMachines(PartEnhancedInterfaceTier3.class)) {
            set.add(gn);
        }
        return set;
    }
}

